/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationFailureException;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.LoginCredentials;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.UserVerifier;
import oracle.kv.impl.security.login.LoginErrorTracker;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.security.login.SessionManager;
import oracle.kv.impl.topo.ResourceId;

public class UserLoginHandler {
    public static final int SESSION_ID_RANDOM_BYTES = 16;
    private static final int DEF_ACCT_ERR_LCK_INT = 600;
    private static final int DEF_ACCT_ERR_LCK_CNT = 10;
    private static final int DEF_ACCT_ERR_LCK_TMO = 600;
    private volatile ResourceId ownerId;
    private volatile boolean localOwnerId;
    private final SessionManager sessMgr;
    private final UserVerifier userVerifier;
    private volatile long sessionLifetime;
    private volatile boolean allowExtension;
    protected final Logger logger;
    private volatile LoginErrorTracker errorTracker;

    public UserLoginHandler(ResourceId ownerId, boolean localOwnerId, UserVerifier userVerifier, SessionManager sessionManager, LoginConfig loginConfig, Logger logger) {
        this.logger = logger;
        this.ownerId = ownerId;
        this.localOwnerId = localOwnerId;
        this.sessMgr = sessionManager;
        this.userVerifier = userVerifier;
        this.sessionLifetime = loginConfig.sessionLifetime;
        this.allowExtension = loginConfig.allowExtension;
        this.errorTracker = this.makeErrorTracker(loginConfig);
    }

    private LoginErrorTracker makeErrorTracker(LoginConfig loginConfig) {
        return new LoginErrorTracker(loginConfig.acctErrLockoutInt == 0L ? 600L : loginConfig.acctErrLockoutInt, loginConfig.acctErrLockoutCnt == 0 ? 10 : loginConfig.acctErrLockoutCnt, loginConfig.acctErrLockoutTMO == 0L ? 600L : loginConfig.acctErrLockoutTMO, this.logger);
    }

    public LoginResult login(LoginCredentials creds, String clientHost) throws AuthenticationFailureException {
        if (creds instanceof ProxyCredentials) {
            throw new AuthenticationFailureException("Invalid use of ProxyCredentials.");
        }
        return this.loginInternal(creds, clientHost);
    }

    public LoginResult proxyLogin(ProxyCredentials creds, String clientHost) throws AuthenticationFailureException {
        return this.loginInternal(creds, clientHost);
    }

    public LoginToken requestSessionExtension(LoginToken loginToken) throws SessionAccessException {
        if (loginToken == null) {
            return null;
        }
        if (!this.allowExtension) {
            this.logger.fine("Session extend not allowed");
            return null;
        }
        LoginSession session = this.sessMgr.lookupSession(new LoginSession.Id(loginToken.getSessionId().getIdValue()));
        if (session == null || session.isExpired()) {
            this.logger.info("Session " + loginToken.getSessionId().hashId() + ": extend failed due to expiration");
            return null;
        }
        long newExpire = this.sessionLifetime == 0L ? 0L : System.currentTimeMillis() + this.sessionLifetime;
        this.logger.info("Session extend allowed");
        LoginSession newSession = this.sessMgr.updateSessionExpiration(session.getId(), newExpire);
        if (newSession == null) {
            this.logger.info("Session " + session.getId().hashId() + ": update failed");
            return null;
        }
        SessionId sid = newSession.isPersistent() ? new SessionId(newSession.getId().getValue()) : new SessionId(newSession.getId().getValue(), this.getScope(), this.ownerId);
        return new LoginToken(sid, newSession.getExpireTime());
    }

    public Subject validateLoginToken(LoginToken loginToken) throws SessionAccessException {
        if (loginToken == null) {
            return null;
        }
        LoginSession session = this.sessMgr.lookupSession(new LoginSession.Id(loginToken.getSessionId().getIdValue()));
        if (session == null || session.isExpired()) {
            return null;
        }
        return this.userVerifier.verifyUser(session.getSubject());
    }

    public void logout(LoginToken loginToken) throws AuthenticationRequiredException, SessionAccessException {
        if (loginToken == null) {
            throw new AuthenticationRequiredException("LoginToken is null", true);
        }
        LoginSession session = this.sessMgr.lookupSession(new LoginSession.Id(loginToken.getSessionId().getIdValue()));
        if (session == null || session.isExpired()) {
            throw new AuthenticationRequiredException("session is not valid", true);
        }
        this.sessMgr.logoutSession(session.getId());
    }

    protected LoginResult createLoginSession(Subject subject, String clientHost) {
        long expireTime = this.sessionLifetime != 0L ? System.currentTimeMillis() + this.sessionLifetime : 0L;
        LoginSession session = this.sessMgr.createSession(subject, clientHost, expireTime);
        SessionId sid = session.isPersistent() ? new SessionId(session.getId().getValue()) : new SessionId(session.getId().getValue(), this.getScope(), this.ownerId);
        return new LoginResult(new LoginToken(sid, session.getExpireTime()));
    }

    protected SessionId.IdScope getScope() {
        return this.localOwnerId ? SessionId.IdScope.LOCAL : SessionId.IdScope.STORE;
    }

    public void updateConfig(LoginConfig config) {
        this.sessionLifetime = config.sessionLifetime;
        this.allowExtension = config.allowExtension;
        this.errorTracker = this.makeErrorTracker(config);
    }

    private LoginResult loginInternal(LoginCredentials creds, String clientHost) throws AuthenticationFailureException {
        Subject subject = null;
        if (creds == null) {
            throw new AuthenticationFailureException("No credentials provided.");
        }
        if (this.errorTracker.isAccountLocked(creds.getUsername(), clientHost)) {
            throw new AuthenticationFailureException("User account is locked.");
        }
        subject = this.userVerifier.verifyUser(creds);
        if (subject == null) {
            this.errorTracker.noteLoginError(creds.getUsername(), clientHost);
            this.logger.info("Failed login attempt by user " + creds.getUsername());
            throw new AuthenticationFailureException("Authentication failed");
        }
        this.errorTracker.noteLoginSuccess(creds.getUsername(), clientHost);
        this.logger.info("Successful login by user " + creds.getUsername());
        return this.createLoginSession(subject, clientHost);
    }

    public void updateOwner(ResourceId id) {
        this.ownerId = id;
        this.localOwnerId = false;
    }

    public ResourceId getOwnerId() {
        return this.ownerId;
    }

    public static class LoginConfig {
        private long sessionLifetime;
        private boolean allowExtension;
        private long acctErrLockoutInt;
        private int acctErrLockoutCnt;
        private long acctErrLockoutTMO;

        public LoginConfig setSessionLifetime(long lifetimeMs) {
            this.sessionLifetime = lifetimeMs;
            return this;
        }

        public LoginConfig setAllowExtension(boolean allowExtend) {
            this.allowExtension = allowExtend;
            return this;
        }

        public LoginConfig setAcctErrLockoutInt(long lockoutIntervalMs) {
            this.acctErrLockoutInt = lockoutIntervalMs;
            return this;
        }

        public LoginConfig setAcctErrLockoutCnt(int lockoutCount) {
            this.acctErrLockoutCnt = lockoutCount;
            return this;
        }

        public LoginConfig setAcctErrLockoutTMO(long lockoutTMOMs) {
            this.acctErrLockoutTMO = lockoutTMOMs;
            return this;
        }

        public LoginConfig clone() {
            LoginConfig dup = new LoginConfig();
            dup.sessionLifetime = this.sessionLifetime;
            dup.allowExtension = this.allowExtension;
            dup.acctErrLockoutInt = this.acctErrLockoutInt;
            dup.acctErrLockoutCnt = this.acctErrLockoutCnt;
            dup.acctErrLockoutTMO = this.acctErrLockoutTMO;
            return dup;
        }

        public static LoginConfig buildLoginConfig(GlobalParams gp) {
            LoginConfig config = new LoginConfig();
            if (gp != null) {
                long sessionLifetimeInMillis = gp.getSessionTimeoutUnit().toMillis(gp.getSessionTimeout());
                int acctErrLockoutTMOInSeconds = (int)gp.getAcctErrLockoutTimeoutUnit().toMillis(gp.getAcctErrLockoutTimeout());
                int acctErrLockoutIntInSeconds = (int)gp.getAcctErrLockoutThrIntUnit().toMillis(gp.getAcctErrLockoutThrInt());
                config.setAcctErrLockoutCnt(gp.getAcctErrLockoutThrCount()).setSessionLifetime(sessionLifetimeInMillis).setAllowExtension(gp.getSessionExtendAllow()).setAcctErrLockoutTMO(acctErrLockoutTMOInSeconds).setAcctErrLockoutInt(acctErrLockoutIntInSeconds);
            }
            return config;
        }
    }
}

