/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.HashSet;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.login.LoginResult;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.security.login.LoginTable;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.topo.ResourceId;

public class TrustedLoginHandler {
    private static final int CAPACITY = 10000;
    private static final int SESSION_ID_RANDOM_BYTES = 16;
    private LoginTable sessMgr;
    private ResourceId ownerId;
    private final boolean localId;
    private volatile long sessionLifetime;

    public TrustedLoginHandler(ResourceId ownerId, boolean localId) {
        this(ownerId, localId, 0L, 10000);
    }

    public TrustedLoginHandler(ResourceId ownerId, boolean localId, long sessionLifeTime, int sessionLimit) {
        this.ownerId = ownerId;
        this.localId = localId;
        this.sessionLifetime = sessionLifeTime;
        this.sessMgr = new LoginTable(sessionLimit, new byte[0], 16);
    }

    LoginResult loginInternal(String clientHost) {
        long expireTime = this.sessionLifetime == 0L ? 0L : System.currentTimeMillis() + this.sessionLifetime;
        LoginSession session = this.sessMgr.createSession(this.makeInternalSubject(), clientHost, expireTime);
        return new LoginResult(new LoginToken(new SessionId(session.getId().getValue(), this.localId ? SessionId.IdScope.LOCAL : SessionId.IdScope.STORE, this.ownerId), session.getExpireTime()));
    }

    Subject validateLoginToken(LoginToken loginToken) {
        if (loginToken == null) {
            return null;
        }
        LoginSession session = this.sessMgr.lookupSession(new LoginSession.Id(loginToken.getSessionId().getIdValue()));
        if (session == null || session.isExpired()) {
            return null;
        }
        return session.getSubject();
    }

    void logout(LoginToken loginToken) {
        if (loginToken == null) {
            throw new AuthenticationRequiredException("LoginToken is null", true);
        }
        LoginSession session = this.sessMgr.lookupSession(new LoginSession.Id(loginToken.getSessionId().getIdValue()));
        if (session == null || session.isExpired()) {
            throw new AuthenticationRequiredException("session is not valid", true);
        }
        this.sessMgr.logoutSession(session.getId());
    }

    public boolean updateSessionLimit(int newLimit) {
        return this.sessMgr.updateSessionLimit(newLimit);
    }

    public boolean updateSessionLifetime(long newLifetime) {
        if (newLifetime == this.sessionLifetime) {
            return false;
        }
        this.sessionLifetime = newLifetime;
        return true;
    }

    private Subject makeInternalSubject() {
        HashSet<KVStoreRolePrincipal> internalPrincipals = new HashSet<KVStoreRolePrincipal>();
        internalPrincipals.add(KVStoreRolePrincipal.INTERNAL);
        internalPrincipals.add(KVStoreRolePrincipal.AUTHENTICATED);
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, internalPrincipals, publicCreds, privateCreds);
    }
}

