/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import javax.security.auth.Subject;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.TokenCache;
import oracle.kv.impl.security.login.TokenResolver;

public class TokenVerifier {
    private final TokenResolver tokenResolver;
    private volatile TokenCache tokenCache;

    public TokenVerifier(CacheConfig cacheConfig, TokenResolver tokenResolver) {
        this.tokenResolver = tokenResolver;
        this.tokenCache = cacheConfig == null ? null : new TokenCache(cacheConfig.getCapacity(), cacheConfig.getTimeout(), tokenResolver);
    }

    public Subject verifyToken(LoginToken token) throws SessionAccessException {
        Subject subject;
        Subject subject2 = subject = null == this.tokenCache ? null : this.tokenCache.lookup(token);
        if (subject != null) {
            return subject;
        }
        subject = this.tokenResolver.resolve(token);
        if (subject != null && this.tokenCache != null) {
            this.tokenCache.add(token, subject);
        }
        return subject;
    }

    public boolean updateLoginCacheSize(int newSize) {
        if (newSize == this.tokenCache.getCacheSize()) {
            return false;
        }
        long entryLifeTime = this.tokenCache.getEntryLifeTime();
        TokenCache oldCache = this.tokenCache;
        this.tokenCache = new TokenCache(newSize, entryLifeTime, this.tokenResolver);
        if (oldCache != null) {
            oldCache.stop(false);
        }
        return true;
    }

    public boolean updateLoginCacheTimeout(long newTimeoutInMillis) {
        if (this.tokenCache == null || newTimeoutInMillis == this.tokenCache.getEntryLifeTime()) {
            return false;
        }
        this.tokenCache.setEntryLifeTime(newTimeoutInMillis);
        return true;
    }

    public static class CacheConfig {
        private final int capacity;
        private final long timeoutMs;

        public CacheConfig(int capacity, long timeoutMs) {
            this.capacity = capacity;
            this.timeoutMs = timeoutMs;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public long getTimeout() {
            return this.timeoutMs;
        }
    }
}

