/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.security.auth.Subject;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.SessionId;
import oracle.kv.impl.security.login.TokenResolver;

public class TokenCache {
    private static final int REFRESH_QUEUE_MAX = 100;
    private static final float LOAD_FACTOR = 0.6f;
    private final LinkedHashMap<SessionId, SessionEntry> sessionMap;
    private final int capacity;
    private volatile long entryLifetimeMax;
    private final EntryRefresher refresher;

    public TokenCache(int capacity, long entryLifetime, TokenResolver resolver) {
        this.capacity = capacity;
        this.entryLifetimeMax = entryLifetime;
        this.sessionMap = new LinkedHashMap<SessionId, SessionEntry>(capacity, 0.6f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<SessionId, SessionEntry> entry) {
                return this.size() > TokenCache.this.capacity;
            }
        };
        this.refresher = resolver == null ? null : new EntryRefresher(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject lookup(LoginToken token) {
        SessionId id = token.getSessionId();
        SessionEntry entry = null;
        LinkedHashMap<SessionId, SessionEntry> linkedHashMap = this.sessionMap;
        synchronized (linkedHashMap) {
            entry = this.sessionMap.get(id);
        }
        if (entry == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.entryLifetimeMax > 0L) {
            if (now > entry.getCreateTime() + this.entryLifetimeMax) {
                this.removeEntry(id);
                return null;
            }
            if (this.refresher != null && now > entry.getCreateTime() + this.entryLifetimeMax / 2L) {
                this.refresher.queueForRefresh(entry);
            }
        }
        return entry.getSubject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LoginToken token, Subject subject) {
        SessionId id = token.getSessionId();
        LinkedHashMap<SessionId, SessionEntry> linkedHashMap = this.sessionMap;
        synchronized (linkedHashMap) {
            this.sessionMap.put(id, new SessionEntry(token, subject));
        }
    }

    public void stop(boolean wait) {
        if (this.refresher != null) {
            this.refresher.stop(wait);
        }
    }

    public long getEntryLifeTime() {
        return this.entryLifetimeMax;
    }

    public void setEntryLifeTime(long lifeTimeInMillis) {
        this.entryLifetimeMax = lifeTimeInMillis;
    }

    public int getCacheSize() {
        return this.capacity;
    }

    public EntryRefreshStats getRefreshStats() {
        return this.refresher == null ? new EntryRefreshStats(0) : this.refresher.getRefreshStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(SessionId id) {
        LinkedHashMap<SessionId, SessionEntry> linkedHashMap = this.sessionMap;
        synchronized (linkedHashMap) {
            this.sessionMap.remove(id);
        }
    }

    private final class EntryRefresher
    implements Runnable {
        private volatile boolean terminated = false;
        private final TokenResolver resolver;
        private final BlockingQueue<SessionEntry> refreshQueue;
        private final Thread refresherThread;
        private volatile int entryRefreshAttempts = 0;

        private EntryRefresher(TokenResolver resolver) {
            this.resolver = resolver;
            this.refreshQueue = new LinkedBlockingQueue<SessionEntry>(100);
            String threadName = "TokenRefresh";
            this.refresherThread = new Thread((Runnable)this, "TokenRefresh");
            this.refresherThread.setDaemon(true);
            this.refresherThread.start();
        }

        private void stop(boolean wait) {
            this.terminated = true;
            this.refresherThread.interrupt();
            if (wait) {
                try {
                    this.refresherThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void queueForRefresh(SessionEntry entry) {
            SessionEntry sessionEntry = entry;
            synchronized (sessionEntry) {
                if (!entry.isQueuedForRefresh() && this.refreshQueue.offer(entry)) {
                    entry.setQueuedForRefresh();
                }
            }
        }

        private EntryRefreshStats getRefreshStats() {
            return new EntryRefreshStats(this.entryRefreshAttempts);
        }

        @Override
        public void run() {
            while (!this.terminated) {
                try {
                    SessionEntry entry = this.refreshQueue.take();
                    ++this.entryRefreshAttempts;
                    Subject resolved = this.resolver.resolve(entry.getToken());
                    if (resolved == null) continue;
                    TokenCache.this.add(entry.getToken(), resolved);
                }
                catch (SessionAccessException sae) {
                }
                catch (InterruptedException ie) {
                }
                catch (RuntimeException runtimeException) {}
            }
        }
    }

    public static final class EntryRefreshStats {
        private int refreshAttempts;

        public EntryRefreshStats(int refreshAttempts) {
            this.refreshAttempts = refreshAttempts;
        }

        public int getRefreshAttempts() {
            return this.refreshAttempts;
        }
    }

    private final class SessionEntry {
        private final LoginToken token;
        private final Subject subject;
        private final long createTime;
        private boolean queuedForRefresh;

        private SessionEntry(LoginToken token, Subject subject) {
            this.token = token;
            this.subject = subject;
            this.createTime = System.currentTimeMillis();
            this.queuedForRefresh = false;
        }

        private long getCreateTime() {
            return this.createTime;
        }

        private LoginToken getToken() {
            return this.token;
        }

        private Subject getSubject() {
            return this.subject;
        }

        private void setQueuedForRefresh() {
            this.queuedForRefresh = true;
        }

        private boolean isQueuedForRefresh() {
            return this.queuedForRefresh;
        }
    }
}

