/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.topo.StorageNodeId;

public class ParamTopoResolver
implements TopologyResolver {
    private final ParamsHandle paramsHandle;
    private Logger logger;

    public ParamTopoResolver(ParamsHandle paramsHandle, Logger logger) {
        this.paramsHandle = paramsHandle;
        this.logger = logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public TopologyResolver.SNInfo getStorageNode(ResourceId target) {
        if (target instanceof AdminId) {
            return this.getStorageNode((AdminId)target);
        }
        if (target instanceof RepNodeId) {
            return this.getStorageNode((RepNodeId)target);
        }
        if (target instanceof StorageNodeId) {
            return this.getStorageNode((StorageNodeId)target);
        }
        this.logger.info("ParamTopoResolver: unable to resolve target type: " + (Object)((Object)target.getType()));
        return null;
    }

    private TopologyResolver.SNInfo getStorageNode(AdminId target) {
        Parameters params = this.paramsHandle.getParameters();
        if (params == null) {
            this.logger.info("ParamTopoResolver: unable to resolve AdminId: " + target + " with null Parameters");
            return null;
        }
        AdminParams ap = params.get(target);
        if (ap == null) {
            this.logger.info("ParamTopoResolver: unable to resolve AdminId: " + target + " with null AdminParams");
            return null;
        }
        StorageNodeId snid = ap.getStorageNodeId();
        StorageNodeParams snp = params.get(snid);
        if (snp == null) {
            throw new IllegalStateException("StorageNode " + snid + " was not found.");
        }
        this.logger.fine("ParamTopoResolver: Successfully resolved AdminId: " + target);
        return new TopologyResolver.SNInfo(snp.getHostname(), snp.getRegistryPort(), snid);
    }

    private TopologyResolver.SNInfo getStorageNode(StorageNodeId target) {
        Parameters params = this.paramsHandle.getParameters();
        if (params == null) {
            this.logger.info("ParamTopoResolver: unable to resolve SnId: " + target + " with null Parameters");
            return null;
        }
        StorageNodeParams snp = params.get(target);
        if (snp == null) {
            this.logger.info("ParamTopoResolver: unable to resolve SnId: " + target + " with null StorageParams");
            return null;
        }
        StorageNodeId snid = snp.getStorageNodeId();
        this.logger.fine("ParamTopoResolver: successfully resolved SnId: " + target);
        return new TopologyResolver.SNInfo(snp.getHostname(), snp.getRegistryPort(), snid);
    }

    private TopologyResolver.SNInfo getStorageNode(RepNodeId target) {
        Parameters params = this.paramsHandle.getParameters();
        if (params == null) {
            this.logger.info("ParamTopoResolver: unable to resolve RnId: " + target + " with null Parameters");
            return null;
        }
        RepNodeParams rnp = params.get(target);
        if (rnp == null) {
            this.logger.info("ParamTopoResolver: unable to resolve RnId: " + target + " with null RepNodeParams");
            return null;
        }
        StorageNodeId snid = rnp.getStorageNodeId();
        StorageNodeParams snp = params.get(snid);
        if (snp == null) {
            throw new IllegalStateException("StorageNode " + snid + " was not found.");
        }
        this.logger.fine("ParamTopoResolver: successfully resolved RnId: " + target);
        return new TopologyResolver.SNInfo(snp.getHostname(), snp.getRegistryPort(), snid);
    }

    @Override
    public List<RepNodeId> listRepNodeIds(int maxReturn) {
        Parameters params = this.paramsHandle.getParameters();
        if (params == null) {
            return null;
        }
        ArrayList<RepNodeId> rnList = new ArrayList<RepNodeId>();
        for (RepNodeParams rnp : params.getRepNodeParams()) {
            if (rnList.size() >= maxReturn) break;
            rnList.add(rnp.getRepNodeId());
        }
        return rnList;
    }

    public static class ParamsHandleImpl
    implements ParamsHandle {
        private volatile Parameters params;

        public ParamsHandleImpl(Parameters initialParams) {
            this.params = initialParams;
        }

        @Override
        public Parameters getParameters() {
            return this.params;
        }

        public void setParameters(Parameters newParams) {
            this.params = newParams;
        }
    }

    public static interface ParamsHandle {
        public Parameters getParameters();
    }
}

