/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security.login;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.security.auth.Subject;
import oracle.kv.impl.security.login.LoginSession;
import oracle.kv.impl.security.login.SessionManager;

public class LoginTable
implements SessionManager {
    private static final float LOAD_FACTOR = 0.6f;
    private final SecureRandom random;
    private final byte[] idPrefix;
    private final int nSIDRandomBytes;
    private final LinkedHashMap<LoginSession.Id, LoginSession> loginMap;
    private volatile int capacity;

    public LoginTable(int capacity, byte[] idPrefix, int nSIDRandomBytes) {
        this.capacity = capacity;
        this.random = new SecureRandom();
        this.loginMap = new LinkedHashMap<LoginSession.Id, LoginSession>(capacity, 0.6f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<LoginSession.Id, LoginSession> entry) {
                return this.size() > LoginTable.this.capacity;
            }
        };
        this.idPrefix = Arrays.copyOf(idPrefix, idPrefix.length);
        this.nSIDRandomBytes = nSIDRandomBytes;
    }

    @Override
    public LoginSession createSession(Subject subject, String clientHost, long expireTime) {
        LoginSession sess = this.newLogin(subject, clientHost);
        sess.setExpireTime(expireTime);
        return sess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoginSession lookupSession(LoginSession.Id sessionId) {
        LinkedHashMap<LoginSession.Id, LoginSession> linkedHashMap = this.loginMap;
        synchronized (linkedHashMap) {
            return this.loginMap.get(sessionId);
        }
    }

    @Override
    public LoginSession updateSessionExpiration(LoginSession.Id sessionId, long expireTime) {
        return this.updateExpiration(sessionId, expireTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logoutSession(LoginSession.Id sessionId) {
        LinkedHashMap<LoginSession.Id, LoginSession> linkedHashMap = this.loginMap;
        synchronized (linkedHashMap) {
            this.loginMap.remove(sessionId);
        }
    }

    public boolean updateSessionLimit(int newLimit) {
        return this.resize(newLimit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginSession newLogin(Subject subject, String clientHost) {
        byte[] randomBytes = new byte[this.nSIDRandomBytes];
        byte[] idBytes = new byte[this.nSIDRandomBytes + this.idPrefix.length];
        this.random.nextBytes(randomBytes);
        System.arraycopy(this.idPrefix, 0, idBytes, 0, this.idPrefix.length);
        System.arraycopy(randomBytes, 0, idBytes, this.idPrefix.length, this.nSIDRandomBytes);
        LoginSession.Id id = new LoginSession.Id(idBytes);
        LoginSession session = new LoginSession(id, subject, clientHost, false);
        LinkedHashMap<LoginSession.Id, LoginSession> linkedHashMap = this.loginMap;
        synchronized (linkedHashMap) {
            this.loginMap.put(session.getId(), session);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginSession updateExpiration(LoginSession.Id sessionId, long newExpire) {
        LoginSession session;
        LinkedHashMap<LoginSession.Id, LoginSession> linkedHashMap = this.loginMap;
        synchronized (linkedHashMap) {
            session = this.loginMap.get(sessionId);
        }
        if (session != null) {
            session.setExpireTime(newExpire);
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean resize(int newCapacity) {
        LinkedHashMap<LoginSession.Id, LoginSession> linkedHashMap = this.loginMap;
        synchronized (linkedHashMap) {
            if (newCapacity <= 0 || newCapacity == this.capacity) {
                return false;
            }
            if (newCapacity < this.loginMap.size()) {
                int remove = this.loginMap.size() - newCapacity;
                Iterator<LoginSession.Id> iter = this.loginMap.keySet().iterator();
                int count = 0;
                while (iter.hasNext() && count++ < remove) {
                    iter.next();
                    iter.remove();
                }
            }
            this.capacity = newCapacity;
            return true;
        }
    }

    int size() {
        return this.loginMap.size();
    }
}

