/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import oracle.kv.KVSecurityException;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.MethodHandler;
import oracle.kv.impl.security.MethodHandlerUtils;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.ProxyUtils;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.annotations.PublicAPI;
import oracle.kv.impl.security.annotations.PublicMethod;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureInternalMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;

public final class SecureProxy
implements InvocationHandler {
    private static final List<KVStoreRolePrincipal> emptyRoleList = Collections.emptyList();
    private final Object proxyTo;
    private final Map<Method, MethodHandler> methodMap;
    private final AccessChecker checker;
    private final ProcessFaultHandler faultHandler;
    private static final Set<Class<?>> methodAnnotationClasses = new HashSet();
    private final ConcurrentHashMap<Method, String> describeMap = new ConcurrentHashMap();

    @Override
    public Object invoke(Object unusedProxy, final Method method, Object[] args) throws Exception {
        MethodHandler handler = this.methodMap.get(method);
        if (handler == null) {
            this.faultHandler.execute(new ProcessFaultHandler.SimpleProcedure(){

                @Override
                public void execute() {
                    throw new OperationFaultException("MethodHandler for method " + SecureProxy.qualifiedMethodName(method) + " was not found");
                }
            });
        }
        return handler.invoke(method, args);
    }

    public static <T> T create(T proxyTo, AccessChecker checker, ProcessFaultHandler faultHandler) throws ConfigurationException {
        SecureProxy proxyHandler = new SecureProxy(proxyTo, checker, faultHandler);
        Class[] remoteInterfaces = ProxyUtils.findRemoteInterfaces(proxyTo.getClass()).toArray(new Class[0]);
        return (T)Proxy.newProxyInstance(proxyTo.getClass().getClassLoader(), remoteInterfaces, (InvocationHandler)proxyHandler);
    }

    private SecureProxy(Object proxyTo, AccessChecker checker, ProcessFaultHandler faultHandler) throws ConfigurationException {
        String mKey;
        this.proxyTo = proxyTo;
        this.checker = checker;
        this.methodMap = new HashMap<Method, MethodHandler>();
        this.faultHandler = faultHandler;
        Class<?> proxyToClass = proxyTo.getClass();
        Set<Method> interfaceMethods = ProxyUtils.findRemoteInterfaceMethods(proxyToClass);
        HashMap<String, MethodHandler> methodKeyMap = new HashMap<String, MethodHandler>();
        for (Method m : interfaceMethods) {
            mKey = SecureProxy.methodKey(m);
            methodKeyMap.put(mKey, null);
        }
        this.collectMethodInfo(proxyToClass, methodKeyMap, interfaceMethods);
        for (Method m : interfaceMethods) {
            mKey = SecureProxy.methodKey(m);
            MethodHandler handler = (MethodHandler)methodKeyMap.get(mKey);
            if (handler != null) {
                this.methodMap.put(m, handler);
                continue;
            }
            throw new ConfigurationException("Interface method " + SecureProxy.qualifiedMethodName(m) + " has no method handler defined.");
        }
        if (this.methodMap.isEmpty()) {
            throw new ConfigurationException("Class " + proxyToClass + " has no proxyable interface methods.");
        }
    }

    private void collectMethodInfo(Class<?> implClass, Map<String, MethodHandler> methodKeyMap, Set<Method> implMethods) throws ConfigurationException {
        if (implClass == Object.class) {
            return;
        }
        Class<?> classAnnType = this.getClassSecureAnnotation(implClass);
        for (Method m : implClass.getDeclaredMethods()) {
            Annotation methodAnnotation = this.getMethodSecureAnnotation(m);
            String mKey = SecureProxy.methodKey(m);
            if (!methodKeyMap.containsKey(mKey)) {
                if (methodAnnotation == null) continue;
                throw new ConfigurationException("SecureMethod and PublicMethod annotations may not be applied to methods that are not Remote interface methods.  Method " + SecureProxy.methodName(m) + " of Class " + implClass + " is marked as " + methodAnnotation.annotationType().getSimpleName());
            }
            if (null == classAnnType) {
                throw new ConfigurationException("Class " + implClass + " is not marked as either SecureAPI or PublicAPI.");
            }
            if (methodAnnotation == null && classAnnType == SecureAPI.class) {
                throw new ConfigurationException("All Remote interface methods implemented by a class marked as SecureAPI must be annotated with a security decoration. Method " + SecureProxy.methodName(m) + " of Class " + implClass.getName() + " is not annotated.");
            }
            implMethods.add(m);
            MethodHandler handler = this.makeMethodHandler(m, implClass, methodAnnotation);
            assert (handler != null);
            MethodHandler currentHandler = methodKeyMap.get(mKey);
            if (currentHandler != null) continue;
            methodKeyMap.put(mKey, handler);
        }
        Class<?> implSuperclass = implClass.getSuperclass();
        this.collectMethodInfo(implSuperclass, methodKeyMap, implMethods);
    }

    private Class<?> getClassSecureAnnotation(Class<?> implClass) throws ConfigurationException {
        Class<? extends Annotation> classAnnType = null;
        for (Annotation a : implClass.getDeclaredAnnotations()) {
            if (a.annotationType() != SecureAPI.class && a.annotationType() != PublicAPI.class) continue;
            if (classAnnType != null) {
                throw new ConfigurationException("Class " + implClass.getName() + " is marked as both " + a.annotationType().getSimpleName() + " and " + classAnnType.getSimpleName());
            }
            classAnnType = a.annotationType();
        }
        return classAnnType;
    }

    private Annotation getMethodSecureAnnotation(Method method) throws ConfigurationException {
        Annotation methodAnnotation = null;
        for (Annotation a : method.getDeclaredAnnotations()) {
            if (!methodAnnotationClasses.contains(a.annotationType())) continue;
            if (methodAnnotation != null) {
                throw new ConfigurationException("Method " + SecureProxy.qualifiedMethodName(method) + " is marked as both " + methodAnnotation.annotationType().getSimpleName() + " and " + a.annotationType().getSimpleName());
            }
            methodAnnotation = a;
        }
        return methodAnnotation;
    }

    private MethodHandler makeMethodHandler(Method meth, Class<?> methClass, Annotation methodAnnotation) throws ConfigurationException {
        Class methodAnnType = methodAnnotation == null ? PublicMethod.class : methodAnnotation.annotationType();
        MethodHandler handler = null;
        if (methodAnnType == PublicMethod.class) {
            handler = new MethodHandlerUtils.DirectHandler(this.proxyTo);
        } else if (methodAnnType == SecureAutoMethod.class) {
            SecureAutoMethod secureMethod = (SecureAutoMethod)methodAnnotation;
            SecureProxy.ensureAuthContext(meth);
            KVStoreRole[] roles = secureMethod.roles();
            if (roles == null || roles.length == 0) {
                throw new ConfigurationException("SecureAutoMethod requires a non-empty role list: " + SecureProxy.qualifiedMethodName(meth));
            }
            KVStoreRolePrincipal[] rolePrincipals = SecureProxy.lookupRolePrincipals(roles);
            handler = new CheckingHandler(rolePrincipals);
        } else if (methodAnnType == SecureInternalMethod.class) {
            SecureProxy.ensureAuthContext(meth);
            handler = new CheckingHandler(new KVStoreRolePrincipal[0]);
        } else if (methodAnnType == SecureR2Method.class) {
            Method r3Method = SecureProxy.findR3Method(meth, methClass);
            if (r3Method == null) {
                throw new ConfigurationException("Unable to find an R3 method equivalent for method: " + SecureProxy.qualifiedMethodName(meth));
            }
            if (r3Method.getClass() != meth.getClass()) {
                throw new ConfigurationException("R2 compatibility methods must be implemented within the same class as their R3 equivalent methods: " + SecureProxy.qualifiedMethodName(meth));
            }
            handler = new R2CompatHandler(r3Method);
        } else {
            throw new IllegalStateException("missing case for " + methodAnnType.getSimpleName());
        }
        return handler;
    }

    private static void ensureAuthContext(Method secureMethod) throws ConfigurationException {
        Class<?>[] args = secureMethod.getParameterTypes();
        if (args.length < 2 || AuthContext.class != args[args.length - 2]) {
            throw new ConfigurationException("Method " + SecureProxy.qualifiedMethodName(secureMethod) + " does not have an AuthContext " + "argument in the next to last position.");
        }
    }

    private static KVStoreRolePrincipal[] lookupRolePrincipals(KVStoreRole[] roles) throws ConfigurationException {
        KVStoreRolePrincipal[] principals = new KVStoreRolePrincipal[roles.length];
        for (int i = 0; i < roles.length; ++i) {
            KVStoreRole role = roles[i];
            KVStoreRolePrincipal principal = KVStoreRolePrincipal.get(role);
            if (principal == null) {
                throw new ConfigurationException("The role " + (Object)((Object)role) + " has no corresponding principal");
            }
            principals[i] = principal;
        }
        return principals;
    }

    private static String methodKey(Method m) {
        Class<?>[] paramTypes;
        StringBuffer sb = new StringBuffer();
        if ((m.getModifiers() & 2) != 0) {
            sb.append("private ");
        }
        sb.append(m.getName());
        sb.append("(");
        for (Class<?> pt : paramTypes = m.getParameterTypes()) {
            sb.append(pt.getName());
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }

    private static String methodName(Method m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getName());
        sb.append("(");
        Class<?>[] paramTypes = m.getParameterTypes();
        boolean first = true;
        for (Class<?> pt : paramTypes) {
            if (!first) {
                sb.append(",");
            }
            sb.append(pt.getSimpleName());
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    private static String qualifiedMethodName(Method m) {
        StringBuffer sb = new StringBuffer();
        sb.append(m.getDeclaringClass().getSimpleName());
        sb.append(".");
        sb.append(SecureProxy.methodName(m));
        return sb.toString();
    }

    private static Method findR3Method(Method interfaceMethod, Class<?> implClass) {
        Class<?>[] paramTypes = interfaceMethod.getParameterTypes();
        if (paramTypes.length < 1) {
            return null;
        }
        Class<?>[] r3ParamTypes = Arrays.copyOf(paramTypes, paramTypes.length + 1);
        r3ParamTypes[paramTypes.length] = r3ParamTypes[paramTypes.length - 1];
        r3ParamTypes[paramTypes.length - 1] = AuthContext.class;
        try {
            Method r3Method = implClass.getMethod(interfaceMethod.getName(), r3ParamTypes);
            return r3Method;
        }
        catch (NoSuchMethodException nsme) {
            return null;
        }
    }

    static {
        methodAnnotationClasses.add(PublicMethod.class);
        methodAnnotationClasses.add(SecureAutoMethod.class);
        methodAnnotationClasses.add(SecureInternalMethod.class);
        methodAnnotationClasses.add(SecureR2Method.class);
    }

    private final class MethodInvokeContext
    implements OperationContext {
        private final Method m;
        private final List<KVStoreRolePrincipal> reqRoles;

        private MethodInvokeContext(Method m, List<KVStoreRolePrincipal> reqRoles) {
            this.m = m;
            this.reqRoles = reqRoles;
        }

        @Override
        public String describe() {
            if (!SecureProxy.this.describeMap.contains(this.m)) {
                SecureProxy.this.describeMap.putIfAbsent(this.m, SecureProxy.qualifiedMethodName(this.m));
            }
            return "attempt to call " + (String)SecureProxy.this.describeMap.get(this.m);
        }

        @Override
        public List<KVStoreRolePrincipal> getRequiredRoles() {
            return this.reqRoles;
        }
    }

    final class R2CompatHandler
    implements MethodHandler {
        private final Method r3Method;

        private R2CompatHandler(Method r3Method) {
            this.r3Method = r3Method;
        }

        @Override
        public Object invoke(Method method, Object[] args) throws Exception {
            Object[] newArgs = Arrays.copyOf(args, args.length + 1);
            newArgs[args.length] = args[args.length - 1];
            newArgs[args.length - 1] = null;
            return SecureProxy.this.invoke(null, this.r3Method, newArgs);
        }
    }

    final class CheckingHandler
    implements MethodHandler {
        private final List<KVStoreRolePrincipal> requiredRoles;

        CheckingHandler(KVStoreRolePrincipal[] requiredRoles) {
            this.requiredRoles = requiredRoles == null ? emptyRoleList : Collections.unmodifiableList(Arrays.asList(requiredRoles));
        }

        @Override
        public Object invoke(final Method method, final Object[] args) throws Exception {
            if (SecureProxy.this.checker == null) {
                return MethodHandlerUtils.invokeMethod(SecureProxy.this.proxyTo, method, args);
            }
            ExecutionContext execCtx = SecureProxy.this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<ExecutionContext>(){

                @Override
                public ExecutionContext execute() {
                    AuthContext authCtx = (AuthContext)args[args.length - 2];
                    try {
                        return ExecutionContext.create(SecureProxy.this.checker, authCtx, new MethodInvokeContext(method, CheckingHandler.this.requiredRoles));
                    }
                    catch (SessionAccessException sae) {
                        throw sae;
                    }
                    catch (KVSecurityException kvse) {
                        throw new ClientAccessException(kvse);
                    }
                }
            });
            return ExecutionContext.runWithContext(new ExecutionContext.Operation<Object, Exception>(){

                @Override
                public Object run() throws Exception {
                    return MethodHandlerUtils.invokeMethod(SecureProxy.this.proxyTo, method, args);
                }
            }, execCtx);
        }
    }
}

