/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreRole;

public final class KVStoreRolePrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private final KVStoreRole role;
    public static final KVStoreRolePrincipal INTERNAL = new KVStoreRolePrincipal(KVStoreRole.INTERNAL);
    public static final KVStoreRolePrincipal AUTHENTICATED = new KVStoreRolePrincipal(KVStoreRole.AUTHENTICATED);
    public static final KVStoreRolePrincipal ADMIN = new KVStoreRolePrincipal(KVStoreRole.ADMIN);
    private static final Map<KVStoreRole, KVStoreRolePrincipal> roleMap = new HashMap<KVStoreRole, KVStoreRolePrincipal>();

    public static KVStoreRolePrincipal get(KVStoreRole role) {
        return roleMap.get((Object)role);
    }

    public static KVStoreRole[] getSubjectRoles(Subject subj) {
        return ExecutionContext.getSubjectRoles(subj);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return this.role == ((KVStoreRolePrincipal)other).role;
    }

    @Override
    public String getName() {
        return this.role.toString();
    }

    @Override
    public int hashCode() {
        return this.role.hashCode();
    }

    @Override
    public String toString() {
        return "KVStoreRolePrincipal(" + (Object)((Object)this.role) + ")";
    }

    private KVStoreRolePrincipal(KVStoreRole role) {
        this.role = role;
    }

    public KVStoreRole getRole() {
        return this.role;
    }

    static {
        roleMap.put(INTERNAL.getRole(), INTERNAL);
        roleMap.put(AUTHENTICATED.getRole(), AUTHENTICATED);
        roleMap.put(ADMIN.getRole(), ADMIN);
    }
}

