/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SessionAccessException;

public final class ExecutionContext {
    private static final ThreadLocal<ExecutionContext> currentContext = new ThreadLocal();
    private final AuthContext requestorCtx;
    private final Subject requestorSubj;
    private final OperationContext opCtx;
    private final String clientHost;

    private ExecutionContext(AuthContext requestorCtx, Subject requestorSubject, OperationContext opCtx) {
        this.requestorCtx = requestorCtx;
        this.requestorSubj = requestorSubject;
        this.opCtx = opCtx;
        this.clientHost = ExecutionContext.getRMIClientHost();
    }

    public AuthContext requestorContext() {
        return this.requestorCtx;
    }

    public Subject requestorSubject() {
        return this.requestorSubj;
    }

    public String requestorHost() {
        return this.clientHost;
    }

    public OperationContext operationContext() {
        return this.opCtx;
    }

    public static ExecutionContext create(AccessChecker accessCheck, AuthContext requestorCtx, OperationContext opCtx) throws AuthenticationRequiredException, UnauthorizedException, SessionAccessException {
        Subject reqSubj = accessCheck == null ? null : accessCheck.identifyRequestor(requestorCtx);
        ExecutionContext execCtx = new ExecutionContext(requestorCtx, reqSubj, opCtx);
        if (accessCheck != null) {
            accessCheck.checkAccess(execCtx, opCtx);
        }
        return execCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, E extends Exception> R runWithContext(Operation<R, E> operation, ExecutionContext execCtx) throws E {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            R r = operation.run();
            return r;
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R runWithContext(SimpleOperation<R> operation, ExecutionContext execCtx) {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            R r = operation.run();
            return r;
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <E extends Exception> void runWithContext(Procedure<E> procedure, ExecutionContext execCtx) throws E {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            procedure.run();
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithContext(SimpleProcedure procedure, ExecutionContext execCtx) {
        ExecutionContext priorCtx = currentContext.get();
        try {
            currentContext.set(execCtx);
            procedure.run();
        }
        finally {
            currentContext.set(priorCtx);
        }
    }

    public static ExecutionContext getCurrent() {
        return currentContext.get();
    }

    public static Subject getCurrentUserSubject() {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return null;
        }
        return execCtx.requestorSubject();
    }

    public static String getCurrentUserHost() {
        ExecutionContext execCtx = ExecutionContext.getCurrent();
        if (execCtx == null) {
            return null;
        }
        return execCtx.requestorHost();
    }

    public static KVStoreUserPrincipal getCurrentUserPrincipal() {
        return ExecutionContext.getSubjectUserPrincipal(ExecutionContext.getCurrentUserSubject());
    }

    public static KVStoreUserPrincipal getSubjectUserPrincipal(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreUserPrincipal> userPrincs = subj.getPrincipals(KVStoreUserPrincipal.class);
        if (userPrincs.isEmpty()) {
            return null;
        }
        if (userPrincs.size() != 1) {
            throw new IllegalStateException("Current user has multiple user principals");
        }
        return userPrincs.iterator().next();
    }

    public static KVStoreRolePrincipal[] getSubjectRolePrincipals(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreRolePrincipal> rolePrincs = subj.getPrincipals(KVStoreRolePrincipal.class);
        return rolePrincs.toArray(new KVStoreRolePrincipal[rolePrincs.size()]);
    }

    public static KVStoreRole[] getSubjectRoles(Subject subj) {
        if (subj == null) {
            return null;
        }
        Set<KVStoreRolePrincipal> rolePrincs = subj.getPrincipals(KVStoreRolePrincipal.class);
        ArrayList<KVStoreRole> roles = new ArrayList<KVStoreRole>();
        for (KVStoreRolePrincipal princ : rolePrincs) {
            roles.add(princ.getRole());
        }
        return roles.toArray(new KVStoreRole[roles.size()]);
    }

    public boolean hasRole(KVStoreRole role) {
        return ExecutionContext.subjectHasRole(this.requestorSubj, role);
    }

    public static boolean subjectHasRole(Subject subj, KVStoreRole role) {
        for (Principal princ : subj.getPrincipals()) {
            KVStoreRolePrincipal rolePrinc;
            if (!KVStoreRolePrincipal.class.isAssignableFrom(princ.getClass()) || !(rolePrinc = (KVStoreRolePrincipal)princ).getRole().equals((Object)role)) continue;
            return true;
        }
        return false;
    }

    private static String getRMIClientHost() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException snae) {
            return null;
        }
    }

    public static interface SimpleProcedure {
        public void run();
    }

    public static interface Procedure<E extends Exception> {
        public void run() throws E;
    }

    public static interface SimpleOperation<R> {
        public R run();
    }

    public static interface Operation<R, E extends Exception> {
        public R run() throws E;
    }
}

