/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.security;

import java.security.Principal;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.AuthenticationRequiredException;
import oracle.kv.UnauthorizedException;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.OperationContext;
import oracle.kv.impl.security.SessionAccessException;
import oracle.kv.impl.security.login.LoginToken;
import oracle.kv.impl.security.login.TokenVerifier;

public class AccessCheckerImpl
implements AccessChecker {
    private final TokenVerifier verifier;
    private volatile Logger logger;

    public AccessCheckerImpl(TokenVerifier verifier, Logger logger) {
        this.verifier = verifier;
        this.logger = logger;
    }

    private void logError(String msg, ExecutionContext execCtx, OperationContext opCtx) {
        if (execCtx.requestorContext() != null && execCtx.requestorContext().getClientHost() != null) {
            this.logger.info(msg + " : " + "client host: " + execCtx.requestorHost() + ", auth host: " + execCtx.requestorContext().getClientHost() + ": " + opCtx.describe());
        } else {
            this.logger.info(msg + " : " + "client host: " + execCtx.requestorHost() + ": " + opCtx.describe());
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    public Subject identifyRequestor(AuthContext context) throws SessionAccessException {
        if (context == null) {
            return null;
        }
        LoginToken token = context.getLoginToken();
        if (token == null) {
            return null;
        }
        try {
            return this.verifier.verifyToken(token);
        }
        catch (SessionAccessException sae) {
            throw new SessionAccessException(sae, false);
        }
    }

    @Override
    public void checkAccess(ExecutionContext execCtx, OperationContext opCtx) throws AuthenticationRequiredException, UnauthorizedException {
        List<KVStoreRolePrincipal> roles = opCtx.getRequiredRoles();
        if (roles.size() == 0) {
            return;
        }
        Subject subject = execCtx.requestorSubject();
        if (subject == null) {
            AuthContext secCtx = execCtx.requestorContext();
            if (secCtx == null || secCtx.getLoginToken() == null) {
                this.logError("Attempt to call method without authentication", execCtx, opCtx);
                throw new AuthenticationRequiredException("Authentication required for access", false);
            }
            this.logError("Attempt to call method with invalid authentication", execCtx, opCtx);
            throw new AuthenticationRequiredException("Authentication required for access", false);
        }
        Set<Principal> principals = subject.getPrincipals();
        for (KVStoreRolePrincipal princ : roles) {
            if (principals.contains(princ)) continue;
            this.logError("Insufficient access rights", execCtx, opCtx);
            throw new UnauthorizedException("Insufficient access rights granted");
        }
    }
}

