/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.table;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.api.table.IndexImpl;
import oracle.kv.impl.api.table.PrimaryKeyImpl;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableKey;
import oracle.kv.impl.rep.PartitionManager;
import oracle.kv.impl.rep.table.TableManager;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.SerializationUtil;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.table.Table;

class SecondaryInfoMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String SECONDARY_INFO_DB_NAME = "SecondaryInfoDB";
    private static final String SECONDARY_INFO_KEY = "SecondaryInfoMap";
    private static final DatabaseEntry secondaryInfoKey = new DatabaseEntry();
    static final TransactionConfig SECONDARY_INFO_CONFIG;
    private static final int CURRENT_SCHEMA_VERSION = 1;
    static final TransactionConfig NO_WAIT_CONFIG;
    private final Map<String, SecondaryInfo> secondaryMap = new HashMap<String, SecondaryInfo>();
    private final Map<String, DeletedTableInfo> deletedTableMap = new HashMap<String, DeletedTableInfo>();
    private int metadataSequenceNum = 0;
    private final int version;

    private SecondaryInfoMap() {
        this.version = 1;
    }

    int getMetadataSequenceNum() {
        return this.metadataSequenceNum;
    }

    void setMetadataSequenceNum(int seqNum) {
        assert (seqNum >= this.metadataSequenceNum);
        this.metadataSequenceNum = seqNum;
    }

    static boolean add(String dbName, Database db, Transaction txn, Logger logger) {
        SecondaryInfoMap infoMap = SecondaryInfoMap.fetch(db, txn, LockMode.RMW);
        SecondaryInfo info = infoMap.secondaryMap.get(dbName);
        if (info == null) {
            info = new SecondaryInfo();
            infoMap.secondaryMap.put(dbName, info);
            logger.log(Level.FINE, "Adding {0} for {1}, map size= {2}", new Object[]{info, dbName, infoMap.secondaryMap.size()});
            infoMap.persist(db, txn);
        }
        return info.needsPopulating();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void check(Map<String, Table> currentTables, Map<String, IndexImpl> indexes, Set<TableImpl> deletedTables, Database db, Logger logger) {
        Transaction txn;
        block11: {
            txn = null;
            try {
                boolean modified = false;
                txn = db.getEnvironment().beginTransaction(null, SECONDARY_INFO_CONFIG);
                SecondaryInfoMap infoMap = SecondaryInfoMap.fetch(db, txn, LockMode.RMW);
                Iterator<Map.Entry<String, SecondaryInfo>> itr = infoMap.secondaryMap.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<String, SecondaryInfo> entry = itr.next();
                    String dbName = entry.getKey();
                    if (indexes.containsKey(dbName)) continue;
                    logger.log(Level.FINE, "Removing secondary info for {0}", dbName);
                    itr.remove();
                    modified = true;
                }
                Iterator<Map.Entry<String, DeletedTableInfo>> itr2 = infoMap.deletedTableMap.entrySet().iterator();
                while (itr2.hasNext()) {
                    Map.Entry<String, DeletedTableInfo> entry = itr2.next();
                    Table table = currentTables.get(entry.getKey());
                    if (table == null) {
                        assert (entry.getValue().isDone());
                        itr2.remove();
                        modified = true;
                        continue;
                    }
                    if (((TableImpl)table).getStatus().isDeleting()) continue;
                    throw new IllegalStateException("Table metadata includes table " + table + " but node thinks the table is deleted");
                }
                for (TableImpl tableImpl : deletedTables) {
                    DeletedTableInfo info = infoMap.getDeletedTableInfo(tableImpl.getParentName());
                    if (info == null) {
                        info = new DeletedTableInfo(tableImpl);
                        infoMap.deletedTableMap.put(tableImpl.getFullName(), info);
                        modified = true;
                        continue;
                    }
                    assert (!info.isDone());
                }
                if (!modified) break block11;
                try {
                    infoMap.persist(db, txn);
                    txn.commit();
                    txn = null;
                }
                catch (RuntimeException re) {
                    PartitionManager.handleException(re, logger, "populate info map");
                }
            }
            catch (Throwable throwable) {
                TxnUtil.abort(txn);
                throw throwable;
            }
        }
        TxnUtil.abort(txn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void markForSecondaryCleaning(TableManager tableManager, ReplicatedEnvironment repEnv, Logger logger) {
        Database db = null;
        try {
            db = SecondaryInfoMap.openDb(repEnv);
            Transaction txn = null;
            try {
                txn = repEnv.beginTransaction(null, SECONDARY_INFO_CONFIG);
                SecondaryInfoMap infoMap = SecondaryInfoMap.fetch(db, txn, LockMode.RMW);
                if (infoMap.secondaryMap.isEmpty()) {
                    return;
                }
                logger.log(Level.FINE, "Marking {0} for cleaning", infoMap.secondaryMap.size());
                for (SecondaryInfo info : infoMap.secondaryMap.values()) {
                    info.markForCleaning();
                }
                try {
                    infoMap.persist(db, txn);
                    txn.commit();
                    txn = null;
                }
                catch (RuntimeException re) {
                    PartitionManager.handleException(re, logger, "populate info map");
                }
            }
            finally {
                if (txn != null) {
                    txn.abort();
                }
            }
            tableManager.checkMaintenanceThreads(repEnv, db);
        }
        finally {
            TxnUtil.close(logger, db, "populate info map");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SecondaryInfoMap fetch(ReplicatedEnvironment repEnv) {
        Database db = null;
        try {
            db = SecondaryInfoMap.openDb(repEnv);
            SecondaryInfoMap secondaryInfoMap = SecondaryInfoMap.fetch(db);
            return secondaryInfoMap;
        }
        finally {
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException databaseException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SecondaryInfoMap fetch(Database db) {
        Transaction txn = db.getEnvironment().beginTransaction(null, NO_WAIT_CONFIG);
        try {
            SecondaryInfoMap secondaryInfoMap = SecondaryInfoMap.fetch(db, txn, LockMode.READ_UNCOMMITTED);
            return secondaryInfoMap;
        }
        finally {
            if (txn.isValid()) {
                txn.commit();
            } else {
                TxnUtil.abort(txn);
            }
        }
    }

    static SecondaryInfoMap fetch(Database db, Transaction txn, LockMode lockMode) {
        if (txn == null) {
            throw new IllegalStateException("transaction can not be null");
        }
        DatabaseEntry value = new DatabaseEntry();
        db.get(txn, secondaryInfoKey, value, lockMode);
        SecondaryInfoMap infoMap = SerializationUtil.getObject(value.getData(), SecondaryInfoMap.class);
        return infoMap == null ? new SecondaryInfoMap() : infoMap;
    }

    void persist(Database db, Transaction txn) {
        db.put(txn, secondaryInfoKey, new DatabaseEntry(SerializationUtil.getBytes(this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Database openDb(ReplicatedEnvironment repEnv) {
        Database database;
        DatabaseConfig dbConfig = new DatabaseConfig().setAllowCreate(true).setTransactional(true);
        TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        Transaction txn = null;
        Database db = null;
        try {
            txn = repEnv.beginTransaction(null, txnConfig);
            db = repEnv.openDatabase(txn, SECONDARY_INFO_DB_NAME, dbConfig);
            txn.commit();
            txn = null;
            Database ret = db;
            db = null;
            database = ret;
        }
        catch (Throwable throwable) {
            TxnUtil.abort(txn);
            if (db != null) {
                try {
                    db.close();
                }
                catch (DatabaseException de) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        TxnUtil.abort(txn);
        if (db != null) {
            try {
                db.close();
            }
            catch (DatabaseException de) {
                // empty catch block
            }
        }
        return database;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.version > 1) {
            throw new IllegalStateException("The secondary info map is at " + KVVersion.CURRENT_VERSION + ", schema version " + 1 + " but the stored schema is at version " + this.version + ". Please upgrade this node's NoSQL Database version.");
        }
        if (this.version != 1) {
            throw new IllegalStateException("Unexpected secondary info map store schema version, expected 1 but the stored schema is at version " + this.version + ".");
        }
    }

    SecondaryInfo getSecondaryInfo(String dbName) {
        return this.secondaryMap.get(dbName);
    }

    boolean secondaryNeedsPopulate() {
        for (SecondaryInfo info : this.secondaryMap.values()) {
            if (!info.needsPopulating()) continue;
            return true;
        }
        return false;
    }

    boolean secondaryNeedsCleaning() {
        return this.getNextSecondaryToClean() != null;
    }

    String getNextSecondaryToPopulate() {
        for (Map.Entry<String, SecondaryInfo> entry : this.secondaryMap.entrySet()) {
            if (!entry.getValue().needsPopulating()) continue;
            return entry.getKey();
        }
        return null;
    }

    String getNextSecondaryToClean() {
        for (Map.Entry<String, SecondaryInfo> entry : this.secondaryMap.entrySet()) {
            if (!entry.getValue().needsCleaning()) continue;
            return entry.getKey();
        }
        return null;
    }

    DeletedTableInfo getDeletedTableInfo(String tableName) {
        return this.deletedTableMap.get(tableName);
    }

    void removeDeletedTableInfo(String tableName) {
        this.deletedTableMap.remove(tableName);
    }

    String getNextDeletedTableToClean() {
        for (Map.Entry<String, DeletedTableInfo> entry : this.deletedTableMap.entrySet()) {
            if (entry.getValue().isDone()) continue;
            return entry.getKey();
        }
        return null;
    }

    boolean tableNeedDeleting() {
        return this.getNextDeletedTableToClean() != null;
    }

    public String toString() {
        return "SecondaryInfoMap[" + this.secondaryMap.size() + ", " + this.deletedTableMap.size() + "]";
    }

    static {
        StringBinding.stringToEntry(SECONDARY_INFO_KEY, secondaryInfoKey);
        SECONDARY_INFO_CONFIG = new TransactionConfig().setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY).setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        NO_WAIT_CONFIG = new TransactionConfig().setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE)).setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
    }

    static class DeletedTableInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean done = false;
        private PartitionId currentPartition = null;
        private Set<PartitionId> completed = null;
        private final boolean majorPathComplete;
        private final boolean isChildTable;
        private final long targetTableId;
        private final byte[] parentKeyBytes;
        private byte[] currentKeyBytes;

        DeletedTableInfo(TableImpl targetTable) {
            TableImpl parentTable = targetTable;
            if (targetTable.getParent() != null) {
                this.isChildTable = true;
                parentTable = targetTable.getTopLevelTable();
            } else {
                this.isChildTable = false;
            }
            PrimaryKeyImpl pkey = parentTable.createPrimaryKey();
            TableKey key = TableKey.createKey(parentTable, pkey, true);
            this.parentKeyBytes = key.getKeyBytes();
            this.majorPathComplete = key.getMajorKeyComplete();
            this.currentKeyBytes = this.parentKeyBytes;
            this.targetTableId = targetTable.getId();
        }

        byte[] getCurrentKeyBytes() {
            return this.currentKeyBytes;
        }

        void setCurrentKeyBytes(byte[] newKey) {
            this.currentKeyBytes = newKey;
        }

        byte[] getParentKeyBytes() {
            return this.parentKeyBytes;
        }

        long getTargetTableId() {
            return this.targetTableId;
        }

        boolean getMajorPathComplete() {
            return this.majorPathComplete;
        }

        boolean isChildTable() {
            return this.isChildTable;
        }

        boolean isDone() {
            return this.done;
        }

        boolean isCompleted(PartitionId partition) {
            return this.completed == null ? false : this.completed.contains(partition);
        }

        void completeCurrentPartition() {
            if (this.completed == null) {
                this.completed = new HashSet<PartitionId>();
            }
            this.completed.add(this.currentPartition);
            this.currentPartition = null;
        }

        PartitionId getCurrentPartition() {
            return this.currentPartition;
        }

        void setCurrentPartition(PartitionId partition) {
            this.currentPartition = partition;
        }

        void setDone() {
            this.done = true;
        }

        public String toString() {
            return "DeletedTableInfo[" + this.done + ", " + this.currentPartition + ", " + (this.completed == null ? "-" : Integer.valueOf(this.completed.size())) + "]";
        }
    }

    static class SecondaryInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean needsPopulating = true;
        private boolean needsCleaning = false;
        private DatabaseEntry lastKey = null;
        private DatabaseEntry lastData = null;
        private PartitionId currentPartition = null;
        private Set<PartitionId> completed = null;

        SecondaryInfo() {
        }

        boolean needsPopulating() {
            return this.needsPopulating;
        }

        void donePopulation() {
            assert (this.needsPopulating);
            this.needsPopulating = false;
        }

        void markForCleaning() {
            this.needsCleaning = true;
        }

        boolean needsCleaning() {
            return this.needsPopulating ? false : this.needsCleaning;
        }

        void doneCleaning() {
            assert (!this.needsPopulating);
            this.needsCleaning = false;
            this.lastKey = null;
            this.lastData = null;
        }

        DatabaseEntry getLastKey() {
            if (this.lastKey == null) {
                this.lastKey = new DatabaseEntry();
            }
            return this.lastKey;
        }

        DatabaseEntry getLastData() {
            assert (!this.needsPopulating);
            if (this.lastData == null) {
                this.lastData = new DatabaseEntry();
            }
            return this.lastData;
        }

        PartitionId getCurrentPartition() {
            assert (this.needsPopulating);
            return this.currentPartition;
        }

        void setCurrentPartition(PartitionId partitionId) {
            assert (this.needsPopulating);
            assert (partitionId != null);
            assert (this.currentPartition == null);
            this.currentPartition = partitionId;
        }

        boolean isCompleted(PartitionId partitionId) {
            assert (this.needsPopulating);
            return this.completed == null ? false : this.completed.contains(partitionId);
        }

        void completeCurrentPartition() {
            assert (this.needsPopulating);
            if (this.completed == null) {
                this.completed = new HashSet<PartitionId>();
            }
            this.completed.add(this.currentPartition);
            this.currentPartition = null;
            this.lastKey = null;
        }

        public String toString() {
            return "SecondaryInfo[" + this.needsPopulating + ", " + this.currentPartition + ", " + (this.completed == null ? "-" : Integer.valueOf(this.completed.size())) + ", " + this.needsCleaning + "]";
        }
    }
}

