/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.table;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.api.ops.MultiDeleteTable;
import oracle.kv.impl.api.ops.OperationHandler;
import oracle.kv.impl.api.ops.Result;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.table.SecondaryInfoMap;
import oracle.kv.impl.rep.table.TableManager;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.util.TxnUtil;

abstract class MaintenanceThread
extends Thread {
    private static final int NUM_DB_OP_RETRIES = 100;
    private static final long SHORT_RETRY_TIME = 500L;
    private static final long LONG_RETRY_TIME = 1000L;
    private static final int POPULATE_BATCH_SIZE = 100;
    private static final int CLEAN_BATCH_SIZE = 100;
    private static final int DELETE_BATCH_SIZE = 100;
    protected final TableManager tableManager;
    protected final RepNode repNode;
    protected final Logger logger;
    protected final ReplicatedEnvironment repEnv;
    protected volatile boolean stop = false;

    protected MaintenanceThread(String name, TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
        super(name);
        this.tableManager = tableManager;
        this.repNode = repNode;
        this.repEnv = repEnv;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.logger.log(Level.INFO, "Starting {0}", this);
        while (!this.isStopped()) {
            try {
                if (!this.repNode.getMigrationManager().awaitIdle(10L, TimeUnit.SECONDS)) continue;
                break;
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
        OperationFailureException de = null;
        long delay = 0L;
        int retryCount = 100;
        Database infoDb = null;
        while (!this.isStopped()) {
            try {
                infoDb = SecondaryInfoMap.openDb(this.repEnv);
                this.doWork(infoDb);
                this.stop = true;
                this.tableManager.maintenanceThreadExit(this.repEnv, infoDb);
                return;
            }
            catch (InsufficientAcksException iae) {
                de = iae;
                delay = 1000L;
            }
            catch (InsufficientReplicasException ire) {
                de = ire;
                delay = 1000L;
            }
            catch (LockConflictException lce) {
                de = lce;
                delay = 500L;
            }
            finally {
                if (infoDb != null) {
                    TxnUtil.close(this.logger, infoDb, null);
                }
            }
            assert (de != null);
            this.retrySleep(retryCount, delay, de);
            --retryCount;
        }
        this.logger.log(Level.FINE, "{0} stopped", this);
    }

    private void retrySleep(int count, long sleepTime, DatabaseException de) {
        if (count <= 0) {
            throw de;
        }
        this.logger.log(Level.INFO, "DB op caused {0}, will retry in {1}ms, attempts left: {2}", new Object[]{de, sleepTime, count});
        try {
            Thread.sleep(sleepTime);
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    abstract void doWork(Database var1);

    protected boolean isStopped() {
        return this.stop || !this.repEnv.isValid() || !this.repEnv.getState().isMaster();
    }

    void waitForStop() {
        assert (Thread.currentThread() != this);
        this.stop = true;
        try {
            this.join();
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(ie);
        }
    }

    static class PrimaryCleanerThread
    extends MaintenanceThread {
        PrimaryCleanerThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV primary cleaner", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWork(Database infoDb) {
            if (this.isStopped()) {
                return;
            }
            String currentTable = null;
            while (!this.isStopped()) {
                SecondaryInfoMap infoMap;
                Transaction txn;
                block15: {
                    block14: {
                        txn = null;
                        txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.SECONDARY_INFO_CONFIG);
                        infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                        if (infoMap != null) break block14;
                        this.logger.info("Unable to read secondary info database");
                        TxnUtil.abort(txn);
                        return;
                    }
                    if (currentTable == null) {
                        currentTable = infoMap.getNextDeletedTableToClean();
                    }
                    if (currentTable != null) break block15;
                    this.logger.info("Completed cleaning partition database(s) for all tables");
                    TxnUtil.abort(txn);
                    return;
                }
                try {
                    SecondaryInfoMap.DeletedTableInfo info = infoMap.getDeletedTableInfo(currentTable);
                    assert (info != null);
                    assert (!info.isDone());
                    if (info.getCurrentPartition() == null) {
                        for (PartitionId partition : this.repNode.getPartitions()) {
                            if (info.isCompleted(partition)) continue;
                            info.setCurrentPartition(partition);
                            break;
                        }
                    }
                    if (info.getCurrentPartition() == null) {
                        this.logger.log(Level.FINE, "Completed cleaning partition database(s) for {0}", currentTable);
                        info.setDone();
                        currentTable = null;
                    } else if (this.deleteABlock(info, txn)) {
                        this.logger.log(Level.FINE, "Completed cleaning " + info.getCurrentPartition() + " for {0}", currentTable);
                        info.completeCurrentPartition();
                    }
                    infoMap.persist(infoDb, txn);
                    txn.commit();
                    txn = null;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
            }
        }

        private boolean deleteABlock(SecondaryInfoMap.DeletedTableInfo info, Transaction txn) {
            MultiDeleteTable mdt = new MultiDeleteTable(info.getParentKeyBytes(), info.getTargetTableId(), info.getMajorPathComplete(), 100, info.getCurrentKeyBytes());
            OperationHandler oh = new OperationHandler(this.repNode, this.tableManager.getParams());
            Result result = mdt.execute(txn, info.getCurrentPartition(), oh);
            int num = result.getNDeletions();
            this.logger.log(Level.FINE, "Deleted {0} records in partition {1}{2}", new Object[]{num, info.getCurrentPartition(), num < 100 ? ", partition is complete" : ""});
            if (num < 100) {
                info.setCurrentKeyBytes(null);
                return true;
            }
            info.setCurrentKeyBytes(mdt.getLastDeleted());
            return false;
        }
    }

    static class SecondaryCleanerThread
    extends MaintenanceThread {
        SecondaryCleanerThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV secondary cleaner", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doWork(Database infoDb) {
            if (this.isStopped()) {
                return;
            }
            String currentSecondary = null;
            while (!this.isStopped()) {
                SecondaryDatabase db;
                SecondaryInfoMap.SecondaryInfo info;
                SecondaryInfoMap infoMap;
                Transaction txn;
                block13: {
                    block12: {
                        block11: {
                            txn = null;
                            try {
                                txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.SECONDARY_INFO_CONFIG);
                                infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                                if (infoMap != null) break block11;
                                this.logger.info("Unable to read secondary info database");
                            }
                            catch (Throwable throwable) {
                                TxnUtil.abort(txn);
                                throw throwable;
                            }
                            TxnUtil.abort(txn);
                            return;
                        }
                        if (currentSecondary == null) {
                            currentSecondary = infoMap.getNextSecondaryToClean();
                        }
                        if (currentSecondary != null) break block12;
                        this.logger.info("Completed cleaning secondary database(s)");
                        TxnUtil.abort(txn);
                        return;
                    }
                    info = infoMap.getSecondaryInfo(currentSecondary);
                    assert (info != null);
                    assert (info.needsCleaning());
                    db = this.tableManager.getSecondaryDb(currentSecondary);
                    if (db != null) break block13;
                    this.logger.log(Level.WARNING, "Failed to clean {0}, secondary database {1} is missing", new Object[]{info, currentSecondary});
                    TxnUtil.abort(txn);
                    return;
                }
                if (!db.deleteObsoletePrimaryKeys(info.getLastKey(), info.getLastData(), 100)) {
                    this.logger.log(Level.FINE, "Completed cleaning {0}", currentSecondary);
                    info.doneCleaning();
                    currentSecondary = null;
                }
                infoMap.persist(infoDb, txn);
                txn.commit();
                txn = null;
                TxnUtil.abort(txn);
            }
        }
    }

    static class PopulateThread
    extends MaintenanceThread {
        PopulateThread(TableManager tableManager, RepNode repNode, ReplicatedEnvironment repEnv, Logger logger) {
            super("KV secondary populator", tableManager, repNode, repEnv, logger);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        protected void doWork(Database infoDb) {
            currentSecondary = null;
            while (!this.isStopped()) {
                block18: {
                    block17: {
                        block16: {
                            block15: {
                                block14: {
                                    db = null;
                                    txn = null;
                                    txn = this.repEnv.beginTransaction(null, SecondaryInfoMap.SECONDARY_INFO_CONFIG);
                                    infoMap = SecondaryInfoMap.fetch(infoDb, txn, LockMode.RMW);
                                    if (infoMap != null) break block14;
                                    this.logger.info("Unable to read secondary info database");
                                    TxnUtil.abort(txn);
                                    return;
                                }
                                if (currentSecondary != null) ** GOTO lbl23
                                currentSecondary = infoMap.getNextSecondaryToPopulate();
                                if (currentSecondary != null) break block15;
                                this.logger.info("Completed populating secondary database(s)");
                                TxnUtil.abort(txn);
                                return;
                            }
                            try {
                                this.logger.log(Level.FINE, "Started populating {0}", currentSecondary);
lbl23:
                                // 2 sources

                                info = infoMap.getSecondaryInfo(currentSecondary);
                                if (!PopulateThread.$assertionsDisabled && info == null) {
                                    throw new AssertionError();
                                }
                                if (!PopulateThread.$assertionsDisabled && !info.needsPopulating()) {
                                    throw new AssertionError();
                                }
                                if (info.getCurrentPartition() == null) {
                                    for (PartitionId partition : this.repNode.getPartitions()) {
                                        if (info.isCompleted(partition)) continue;
                                        info.setCurrentPartition(partition);
                                        break;
                                    }
                                }
                                if (info.getCurrentPartition() != null) break block16;
                                info.donePopulation();
                                this.logger.log(Level.FINE, "Finished populating {0} {1}", new Object[]{currentSecondary, info});
                                infoMap.persist(infoDb, txn);
                                txn.commit();
                                txn = null;
                                db = this.tableManager.getSecondaryDb(currentSecondary);
                                if (!PopulateThread.$assertionsDisabled && db == null) {
                                    throw new AssertionError();
                                }
                                db.endIncrementalPopulation();
                                currentSecondary = null;
                            }
                            catch (Throwable var9_9) {
                                TxnUtil.abort(txn);
                                throw var9_9;
                            }
                            TxnUtil.abort(txn);
                            continue;
                        }
                        partitionDb = this.repNode.getPartitionDB(info.getCurrentPartition());
                        if (partitionDb != null) break block17;
                        this.logger.log(Level.WARNING, "Failed to populate {0}, partition {1} is missing", new Object[]{info, info.getCurrentPartition()});
                        TxnUtil.abort(txn);
                        return;
                    }
                    db = this.tableManager.getSecondaryDb(currentSecondary);
                    if (db != null) break block18;
                    this.logger.log(Level.WARNING, "Failed to populate {0}, secondary database {1} is missing", new Object[]{info, currentSecondary});
                    TxnUtil.abort(txn);
                    return;
                }
                this.logger.log(Level.FINE, "Populating {0} {1}", new Object[]{currentSecondary, info});
                if (!partitionDb.populateSecondaries(info.getLastKey(), 100)) {
                    this.logger.log(Level.FINE, "Finished partition for {0}", info);
                    info.completeCurrentPartition();
                }
                infoMap.persist(infoDb, txn);
                txn.commit();
                txn = null;
                TxnUtil.abort(txn);
            }
        }
    }
}

