/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.monitor;

import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.fault.ProcessFaultHandler;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.AgentRepository;
import oracle.kv.impl.monitor.MonitorAgent;
import oracle.kv.impl.monitor.MonitorAgentFaultHandler;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.security.AuthContext;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.annotations.SecureAPI;
import oracle.kv.impl.security.annotations.SecureAutoMethod;
import oracle.kv.impl.security.annotations.SecureR2Method;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.registry.VersionedRemoteImpl;
import oracle.kv.impl.util.server.LoggerUtils;

@SecureAPI
public class MonitorAgentImpl
extends VersionedRemoteImpl
implements MonitorAgent {
    private final RepNodeService repNodeService;
    private final Logger logger;
    private final AgentRepository measurementBuffer;
    private final MonitorAgentFaultHandler faultHandler;
    private MonitorAgent exportableMonitorAgent;
    private final Logger consoleOnlyLogger;

    public MonitorAgentImpl(RepNodeService repNodeService, AgentRepository agentRepository) {
        this.repNodeService = repNodeService;
        this.logger = LoggerUtils.getLogger(this.getClass(), repNodeService.getParams());
        this.measurementBuffer = agentRepository;
        this.consoleOnlyLogger = LoggerUtils.getConsoleOnlyLogger(this.getClass(), repNodeService.getParams().getRepNodeParams().getRepNodeId());
        this.faultHandler = new MonitorAgentFaultHandler(this.logger);
    }

    @Override
    @SecureR2Method
    public List<Measurement> getMeasurements(short serialVersion) {
        throw new UnsupportedOperationException("Calls to this method must be made through the proxy interface.");
    }

    @Override
    @SecureAutoMethod(roles={KVStoreRole.AUTHENTICATED})
    public List<Measurement> getMeasurements(AuthContext authCtx, short serialVersion) {
        return this.faultHandler.execute(new ProcessFaultHandler.SimpleOperation<List<Measurement>>(){

            @Override
            public List<Measurement> execute() {
                return MonitorAgentImpl.this.fetchMeasurements();
            }
        });
    }

    private List<Measurement> fetchMeasurements() {
        AgentRepository.Snapshot snapshot = this.measurementBuffer.getAndReset();
        List<Measurement> info = snapshot.measurements;
        if (snapshot.serviceStatusChanges == 0) {
            ConfigurableService.ServiceStatus status = this.repNodeService.getStatusTracker().getServiceStatus();
            info.add(new ServiceStatusChange(status));
        }
        if (this.consoleOnlyLogger.isLoggable(Level.FINE)) {
            for (Measurement m : info) {
                this.consoleOnlyLogger.fine(m.toString());
            }
        }
        return info;
    }

    public void startup() throws RemoteException {
        RepNodeParams rnp = this.repNodeService.getRepNodeParams();
        String kvsName = this.repNodeService.getParams().getGlobalParams().getKVStoreName();
        String csfName = ClientSocketFactory.factoryName(kvsName, RepNodeId.getPrefix(), RegistryUtils.InterfaceType.MONITOR.interfaceName());
        StorageNodeParams snp = this.repNodeService.getParams().getStorageNodeParams();
        RMISocketPolicy rmiPolicy = this.repNodeService.getParams().getSecurityParams().getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = rnp.getMonitorSFP(rmiPolicy, snp.getServicePortRange(), csfName);
        this.logger.info("Starting RN MonitorAgent.  Server socket factory:" + sfp.getServerFactory() + " Client socket connect factory: " + sfp.getClientFactory());
        this.initExportableMonitorAgent();
        this.repNodeService.rebind(this.exportableMonitorAgent, RegistryUtils.InterfaceType.MONITOR, sfp.getClientFactory(), sfp.getServerFactory());
        this.logger.info("Starting MonitorAgent");
    }

    private void initExportableMonitorAgent() {
        try {
            this.exportableMonitorAgent = SecureProxy.create(this, this.repNodeService.getRepNodeSecurity().getAccessChecker(), this.faultHandler);
        }
        catch (ConfigurationException ce) {
            throw new IllegalStateException("Unabled to create proxy", ce);
        }
    }

    public void stop() throws RemoteException {
        int numItemsRemaining = this.measurementBuffer.size();
        this.logger.info("MonitorAgent stopping, " + numItemsRemaining + " items remain.");
        if (numItemsRemaining == 0) {
            return;
        }
        this.repNodeService.unbind(this.exportableMonitorAgent, RegistryUtils.InterfaceType.MONITOR);
        List<Measurement> remaining = this.getMeasurements(null, (short)4);
        if (remaining.size() <= 1) {
            return;
        }
        RepNodeService.Params params = this.repNodeService.getParams();
        RepNodeParams repNodeParams = params.getRepNodeParams();
        Logger dumpLogger = LoggerUtils.getFileOnlyLogger(this.getClass(), repNodeParams.getRepNodeId(), params.getGlobalParams(), params.getStorageNodeParams());
        dumpLogger.info("Saving untransmitted monitor info at shutdown.");
        if (!TestStatus.isActive()) {
            for (Measurement m : remaining) {
                System.err.println("[" + repNodeParams.getRepNodeId() + "] untransmitted monitor info " + "at shutdown: " + m);
                dumpLogger.info(m.toString());
            }
        }
    }
}

