/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Durability;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeStatus;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.migration.MigrationManager;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.migration.PartitionMigrations;
import oracle.kv.impl.rep.migration.TransferProtocol;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.util.Ping;

class MigrationTarget
implements Callable<MigrationTarget> {
    private final Logger logger;
    private static final int SECOND_MS = 1000;
    private static final int MAX_ERRORS = 10;
    private final long waitAfterBusy;
    private final long waitAfterError;
    private static final TransactionConfig weakConfig = new TransactionConfig().setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY).setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE));
    private final PartitionId partitionId;
    private final RepGroupId sourceRGId;
    private final long recordId;
    private final RepNode repNode;
    private final MigrationManager manager;
    private final ReplicatedEnvironment repEnv;
    private final ReaderFactory readerFactory;
    private DataChannel channel = null;
    private Database partitionDb = null;
    private volatile boolean running = false;
    private volatile boolean done = false;
    private volatile boolean inDone = false;
    private volatile boolean canceled = false;
    private Exception errorCause = null;
    private long retryWait = -1L;
    private String sourceName;
    private final long requestTime;
    private long startTime = 0L;
    private long endTime = 0L;
    private long operations = 0L;
    private int attempts = 0;
    private int busyResponses = 0;
    private int errors = 0;

    MigrationTarget(PartitionMigrations.TargetRecord record, RepNode repNode, MigrationManager manager, ReplicatedEnvironment repEnv, RepNodeService.Params params) {
        this.partitionId = record.getPartitionId();
        this.sourceRGId = record.getSourceRGId();
        this.sourceName = this.sourceRGId.getGroupName();
        this.recordId = record.getId();
        this.repNode = repNode;
        this.manager = manager;
        this.repEnv = repEnv;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        RepNodeParams repNodeParams = params.getRepNodeParams();
        this.waitAfterBusy = repNodeParams.getWaitAfterBusy();
        this.waitAfterError = repNodeParams.getWaitAfterError();
        this.readerFactory = new ReaderFactory();
        this.requestTime = System.currentTimeMillis();
    }

    RepGroupId getSource() {
        return this.sourceRGId;
    }

    long getRecordId() {
        return this.recordId;
    }

    PartitionMigrationStatus getStatus() {
        return this.getStatus(this.getState());
    }

    private PartitionMigrationStatus getStatus(RepNodeAdmin.PartitionMigrationState state) {
        return new PartitionMigrationStatus(state, this.partitionId.getPartitionId(), this.repNode.getRepNodeId().getGroupId(), this.sourceRGId.getGroupId(), this.operations, this.requestTime, this.startTime, this.endTime, this.attempts, this.busyResponses, this.errors);
    }

    RepNodeAdmin.PartitionMigrationState getState() {
        return this.done ? RepNodeAdmin.PartitionMigrationState.SUCCEEDED : (this.canceled ? RepNodeAdmin.PartitionMigrationState.ERROR.setCause(this.errorCause) : (this.running ? RepNodeAdmin.PartitionMigrationState.RUNNING : RepNodeAdmin.PartitionMigrationState.PENDING));
    }

    PartitionId getPartitionId() {
        return this.partitionId;
    }

    synchronized boolean cancel(boolean wait) {
        if (this.done || this.inDone) {
            return false;
        }
        this.setCanceled(wait, new Exception("Migration canceled"));
        return true;
    }

    private synchronized void setCanceled(boolean wait, Exception cause) {
        assert (!this.done);
        this.canceled = true;
        this.errorCause = cause;
        this.cleanup(wait);
    }

    private void error(String msg, Exception cause) {
        assert (!Thread.holdsLock(this));
        this.logger.log(Level.WARNING, msg, cause);
        this.setCanceled(false, new Exception(msg, cause));
        try {
            this.manager.removeRecord(this.partitionId, this.recordId, false);
        }
        catch (DatabaseException de) {
            this.logger.log(Level.INFO, "Exception attempting to remove migration record for " + this.partitionId, de);
        }
    }

    private synchronized void cleanup(boolean wait) {
        this.setStopped();
        if (wait && this.partitionDb != null) {
            try {
                this.logger.log(Level.INFO, "Waiting for {0} to exit", this);
                this.wait(2000L);
            }
            catch (InterruptedException ie) {
                this.logger.log(Level.INFO, "Unexpected interrupt", ie);
            }
        }
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception closing channel", ex);
            }
            this.channel = null;
        }
        if (this.partitionDb != null) {
            assert (!this.done);
            String dbName = this.partitionId.getPartitionName();
            this.logger.log(Level.INFO, "Removing migrated DB {0}", dbName);
            try {
                this.closeDB();
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception closing DB", ex);
            }
            try {
                this.repEnv.removeDatabase(null, dbName);
            }
            catch (DatabaseNotFoundException dnfe) {
            }
            catch (Exception ex) {
                this.logger.log(Level.WARNING, "Exception removing DB", ex);
            }
            this.repNode.getTableManager().notifyRemoval(this.partitionId);
        }
    }

    private synchronized void closeDB() {
        if (this.partitionDb != null) {
            this.partitionDb.close();
            this.partitionDb = null;
        }
        this.notifyAll();
    }

    private synchronized boolean setRunning() {
        assert (!this.running);
        this.running = !this.done && !this.canceled;
        return this.running;
    }

    private synchronized void setStopped() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDone() {
        this.endTime = System.currentTimeMillis();
        if (this.logger.isLoggable(Level.INFO)) {
            long seconds = (this.endTime - this.startTime) / 1000L;
            this.logger.log(Level.INFO, "Migration of {0} complete, {1} operations, transfer time: {2} seconds", new Object[]{this.partitionId, this.operations, seconds});
        }
        try {
            MigrationTarget migrationTarget = this;
            synchronized (migrationTarget) {
                block9: {
                    if (!this.canceled) break block9;
                    return;
                }
                this.inDone = true;
            }
            this.closeDB();
            this.done = this.persistTargetDurable();
        }
        finally {
            this.inDone = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public MigrationTarget call() {
        if (!this.setRunning()) {
            return null;
        }
        ++this.attempts;
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.operations = 0L;
        try {
            stream = this.openChannel();
            TransferProtocol.TransferRequest.write(this.channel, this.partitionId.getPartitionId(), this.repNode.getRepNodeId(), null);
            response = TransferProtocol.TransferRequest.readResponse(stream);
            switch (2.$SwitchMap$com$sleepycat$je$rep$utilint$ServiceDispatcher$Response[response.ordinal()]) {
                case 1: {
                    this.logger.log(Level.INFO, "Starting {0}", this);
                    this.createDb();
                    this.consumeOps(ReaderFactory.access$000(this.readerFactory, stream));
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 2: {
                    TransferProtocol.TransferRequest.readNumStreams(stream);
                    this.setRetryWait(true, new Exception("Source busy: " + TransferProtocol.TransferRequest.readReason(stream)));
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 3: {
                    this.setRetryWait(false, new Exception("Unknown service: " + TransferProtocol.TransferRequest.readReason(stream)));
                    ** break;
lbl28:
                    // 1 sources

                    break;
                }
                case 4: {
                    this.error("Fatal response " + (Object)response + " from source: " + TransferProtocol.TransferRequest.readReason(stream), null);
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 5: {
                    this.error("Authenticate response encountered outside of hello sequence", null);
                    ** break;
lbl36:
                    // 1 sources

                    break;
                }
                case 6: {
                    this.error("Proceed response encountered outside of hello sequence", null);
                    ** break;
lbl40:
                    // 1 sources

                    break;
                }
                case 7: {
                    this.error("Fatal response " + (Object)response + " from source: " + TransferProtocol.TransferRequest.readReason(stream), null);
                    break;
                }
                ** default:
lbl45:
                // 1 sources

                break;
            }
        }
        catch (IOException ioe) {
            this.setRetryWait(false, ioe);
        }
        catch (DatabaseException de) {
            this.setRetryWait(false, de);
        }
        catch (ServiceDispatcher.ServiceConnectFailedException scfe) {
            this.error("Failed to connect to migration service at " + this.sourceName + " for " + this.partitionId, scfe);
        }
        catch (Exception ex) {
            this.error("Unexpected exception, exiting", ex);
        }
        finally {
            if (this.endTime == 0L) {
                this.endTime = System.currentTimeMillis();
            }
            this.cleanup(false);
        }
        return this.getRetryWait() >= 0L ? this : null;
    }

    private void setRetryWait(boolean busy, Exception ex) {
        assert (!this.done);
        if (this.canceled) {
            return;
        }
        if (busy) {
            ++this.busyResponses;
        } else {
            ++this.errors;
        }
        if (this.errors >= 10) {
            this.error("Migration of " + this.partitionId + " failed. Giving up after " + this.attempts + " attempt(s)", ex);
            return;
        }
        this.retryWait = busy ? this.waitAfterBusy : this.waitAfterError;
        this.logger.log(Level.FINE, "Migration of {0} failed from: {1}", new Object[]{this.partitionId, ex.getLocalizedMessage()});
    }

    long getRetryWait() {
        assert (!this.running);
        if (this.canceled || this.done) {
            return -1L;
        }
        assert (this.retryWait >= 0L);
        return this.retryWait;
    }

    private synchronized DataInputStream openChannel() throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        Topology topo = this.repNode.getTopology();
        if (topo == null) {
            throw new IOException("Target node not yet initialized");
        }
        oracle.kv.impl.topo.RepNode rn = Ping.getMaster(topo, this.sourceRGId);
        RepNodeStatus status = Ping.getMasterStatus(topo, this.sourceRGId);
        String string = this.sourceName = rn == null ? this.sourceRGId.getGroupName() : ((RepNodeId)rn.getResourceId()).getFullName();
        if (status == null) {
            throw new IOException("Unable to get mastership status for " + this.sourceName);
        }
        String haHostPort = status.getHAHostPort();
        if (haHostPort == null) {
            throw new IllegalStateException("Source node " + this.sourceName + " is running an incompatible " + "software version");
        }
        InetSocketAddress sourceAddress = HostPortPair.getSocket(haHostPort);
        this.logger.log(Level.FINE, "Opening channel to {0} to make migration request", sourceAddress);
        RepNodeParams repNodeParams = this.repNode.getRepNodeParams();
        RepImpl repImpl = this.repNode.getEnvImpl(0L);
        if (repImpl == null) {
            throw new IllegalStateException("Attempt to migrate a partition on a node that is not available");
        }
        DataChannelFactory.ConnectOptions connectOpts = new DataChannelFactory.ConnectOptions().setTcpNoDelay(true).setReceiveBufferSize(0).setReadTimeout(repNodeParams.getReadWriteTimeout()).setOpenTimeout(repNodeParams.getConnectTImeout());
        this.channel = RepUtils.openBlockingChannel(sourceAddress, repImpl.getChannelFactory(), connectOpts);
        ServiceDispatcher.doServiceHandshake(this.channel, "PartitionMigration");
        return new DataInputStream(Channels.newInputStream(this.channel));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized DatabaseEntry createDb() {
        if (this.partitionDb != null) {
            Cursor cursor = this.partitionDb.openCursor(null, CursorConfig.DEFAULT);
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry value = new DatabaseEntry();
            OperationStatus status = cursor.getLast(key, value, LockMode.RMW);
            cursor.close();
            if (status != OperationStatus.SUCCESS) return null;
            DatabaseEntry databaseEntry = key;
            return databaseEntry;
        }
        TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        while (this.partitionDb == null) {
            Transaction txn = null;
            try {
                txn = this.repEnv.beginTransaction(null, txnConfig);
                this.partitionDb = this.repEnv.openDatabase(txn, this.partitionId.getPartitionName(), this.repNode.getPartitionDbConfig());
                txn.commit();
                txn = null;
            }
            catch (ReplicaWriteException rwe) {
                try {
                    String msg = "Attempted to start partition migration target for " + this.partitionId + " but node " + "has become a replica";
                    this.logger.log(Level.WARNING, msg, rwe);
                    throw new IllegalStateException(msg, rwe);
                    catch (UnknownMasterException ume) {
                        msg = "Attempted to start partition migration target for " + this.partitionId + " but node " + "has lost master status";
                        this.logger.log(Level.WARNING, msg, ume);
                        throw new IllegalStateException(msg, ume);
                    }
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
            }
            TxnUtil.abort(txn);
        }
        return null;
    }

    private void consumeOps(Reader reader) throws Exception {
        int count = 0;
        while (!this.done) {
            Op op = reader.remove();
            if (op == null) {
                throw new IOException("Reader returned null after " + count);
            }
            op.execute();
            ++count;
        }
    }

    private boolean persistTargetDurable() {
        assert (!Thread.holdsLock(this));
        this.logger.log(Level.FINE, "Persist target transfer durable for {0}", this.partitionId);
        final TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        txnConfig.setDurability(new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
        Boolean success = this.manager.tryDBOperation(new MigrationManager.DBOperation<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call(Database db) {
                Boolean bl;
                Transaction txn = null;
                try {
                    txn = db.getEnvironment().beginTransaction(null, txnConfig);
                    PartitionMigrations pm = PartitionMigrations.fetch(db, txn);
                    PartitionMigrations.TargetRecord record = pm.getTarget(MigrationTarget.this.partitionId);
                    if (record == null) {
                        throw new IllegalStateException("Unable to find migration record for " + MigrationTarget.this.partitionId);
                    }
                    record.setStatus(MigrationTarget.this.getStatus(RepNodeAdmin.PartitionMigrationState.SUCCEEDED));
                    pm.persist(db, txn, true);
                    txn.commit();
                    txn = null;
                    bl = true;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
                TxnUtil.abort(txn);
                return bl;
            }
        }, true);
        if (success == null || !success.booleanValue()) {
            return false;
        }
        this.manager.removeTarget(this.partitionId);
        this.manager.criticalUpdate();
        this.manager.setLastMigrationDuration(this.endTime - this.startTime);
        return true;
    }

    public String toString() {
        return "MigrationTarget[" + this.partitionId + ", " + this.sourceName + ", " + this.attempts + ", " + this.running + ", " + this.done + ", " + this.canceled + "]";
    }

    private class ReaderFactory
    extends KVThreadFactory {
        ReaderFactory() {
            super(" migration stream reader for ", MigrationTarget.this.logger);
        }

        private Reader newReader(DataInputStream stream) {
            Reader reader = new Reader(stream);
            this.newThread(reader).start();
            return reader;
        }

        static /* synthetic */ Reader access$000(ReaderFactory x0, DataInputStream x1) {
            return x0.newReader(x1);
        }
    }

    private class Reader
    implements Runnable {
        private final Map<Long, LocalTxn> txnMap = new HashMap<Long, LocalTxn>();
        private final Queue<Op> opQueue = new LinkedList<Op>();
        private static final int DEFAULT_CAPACITY = 100;
        private int capacity = 100;
        private final DataInputStream stream;
        private final DatabaseEntry keyEntry = new DatabaseEntry();
        private final DatabaseEntry valueEntry = new DatabaseEntry();

        Reader(DataInputStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                this.processStream();
            }
            catch (Exception ex) {
                if (!MigrationTarget.this.canceled) {
                    MigrationTarget.this.logger.log(Level.INFO, "Exception processing migration stream for " + MigrationTarget.this.partitionId, ex);
                }
                MigrationTarget.this.setStopped();
            }
        }

        private void processStream() throws Exception {
            while (MigrationTarget.this.running) {
                TransferProtocol.OP op = TransferProtocol.OP.get(this.stream.readByte());
                if (op == null) {
                    throw new IOException("Bad op, or unexpected EOF");
                }
                MigrationTarget.this.operations++;
                switch (op) {
                    case COPY: {
                        this.insert(new CopyOp(this.readDbEntry(), this.readDbEntry()));
                        break;
                    }
                    case PUT: {
                        this.insert(new PutOp(this.readTxnId(), this.readDbEntry(), this.readDbEntry()));
                        break;
                    }
                    case DELETE: {
                        this.insert(new DeleteOp(this.readTxnId(), this.readDbEntry()));
                        break;
                    }
                    case PREPARE: {
                        this.insert(new PrepareOp(this.readTxnId()));
                        break;
                    }
                    case COMMIT: {
                        this.resolve(this.readTxnId(), true);
                        break;
                    }
                    case ABORT: {
                        this.resolve(this.readTxnId(), false);
                        break;
                    }
                    case EOD: {
                        MigrationTarget.this.logger.log(Level.INFO, "Received EOD for {0}", MigrationTarget.this.partitionId);
                        for (LocalTxn txn : this.txnMap.values()) {
                            assert (!txn.resolved);
                            if (!txn.prepared) continue;
                            throw new Exception("Encountered prepared, but unresolved " + txn);
                        }
                        this.insert(new EoD());
                        return;
                    }
                }
            }
        }

        private long readTxnId() throws IOException {
            return this.stream.readLong();
        }

        private byte[] readDbEntry() throws IOException {
            int size = this.stream.readInt();
            byte[] bytes = new byte[size];
            this.stream.readFully(bytes);
            return bytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert(Op op) {
            Queue<Op> queue = this.opQueue;
            synchronized (queue) {
                if (!MigrationTarget.this.running) {
                    return;
                }
                this.opQueue.add(op);
                this.opQueue.notifyAll();
                while (this.opQueue.size() > this.capacity && MigrationTarget.this.running) {
                    try {
                        this.opQueue.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        MigrationTarget.this.logger.log(Level.WARNING, "Unexpected interrupt", ie);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Op remove() {
            Queue<Op> queue = this.opQueue;
            synchronized (queue) {
                while (MigrationTarget.this.running) {
                    Op op = this.opQueue.poll();
                    if (op != null) {
                        this.opQueue.notifyAll();
                        return op;
                    }
                    try {
                        this.opQueue.wait(1000L);
                    }
                    catch (InterruptedException ie) {
                        MigrationTarget.this.logger.log(Level.WARNING, "Unexpected interrupt", ie);
                        continue;
                    }
                    break;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolve(long txnId, boolean commit) {
            LocalTxn txn = this.txnMap.remove(txnId);
            assert (txn != null);
            Object object = txn;
            synchronized (object) {
                txn.resolve(commit);
                txn.notifyAll();
            }
            object = this.opQueue;
            synchronized (object) {
                this.opQueue.notifyAll();
            }
        }

        public String toString() {
            return "Reader[" + MigrationTarget.this.operations + ", " + this.opQueue.size() + "]";
        }

        private class LocalTxn {
            private final long txnId;
            private Transaction transaction = null;
            private boolean prepared = false;
            private boolean resolved = false;
            private boolean committed = false;

            LocalTxn(long txnId) {
                this.txnId = txnId;
            }

            Transaction getTransaction() {
                if (this.transaction == null) {
                    this.transaction = MigrationTarget.this.repEnv.beginTransaction(null, weakConfig);
                }
                return this.transaction;
            }

            void resolve(boolean commit) {
                assert (this.prepared);
                assert (!this.resolved);
                this.resolved = true;
                this.committed = commit;
            }

            void finish() {
                assert (this.resolved);
                assert (this.transaction != null);
                if (this.committed) {
                    this.transaction.commit();
                } else {
                    TxnUtil.abort(this.transaction);
                }
            }

            public String toString() {
                return "LocalTxn[" + this.txnId + ", " + this.transaction + ", prepared=" + this.prepared + ", resolved=" + this.resolved + ", committed=" + this.committed + "]";
            }
        }

        private class EoD
        extends Op {
            private EoD() {
            }

            @Override
            void execute() {
                MigrationTarget.this.setDone();
            }

            public String toString() {
                return "EoD[]";
            }
        }

        private class PrepareOp
        extends TxnOp {
            PrepareOp(long txnId) {
                super(txnId);
                this.txn.prepared = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void execute() {
                if (this.txn.transaction == null) {
                    MigrationTarget.this.logger.log(Level.FINE, "Prepare with no txn for {0}, {1}", new Object[]{this.txn, MigrationTarget.this.partitionId});
                    return;
                }
                LocalTxn localTxn = this.txn;
                synchronized (localTxn) {
                    if (!this.txn.resolved) {
                        Queue queue = Reader.this.opQueue;
                        synchronized (queue) {
                            Reader.this.capacity = Integer.MAX_VALUE;
                            Reader.this.opQueue.notifyAll();
                        }
                    }
                    while (!this.txn.resolved && MigrationTarget.this.running) {
                        MigrationTarget.this.logger.log(Level.FINE, "Waiting for resolution of {0}, {1} {2} ops", new Object[]{this.txn, MigrationTarget.this.partitionId, MigrationTarget.this.operations});
                        try {
                            this.txn.wait(1000L);
                        }
                        catch (InterruptedException ie) {
                            MigrationTarget.this.logger.log(Level.WARNING, "Unexpected interrupt", ie);
                        }
                    }
                }
                Reader.this.capacity = 100;
                this.txn.finish();
            }

            public String toString() {
                return "PrepareOp[" + this.txn + "]";
            }
        }

        private class DeleteOp
        extends TxnOp {
            final byte[] key;

            DeleteOp(long txnId, byte[] key) {
                super(txnId);
                this.key = key;
            }

            @Override
            void execute() {
                Reader.this.keyEntry.setData(this.key);
                MigrationTarget.this.partitionDb.delete(this.getTransaction(), Reader.this.keyEntry);
            }

            public String toString() {
                return "DeleteOp[" + this.txn.txnId + ", " + this.key.length + "]";
            }
        }

        private class PutOp
        extends TxnOp {
            final byte[] key;
            final byte[] value;

            PutOp(long txnId, byte[] key, byte[] value) {
                super(txnId);
                this.key = key;
                this.value = value;
            }

            @Override
            void execute() {
                Reader.this.keyEntry.setData(this.key);
                Reader.this.valueEntry.setData(this.value);
                MigrationTarget.this.partitionDb.put(this.getTransaction(), Reader.this.keyEntry, Reader.this.valueEntry);
            }

            public String toString() {
                return "PutOp[" + this.txn.txnId + ", " + this.key.length + ", " + this.value.length + "]";
            }
        }

        private abstract class TxnOp
        extends Op {
            final LocalTxn txn;

            protected TxnOp(long txnId) {
                LocalTxn t = (LocalTxn)Reader.this.txnMap.get(txnId);
                if (t == null) {
                    t = new LocalTxn(txnId);
                    Reader.this.txnMap.put(txnId, t);
                }
                this.txn = t;
            }

            protected Transaction getTransaction() {
                return this.txn.getTransaction();
            }
        }

        private class CopyOp
        extends Op {
            final byte[] key;
            final byte[] value;

            CopyOp(byte[] key, byte[] value) {
                this.key = key;
                this.value = value;
            }

            @Override
            void execute() {
                Reader.this.keyEntry.setData(this.key);
                Reader.this.valueEntry.setData(this.value);
                MigrationTarget.this.partitionDb.put(null, Reader.this.keyEntry, Reader.this.valueEntry);
            }

            public String toString() {
                return "CopyOp[" + this.key.length + ", " + this.value.length + "]";
            }
        }
    }

    private static abstract class Op {
        private Op() {
        }

        abstract void execute();
    }
}

