/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.migration;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.IOException;
import java.nio.channels.Channel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.rep.IncorrectRoutingException;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.migration.MigrationManager;
import oracle.kv.impl.rep.migration.MigrationSource;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.migration.PartitionMigrations;
import oracle.kv.impl.rep.migration.TransferProtocol;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.util.KVThreadFactory;
import oracle.kv.impl.util.server.LoggerUtils;

class MigrationService
implements Runnable {
    private final Logger logger;
    static final String SERVICE_NAME = "PartitionMigration";
    private static long POLL_TIMEOUT = Long.MAX_VALUE;
    private final RepNode repNode;
    private final RepNodeService.Params params;
    private final int concurrentSourceLimit;
    final MigrationManager manager;
    private ThreadFactory sourceThreadFactory = null;
    private final BlockingQueue<DataChannel> queue = new LinkedBlockingQueue<DataChannel>();
    private final Map<PartitionId, MigrationSource> sourceMap = new HashMap<PartitionId, MigrationSource>();
    private volatile boolean enabled = false;
    private int requestErrors = 0;
    TestHook<DatabaseEntry> readHook;
    private TestHook<AtomicReference<ServiceDispatcher.Response>> responseHook;

    MigrationService(RepNode repNode, MigrationManager manager, RepNodeService.Params params) {
        this.repNode = repNode;
        this.manager = manager;
        this.params = params;
        this.concurrentSourceLimit = params.getRepNodeParams().getConcurrentSourceLimit();
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
    }

    synchronized void getStatus(HashSet<PartitionMigrationStatus> status) {
        for (MigrationSource source : this.sourceMap.values()) {
            status.add(source.getStatus());
        }
    }

    synchronized PartitionMigrationStatus getStatus(PartitionId partitionId) {
        MigrationSource source = this.sourceMap.get(partitionId);
        return source == null ? null : source.getStatus();
    }

    synchronized void start(ReplicatedEnvironment repEnv) {
        if (this.enabled) {
            throw new IllegalStateException("Service already started");
        }
        assert (repEnv != null);
        RepImpl repImpl = RepInternal.getRepImpl(repEnv);
        if (repImpl == null) {
            return;
        }
        ServiceDispatcher dispatcher = repImpl.getRepNode().getServiceDispatcher();
        if (dispatcher.isRegistered(SERVICE_NAME)) {
            throw new IllegalStateException("Service already registered");
        }
        this.enabled = true;
        Thread t = new KVThreadFactory(" migration service", this.logger).newThread(this);
        ServiceDispatcher serviceDispatcher = dispatcher;
        serviceDispatcher.getClass();
        dispatcher.register(new ServiceDispatcher.LazyQueuingService(serviceDispatcher, SERVICE_NAME, this.queue, t));
        this.logger.info("Migration service accepting requests.");
    }

    synchronized void stop(boolean shutdown, boolean wait, ReplicatedEnvironment repEnv) {
        ServiceDispatcher dispatcher;
        RepImpl repImpl;
        assert (repEnv != null);
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        if (!shutdown && (repImpl = RepInternal.getRepImpl(repEnv)) != null && (dispatcher = repImpl.getRepNode().getServiceDispatcher()).isRegistered(SERVICE_NAME)) {
            this.logger.log(Level.INFO, "Stopping {0}", this);
            dispatcher.cancel(SERVICE_NAME);
        }
        for (MigrationSource source : this.sourceMap.values()) {
            source.cancel(wait);
        }
        this.sourceMap.clear();
    }

    synchronized void cancel(PartitionId partitionId, RepGroupId targetRGId) {
        MigrationSource source = this.sourceMap.get(partitionId);
        if (source != null && source.getTargetGroupId() == targetRGId.getGroupId()) {
            source.cancel(true);
            this.removeSource(partitionId);
        }
    }

    synchronized MigrationSource getSource(PartitionId partitionId) {
        return this.sourceMap.get(partitionId);
    }

    synchronized void removeSource(PartitionId partitionId) {
        this.sourceMap.remove(partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        this.logger.log(Level.INFO, "Migration service thread started.");
        try {
            while (this.enabled) {
                DataChannel channel = null;
                try {
                    channel = this.queue.poll(POLL_TIMEOUT, TimeUnit.MILLISECONDS);
                    if (channel == RepUtils.CHANNEL_EOF_MARKER) {
                        this.logger.info("EOF marker - shutdown");
                        return;
                    }
                }
                catch (IOException ioe) {
                    this.closeChannel(channel);
                    this.logger.log(Level.INFO, "IOException processing migration request: ", ioe);
                    continue;
                }
                catch (InterruptedException ie) {
                    this.logger.info("Migration service interrupted");
                    this.logger.info("Migration service thread exit");
                    return;
                }
                {
                    if (channel == null) continue;
                    this.processRequest(channel);
                }
            }
            return;
        }
        finally {
            this.logger.info("Migration service thread exit");
        }
    }

    private void closeChannel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException ioe) {
                this.logger.log(Level.WARNING, "Exception during cleanup", ioe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRequest(DataChannel channel) throws IOException {
        TransferProtocol.TransferRequest request = TransferProtocol.TransferRequest.read(channel);
        AtomicReference hookedResponse = new AtomicReference();
        assert (TestHookExecute.doHookIfSet(this.responseHook, hookedResponse));
        if (this.responseHook != null && hookedResponse.get() != null) {
            ServiceDispatcher.Response response = (ServiceDispatcher.Response)((Object)hookedResponse.get());
            if (response.equals((Object)ServiceDispatcher.Response.BUSY)) {
                this.reportBusy(this.concurrentSourceLimit, "Test busy", channel);
            } else {
                this.reportError(response, "Test error: " + (Object)((Object)response), channel);
            }
            return;
        }
        PartitionId partitionId = new PartitionId(request.partitionId);
        int targetGroupId = request.targetRNId.getGroupId();
        try {
            this.repNode.getPartitionDB(partitionId);
        }
        catch (IncorrectRoutingException ire) {
            if (this.checkForRestart(partitionId, targetGroupId)) {
                this.reportBusy(this.concurrentSourceLimit, "Migration source resetting " + partitionId, channel);
                return;
            }
            this.reportError(ServiceDispatcher.Response.UNKNOWN_SERVICE, "Request for unknown: " + ire.getLocalizedMessage(), channel);
            return;
        }
        if (this.repNode.getTopology().get(new RepGroupId(targetGroupId)) == null) {
            this.reportBusy(0, "Migration source needs updated topology, target group " + targetGroupId + " unknown", channel);
            return;
        }
        DatabaseEntry lastKey = request.lastKey;
        this.logger.log(Level.FINE, "Received migration request for {0} to {1}, lastKey= {2}", new Object[]{partitionId, targetGroupId, lastKey});
        MigrationService migrationService = this;
        synchronized (migrationService) {
            if (!this.enabled) {
                this.reportBusy(0, "Migration source not enabled for " + partitionId, channel);
                return;
            }
            int running = 0;
            Iterator<MigrationSource> itr = this.sourceMap.values().iterator();
            while (itr.hasNext()) {
                if (itr.next().isAlive()) {
                    ++running;
                    continue;
                }
                itr.remove();
            }
            if (running >= this.concurrentSourceLimit) {
                this.reportBusy(this.concurrentSourceLimit, "Migration source busy. Number of streams= " + this.sourceMap.size() + ", max= " + this.concurrentSourceLimit, channel);
                return;
            }
            MigrationSource source = this.sourceMap.get(partitionId);
            if (source != null) {
                source.cancel(false);
                this.reportBusy(this.concurrentSourceLimit, "Source for " + partitionId + " already running: " + source.toString(), channel);
                return;
            }
            source = new MigrationSource(channel, partitionId, request.targetRNId, this.repNode, this, this.params);
            this.sourceMap.put(partitionId, source);
            try {
                TransferProtocol.TransferRequest.writeACKResponse(channel);
            }
            catch (IOException ioe) {
                this.sourceMap.remove(partitionId);
                this.closeChannel(channel);
                throw ioe;
            }
            if (this.sourceThreadFactory == null) {
                this.sourceThreadFactory = new KVThreadFactory(" partition migration source", this.logger);
            }
            this.logger.log(Level.INFO, "Starting {0}", source);
            this.sourceThreadFactory.newThread(source).start();
        }
    }

    private boolean checkForRestart(PartitionId partitionId, int targetGroupId) {
        PartitionMigrations migrations = this.manager.getMigrations();
        if (migrations == null) {
            return false;
        }
        PartitionMigrations.SourceRecord record = migrations.getSource(partitionId);
        if (record == null || !record.getTargetRGId().equals(new RepGroupId(targetGroupId))) {
            return false;
        }
        try {
            this.logger.log(Level.INFO, "Migration source detected restart of {0}, removing completed record", record);
            this.manager.removeRecord(record, true);
        }
        catch (DatabaseException de) {
            this.logger.log(Level.WARNING, "Exception removing " + record, de);
        }
        return true;
    }

    private void reportBusy(int numStreams, String message, DataChannel channel) {
        ++this.requestErrors;
        this.logger.log(Level.FINE, message);
        try {
            TransferProtocol.TransferRequest.writeBusyResponse(channel, numStreams, message);
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, "Exception sending busy response", ioe);
        }
        this.closeChannel(channel);
    }

    private void reportError(ServiceDispatcher.Response response, String message, DataChannel channel) {
        assert (response.equals((Object)ServiceDispatcher.Response.FORMAT_ERROR) || response.equals((Object)ServiceDispatcher.Response.UNKNOWN_SERVICE));
        ++this.requestErrors;
        this.logger.log(Level.INFO, message);
        try {
            TransferProtocol.TransferRequest.writeErrorResponse(channel, response, message);
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, "Exception sending error response", ioe);
        }
        this.closeChannel(channel);
    }

    void setReadHook(TestHook<DatabaseEntry> hook) {
        this.readHook = hook;
    }

    void setResponseHook(TestHook<AtomicReference<ServiceDispatcher.Response>> hook) {
        this.responseHook = hook;
    }

    public String toString() {
        return "MigrationService[" + this.enabled + ", " + this.sourceMap.size() + ", " + this.requestErrors + "]";
    }
}

