/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.login;

import java.rmi.RemoteException;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.RepNodeSecurity;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.RepNodeServiceFaultHandler;
import oracle.kv.impl.rep.login.FailoverSessionManager;
import oracle.kv.impl.rep.login.KVSessionManager;
import oracle.kv.impl.security.ConfigurationException;
import oracle.kv.impl.security.SecureProxy;
import oracle.kv.impl.security.UserVerifier;
import oracle.kv.impl.security.login.LoginTable;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.UserLogin;
import oracle.kv.impl.security.login.UserLoginHandler;
import oracle.kv.impl.security.login.UserLoginImpl;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.util.registry.ClientSocketFactory;
import oracle.kv.impl.util.registry.RMISocketPolicy;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.impl.util.server.LoggerUtils;

public class RepNodeLoginService
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater {
    private final RepNodeService repNodeService;
    private final RepNodeServiceFaultHandler faultHandler;
    private final UserLogin userLogin;
    private UserLogin exportableUL;
    private final Logger logger;
    private final UserLoginHandler loginHandler;
    private LoginTable tableSessionMgr;

    public RepNodeLoginService(RepNodeService repNodeService) {
        this.repNodeService = repNodeService;
        this.logger = LoggerUtils.getLogger(this.getClass(), repNodeService.getParams());
        if (repNodeService.getParams().getSecurityParams().isSecure()) {
            this.faultHandler = new RepNodeServiceFaultHandler(repNodeService, this.logger, ProcessExitCode.RESTART);
            this.loginHandler = this.makeLoginHandler(repNodeService.getRepNodeSecurity().getKVSessionManager());
            this.userLogin = new UserLoginImpl(this.faultHandler, this.loginHandler, this.logger);
        } else {
            this.faultHandler = null;
            this.userLogin = null;
            this.loginHandler = null;
        }
    }

    public UserLogin getUserLogin() {
        return this.userLogin;
    }

    private UserLoginHandler makeLoginHandler(KVSessionManager kvSessMgr) {
        UserVerifier verifier = this.repNodeService.getRepNodeSecurity().getUserVerifier();
        RepNodeId rnId = this.repNodeService.getRepNodeId();
        GlobalParams gp = this.repNodeService.getParams().getGlobalParams();
        UserLoginHandler.LoginConfig loginConfig = UserLoginHandler.LoginConfig.buildLoginConfig(gp);
        RepNodeParams rp = this.repNodeService.getRepNodeParams();
        this.tableSessionMgr = new LoginTable(rp.getSessionLimit(), new byte[0], 16);
        FailoverSessionManager failSessMgr = new FailoverSessionManager(kvSessMgr, this.tableSessionMgr, this.logger);
        UserLoginHandler ulh = new UserLoginHandler(rnId, false, verifier, failSessMgr, loginConfig, this.logger);
        return ulh;
    }

    public void startup() throws RemoteException {
        if (this.userLogin == null) {
            this.logger.info("No RN Login configured. ");
            return;
        }
        RepNodeParams rnp = this.repNodeService.getRepNodeParams();
        String kvsName = this.repNodeService.getParams().getGlobalParams().getKVStoreName();
        String csfName = ClientSocketFactory.factoryName(kvsName, RepNodeId.getPrefix(), RegistryUtils.InterfaceType.LOGIN.interfaceName());
        StorageNodeParams snp = this.repNodeService.getParams().getStorageNodeParams();
        RMISocketPolicy rmiPolicy = this.repNodeService.getParams().getSecurityParams().getRMISocketPolicy();
        RMISocketPolicy.SocketFactoryPair sfp = rnp.getLoginSFP(rmiPolicy, snp.getServicePortRange(), csfName);
        this.initExportableUL();
        this.logger.info("Starting RN Login.  Server socket factory:" + sfp.getServerFactory() + " Client socket connect factory: " + sfp.getClientFactory());
        this.repNodeService.rebind(this.exportableUL, RegistryUtils.InterfaceType.LOGIN, sfp.getClientFactory(), sfp.getServerFactory());
        this.logger.info("Starting UserLogin");
    }

    public void stop() throws RemoteException {
        if (this.userLogin != null) {
            this.repNodeService.unbind(this.exportableUL, RegistryUtils.InterfaceType.LOGIN);
        }
    }

    private void initExportableUL() {
        RepNodeSecurity rnSecurity = this.repNodeService.getRepNodeSecurity();
        try {
            this.exportableUL = SecureProxy.create(this.userLogin, rnSecurity.getAccessChecker(), this.faultHandler);
            this.logger.info("Successfully created secure proxy for the user login");
        }
        catch (ConfigurationException ce) {
            throw new IllegalStateException("Unabled to create proxy", ce);
        }
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.tableSessionMgr == null) {
            return;
        }
        int newLimit = map.getOrDefault("sessionLimit").asInt();
        if (this.tableSessionMgr.updateSessionLimit(newLimit)) {
            this.logger.info("SessionLimit for LoginTable has been updated with " + newLimit);
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.loginHandler == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        UserLoginHandler.LoginConfig config = UserLoginHandler.LoginConfig.buildLoginConfig(gp);
        this.loginHandler.updateConfig(config);
        this.logger.info("Config for UserLoginHandler has been updated with GlobalParams:" + gp.getMap());
    }
}

