/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep.login;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import javax.security.auth.Subject;
import oracle.kv.impl.security.KVStoreRole;
import oracle.kv.impl.security.KVStoreRolePrincipal;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.login.LoginSession;

public class KVSession {
    static final int VERSION = 1;
    static final int NEXT_VERSION = 2;
    private byte version;
    private byte[] sessionId;
    private String userId;
    private String userName;
    private KVStoreRole[] roles;
    private String clientHost;
    private long sessionExpire;
    byte[] remainder;

    private KVSession(byte version) {
        this.version = version;
    }

    public KVSession(LoginSession session) throws IllegalArgumentException {
        if (session == null) {
            throw new IllegalArgumentException("session may not be null");
        }
        this.version = 1;
        byte[] idValue = session.getId().getValue();
        this.sessionId = Arrays.copyOf(idValue, idValue.length);
        Subject subj = session.getSubject();
        KVStoreUserPrincipal userPrinc = KVStoreUserPrincipal.getSubjectUser(subj);
        if (userPrinc == null) {
            throw new IllegalArgumentException("No user principal associated with the login session");
        }
        this.userId = userPrinc.getUserId();
        this.userName = userPrinc.getName();
        this.roles = KVStoreRolePrincipal.getSubjectRoles(subj);
        if (this.roles == null) {
            this.roles = new KVStoreRole[0];
        }
        this.clientHost = session.getClientHost();
        this.sessionExpire = session.getExpireTime();
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.write(this.version);
        dos.write(this.sessionId.length);
        dos.write(this.sessionId, 0, this.sessionId.length);
        if (this.userId == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.userId);
        }
        if (this.userName == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.userName);
        }
        if (this.clientHost == null) {
            dos.writeBoolean(false);
        } else {
            dos.writeBoolean(true);
            dos.writeUTF(this.clientHost);
        }
        dos.write(this.roles.length);
        for (int i = 0; i < this.roles.length; ++i) {
            dos.writeUTF(this.roles[i].name());
        }
        dos.writeLong(this.sessionExpire);
        if (this.remainder != null) {
            dos.write(this.remainder, 0, this.remainder.length);
        }
        dos.close();
        return baos.toByteArray();
    }

    public static KVSession fromByteArray(byte[] data) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bais);
        byte version = dis.readByte();
        if (version != 1 && version != 2) {
            throw new IOException("Unsupported version: " + version);
        }
        KVSession session = new KVSession(version);
        byte sidLen = dis.readByte();
        session.sessionId = new byte[sidLen];
        dis.readFully(session.sessionId);
        boolean haveUserId = dis.readBoolean();
        session.userId = haveUserId ? dis.readUTF() : null;
        boolean haveUserName = dis.readBoolean();
        session.userName = haveUserName ? dis.readUTF() : null;
        boolean haveClientHost = dis.readBoolean();
        session.clientHost = haveClientHost ? dis.readUTF() : null;
        int nRoles = dis.readByte();
        session.roles = new KVStoreRole[nRoles];
        for (int i = 0; i < nRoles; ++i) {
            session.roles[i] = Enum.valueOf(KVStoreRole.class, dis.readUTF());
        }
        session.sessionExpire = dis.readLong();
        if (version == 2) {
            byte[] buffer = new byte[data.length];
            int bytesRead = dis.read(buffer);
            if (bytesRead > 0) {
                session.remainder = Arrays.copyOfRange(buffer, 0, bytesRead);
            }
        } else {
            int read = dis.read(new byte[1]);
            if (read > 0) {
                throw new IOException("Encountered unexpected data");
            }
        }
        dis.close();
        return session;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public long getSessionExpire() {
        return this.sessionExpire;
    }

    public void setSessionExpire(long expireTime) {
        this.sessionExpire = expireTime;
    }

    public LoginSession makeLoginSession() {
        LoginSession sess = new LoginSession(new LoginSession.Id(this.sessionId), this.makeSubject(), this.clientHost, true);
        sess.setExpireTime(this.sessionExpire);
        return sess;
    }

    void setVersion(byte version) {
        this.version = version;
    }

    private Subject makeSubject() {
        HashSet<Principal> princs = new HashSet<Principal>();
        princs.add(new KVStoreUserPrincipal(this.userName, this.userId));
        for (KVStoreRole role : this.roles) {
            princs.add(KVStoreRolePrincipal.get(role));
        }
        HashSet publicCreds = new HashSet();
        HashSet privateCreds = new HashSet();
        return new Subject(true, princs, publicCreds, privateCreds);
    }
}

