/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.rep.RepNode;

public abstract class StateTracker
extends StoppableThread {
    private final BlockingQueue<StateChangeEvent> stateTransitions = new ArrayBlockingQueue<StateChangeEvent>(2);
    private static StateChangeEvent EOQ_DETACHED_STATE_MARKER = new StateChangeEvent(ReplicatedEnvironment.State.DETACHED, NameIdPair.NULL);
    protected final RepNode rn;
    protected final AtomicBoolean shutdown = new AtomicBoolean(false);
    private static final int SOFT_SHUTDOWN_MS = 10000;
    protected final Logger logger;

    protected StateTracker(String name, RepNode rn, Logger logger) {
        super(null, rn.getExceptionHandler(), name);
        this.rn = rn;
        this.logger = logger;
    }

    protected boolean isEmpty() {
        return this.stateTransitions.isEmpty();
    }

    public void noteStateChange(StateChangeEvent stateChangeEvent) {
        while (true) {
            try {
                this.stateTransitions.add(stateChangeEvent);
                this.logger.log(Level.INFO, "{0} queue added:{1}", new Object[]{this.getName(), stateChangeEvent.getState()});
                return;
            }
            catch (IllegalStateException e) {
                try {
                    StateChangeEvent rem = (StateChangeEvent)this.stateTransitions.remove();
                    if (rem == EOQ_DETACHED_STATE_MARKER) {
                        stateChangeEvent = EOQ_DETACHED_STATE_MARKER;
                        continue;
                    }
                    this.logger.log(Level.INFO, "{0} entry removed:{1}", new Object[]{this.getName(), rem});
                }
                catch (NoSuchElementException noSuchElementException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        boolean interrupted = false;
        try {
            this.runInternal();
        }
        catch (ThreadInterruptedException tie) {
            interrupted = true;
            this.logger.log(Level.INFO, "{0} thread exited rn: {1}{2}", new Object[]{this.getName(), this.rn.getRepNodeId(), interrupted ? " Interrupted. " : ""});
        }
        catch (InterruptedException e) {
            interrupted = true;
            {
                catch (Throwable throwable) {
                    this.logger.log(Level.INFO, "{0} thread exited rn: {1}{2}", new Object[]{this.getName(), this.rn.getRepNodeId(), interrupted ? " Interrupted. " : ""});
                    throw throwable;
                }
            }
            this.logger.log(Level.INFO, "{0} thread exited rn: {1}{2}", new Object[]{this.getName(), this.rn.getRepNodeId(), interrupted ? " Interrupted. " : ""});
        }
        this.logger.log(Level.INFO, "{0} thread exited rn: {1}{2}", new Object[]{this.getName(), this.rn.getRepNodeId(), interrupted ? " Interrupted. " : ""});
    }

    private void runInternal() throws InterruptedException {
        this.logger.log(Level.INFO, "{0} thread start rn: {1}", new Object[]{this.getName(), this.rn.getRepNodeId()});
        while (!this.shutdown.get()) {
            StateChangeEvent sce = this.stateTransitions.take();
            if (!this.isEmpty()) continue;
            this.doNotify(sce);
            if (sce != EOQ_DETACHED_STATE_MARKER) continue;
            break;
        }
    }

    protected abstract void doNotify(StateChangeEvent var1) throws InterruptedException;

    @Override
    public int initiateSoftShutdown() {
        assert (this.shutdown.get());
        long limitMs = System.currentTimeMillis() + 10000L;
        this.noteStateChange(EOQ_DETACHED_STATE_MARKER);
        long waitMs = limitMs - System.currentTimeMillis();
        return waitMs <= 0L ? -1 : (int)waitMs;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public void shutdown() {
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.shutdownThread(this.logger);
    }
}

