/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.fault.DatabaseNotReadyException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.rep.MetadataManager;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadataInfo;

public class SecurityMetadataManager
extends MetadataManager<SecurityMetadata> {
    private static final int MAX_CHANGES = 1000;
    private volatile SecurityMetadata securityMetadata;
    private final String kvstoreName;
    private final int maxChanges;

    public SecurityMetadataManager(RepNode repNode, String storeName, Logger logger) {
        this(repNode, storeName, 1000, logger);
    }

    public SecurityMetadataManager(RepNode repNode, String storeName, int maxSecMDChanges, Logger logger) {
        super(repNode, logger);
        if (maxSecMDChanges <= 0) {
            throw new IllegalArgumentException("Max change limit must be a positive integer.");
        }
        this.kvstoreName = storeName;
        this.maxChanges = maxSecMDChanges;
    }

    @Override
    protected Metadata.MetadataType getType() {
        return Metadata.MetadataType.SECURITY;
    }

    public synchronized boolean update(SecurityMetadata newSecurityMD) {
        int newSeqNum;
        if (newSecurityMD == null) {
            throw new NullPointerException("The new copy of SecurityMetadata should not be null.");
        }
        if (!this.kvstoreName.equals(newSecurityMD.getKVStoreName())) {
            throw new IllegalStateException("Trying to update with security metadata from store: " + newSecurityMD.getKVStoreName() + ", but expected: " + this.kvstoreName);
        }
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null || !repEnv.getState().isMaster()) {
            return false;
        }
        this.securityMetadata = this.getSecurityMetadata();
        int currentSeqNum = this.securityMetadata == null ? 0 : this.securityMetadata.getSequenceNumber();
        if (currentSeqNum >= (newSeqNum = newSecurityMD.getSequenceNumber())) {
            this.logger.log(Level.INFO, "Security metadata update skipped. Current seq #: {0} Update seq #: {1}", new Object[]{currentSeqNum, newSeqNum});
            return true;
        }
        SecurityMetadata prunedMd = SecurityMetadataManager.pruneChanges(newSecurityMD, this.maxChanges, Integer.MAX_VALUE);
        if (this.persistMetadata(prunedMd)) {
            this.securityMetadata = prunedMd;
            this.logger.log(Level.INFO, "Security metadata updated from seq#: {0} to {1}", new Object[]{currentSeqNum, newSeqNum});
        }
        return true;
    }

    public synchronized int update(SecurityMetadataInfo newSecurityMDInfo) {
        SecurityMetadata secMDCopy;
        int prevSeqNum;
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv == null) {
            return 0;
        }
        this.securityMetadata = this.getSecurityMetadata();
        if (!repEnv.getState().isMaster()) {
            return this.securityMetadata.getSequenceNumber();
        }
        int n = prevSeqNum = this.securityMetadata == null ? 0 : this.securityMetadata.getSequenceNumber();
        if (newSecurityMDInfo.getChanges() == null || newSecurityMDInfo.getChanges().isEmpty()) {
            this.logger.warning("Empty change list sent for security metadata update");
            return prevSeqNum;
        }
        if (newSecurityMDInfo.getChanges().get(0).getSeqNum() > prevSeqNum + 1) {
            this.logger.info("Ignoring security metadata update request. Current seq num: " + prevSeqNum + " first change: " + newSecurityMDInfo.getChanges().get(0).getSeqNum());
            return prevSeqNum;
        }
        SecurityMetadata securityMetadata = secMDCopy = this.securityMetadata == null ? new SecurityMetadata(this.kvstoreName, newSecurityMDInfo.getSecurityMetadataId()) : this.securityMetadata.getCopy();
        if (!secMDCopy.apply(newSecurityMDInfo.getChanges())) {
            return prevSeqNum;
        }
        SecurityMetadata prunedMd = SecurityMetadataManager.pruneChanges(secMDCopy, this.maxChanges, newSecurityMDInfo.getChanges().get(0).getSeqNum());
        if (this.persistMetadata(prunedMd)) {
            this.securityMetadata = prunedMd;
            this.logger.log(Level.INFO, "Security metadata updated from seq#: {0} to {1}", new Object[]{prevSeqNum, this.securityMetadata.getSequenceNumber()});
        }
        return this.securityMetadata.getSequenceNumber();
    }

    @Override
    protected synchronized void update(ReplicatedEnvironment repEnv) {
        this.securityMetadata = null;
    }

    public synchronized SecurityMetadata getSecurityMetadata() {
        if (this.securityMetadata == null) {
            try {
                this.securityMetadata = (SecurityMetadata)this.fetchMetadata();
            }
            catch (DatabaseNotReadyException dnre) {
                throw new RNUnavailableException("Security metadata database is not opened yet.");
            }
        }
        return this.securityMetadata;
    }

    private static SecurityMetadata pruneChanges(SecurityMetadata secMD, int limit, int minRetainSeqNum) {
        int firstChangeSeqNum = secMD.getFirstChangeSeqNum();
        if (firstChangeSeqNum < 0) {
            return secMD;
        }
        int newStartSeqNum = Math.min(secMD.getSequenceNumber() - limit + 1, minRetainSeqNum);
        if (newStartSeqNum > firstChangeSeqNum) {
            secMD.discardChanges(newStartSeqNum);
        }
        return secMD;
    }
}

