/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import java.util.logging.Logger;
import javax.security.auth.Subject;
import oracle.kv.LoginCredentials;
import oracle.kv.PasswordCredentials;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.SecurityParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.login.FailoverSessionManager;
import oracle.kv.impl.rep.login.KVSessionManager;
import oracle.kv.impl.security.AccessChecker;
import oracle.kv.impl.security.AccessCheckerImpl;
import oracle.kv.impl.security.ExecutionContext;
import oracle.kv.impl.security.KVStoreUserPrincipal;
import oracle.kv.impl.security.ProxyCredentials;
import oracle.kv.impl.security.UserVerifier;
import oracle.kv.impl.security.login.InternalLoginManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.login.LoginUpdater;
import oracle.kv.impl.security.login.TokenResolverImpl;
import oracle.kv.impl.security.login.TokenVerifier;
import oracle.kv.impl.security.login.TopoTopoResolver;
import oracle.kv.impl.security.login.TopologyResolver;
import oracle.kv.impl.security.metadata.KVStoreUser;
import oracle.kv.impl.security.metadata.SecurityMetadata;

public class RepNodeSecurity
implements LoginUpdater.GlobalParamsUpdater,
LoginUpdater.ServiceParamsUpdater {
    private final RepNodeService repNodeService;
    private final AccessChecker accessChecker;
    private final TokenResolverImpl tokenResolver;
    private final TopoTopoResolver.TopoMgrTopoHandle topoMgrHandle;
    private final TopoTopoResolver topoResolver;
    private final InternalLoginManager loginMgr;
    private final String storeName;
    private final TokenVerifier tokenVerifier;
    private final Logger logger;
    private final UserVerifier userVerifier;
    private KVSessionManager kvSessionManager;

    public RepNodeSecurity(RepNodeService rnService, Logger logger) {
        this.repNodeService = rnService;
        this.logger = logger;
        RepNodeService.Params params = rnService.getParams();
        SecurityParams secParams = params.getSecurityParams();
        this.storeName = params.getGlobalParams().getKVStoreName();
        this.kvSessionManager = null;
        if (secParams.isSecure()) {
            this.userVerifier = new RepNodeUserVerifier();
            StorageNodeParams snParams = params.getStorageNodeParams();
            String hostname = snParams.getHostname();
            int registryPort = snParams.getRegistryPort();
            this.topoMgrHandle = new TopoTopoResolver.TopoMgrTopoHandle(null);
            TopologyResolver.SNInfo localSNInfo = new TopologyResolver.SNInfo(hostname, registryPort, rnService.getStorageNodeId());
            this.topoResolver = new TopoTopoResolver(this.topoMgrHandle, localSNInfo, logger);
            this.loginMgr = new InternalLoginManager(this.topoResolver);
            this.tokenResolver = new TokenResolverImpl(hostname, registryPort, this.storeName, this.topoResolver, this.loginMgr, logger);
            RepNodeParams rp = rnService.getRepNodeParams();
            int tokenCacheCapacity = rp.getLoginCacheSize();
            GlobalParams gp = rnService.getParams().getGlobalParams();
            long tokenCacheEntryLifetime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
            TokenVerifier.CacheConfig tokenCacheConfig = new TokenVerifier.CacheConfig(tokenCacheCapacity, tokenCacheEntryLifetime);
            this.tokenVerifier = new TokenVerifier(tokenCacheConfig, this.tokenResolver);
            this.accessChecker = new AccessCheckerImpl(this.tokenVerifier, logger);
        } else {
            this.userVerifier = null;
            this.accessChecker = null;
            this.tokenResolver = null;
            this.topoMgrHandle = null;
            this.topoResolver = null;
            this.loginMgr = null;
            this.tokenVerifier = null;
        }
    }

    void setDispatcher(RequestDispatcher dispatcher) {
        if (this.tokenResolver != null) {
            this.kvSessionManager = new KVSessionManager(dispatcher, this.repNodeService.getRepNodeParams(), this.loginMgr, this.storeName, FailoverSessionManager.PERSISTENT_PREFIX, 16, this.userVerifier, this.logger);
            this.tokenResolver.setPersistentResolver(this.kvSessionManager);
        }
    }

    void startup() {
        if (this.kvSessionManager != null) {
            this.kvSessionManager.start();
        }
    }

    public void stop() {
        if (this.kvSessionManager != null) {
            this.kvSessionManager.stop();
        }
    }

    public AccessChecker getAccessChecker() {
        return this.accessChecker;
    }

    public LoginManager getLoginManager() {
        return this.loginMgr;
    }

    public KVSessionManager getKVSessionManager() {
        return this.kvSessionManager;
    }

    public UserVerifier getUserVerifier() {
        return this.userVerifier;
    }

    void setTopologyManager(TopologyManager topoMgr) {
        if (this.topoMgrHandle != null) {
            this.topoMgrHandle.setTopoMgr(topoMgr);
        }
    }

    @Override
    public void newServiceParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        RepNodeParams rp = new RepNodeParams(map);
        int newCapacity = rp.getLoginCacheSize();
        if (this.tokenVerifier.updateLoginCacheSize(newCapacity)) {
            this.logger.info(String.format("RNSecurity: loginCacheSize has been updated to %d", newCapacity));
        }
    }

    @Override
    public void newGlobalParameters(ParameterMap map) {
        if (this.tokenVerifier == null) {
            return;
        }
        GlobalParams gp = new GlobalParams(map);
        long newLifeTime = gp.getLoginCacheTimeoutUnit().toMillis(gp.getLoginCacheTimeout());
        if (this.tokenVerifier.updateLoginCacheTimeout(newLifeTime)) {
            this.logger.info(String.format("RNecurity: loginCacheTimeout has been updated to %d ms", newLifeTime));
        }
    }

    private class RepNodeUserVerifier
    implements UserVerifier {
        private RepNodeUserVerifier() {
        }

        @Override
        public Subject verifyUser(LoginCredentials creds) {
            SecurityMetadata secMd = RepNodeSecurity.this.repNodeService.getSecurityMetadata();
            if (secMd == null) {
                RepNodeSecurity.this.logger.info("Unable to verify user credentials with no security metadata available");
                return null;
            }
            KVStoreUser user = secMd.getUser(creds.getUsername());
            if (user == null) {
                RepNodeSecurity.this.logger.info("User password credentials are not valid");
                return null;
            }
            if (creds instanceof PasswordCredentials) {
                PasswordCredentials pwCreds = (PasswordCredentials)creds;
                if (!user.verifyPassword(pwCreds.getPassword())) {
                    RepNodeSecurity.this.logger.info("User password credentials are not valid");
                    return null;
                }
            } else if (!(creds instanceof ProxyCredentials)) {
                RepNodeSecurity.this.logger.info("Encountered unsupported login credentials of type " + creds.getClass());
                return null;
            }
            return user.makeKVSubject();
        }

        @Override
        public Subject verifyUser(Subject subj) {
            KVStoreUserPrincipal userPrinc = ExecutionContext.getSubjectUserPrincipal(subj);
            if (userPrinc == null) {
                return null;
            }
            SecurityMetadata secMd = RepNodeSecurity.this.repNodeService.getSecurityMetadata();
            if (secMd == null) {
                RepNodeSecurity.this.logger.info("Unable to verify user with no security metadata available");
                return null;
            }
            KVStoreUser user = secMd.getUser(userPrinc.getName());
            if (user == null || !user.isEnabled()) {
                RepNodeSecurity.this.logger.info("User " + userPrinc.getName() + " is not valid");
                return null;
            }
            return subj;
        }
    }
}

