/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicaConsistencyException;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.RestartRequiredException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeException;
import com.sleepycat.je.rep.TimeConsistencyPolicy;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.model.AnnotationModel;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.param.GlobalParams;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.api.RequestDispatcher;
import oracle.kv.impl.api.TopologyInfo;
import oracle.kv.impl.api.TopologyManager;
import oracle.kv.impl.api.rgstate.RepGroupState;
import oracle.kv.impl.api.rgstate.RepNodeState;
import oracle.kv.impl.api.table.TableChangeList;
import oracle.kv.impl.api.table.TableImpl;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.api.table.TableMetadataProxy;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.fault.RNUnavailableException;
import oracle.kv.impl.metadata.Metadata;
import oracle.kv.impl.metadata.MetadataInfo;
import oracle.kv.impl.metadata.MetadataKey;
import oracle.kv.impl.param.LoadParameters;
import oracle.kv.impl.rep.IncorrectRoutingException;
import oracle.kv.impl.rep.PartitionManager;
import oracle.kv.impl.rep.RepEnvHandleManager;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.SecurityMetadataManager;
import oracle.kv.impl.rep.admin.RepNodeAdmin;
import oracle.kv.impl.rep.masterBalance.MasterBalanceManager;
import oracle.kv.impl.rep.masterBalance.MasterBalanceManagerInterface;
import oracle.kv.impl.rep.masterBalance.MasterBalanceStateTracker;
import oracle.kv.impl.rep.migration.MigrationManager;
import oracle.kv.impl.rep.migration.PartitionMigrationStatus;
import oracle.kv.impl.rep.table.TableManager;
import oracle.kv.impl.security.login.LoginManager;
import oracle.kv.impl.security.metadata.SecurityMetadata;
import oracle.kv.impl.security.metadata.SecurityMetadataInfo;
import oracle.kv.impl.security.metadata.SecurityMetadataProxy;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;
import oracle.kv.table.Index;
import oracle.kv.table.Table;

public class RepNode
implements TopologyManager.PostUpdateListener,
TopologyManager.PreUpdateListener {
    private static final int NUM_DB_OP_RETRIES = 100;
    private static final long RETRY_TIME_MS = 500L;
    private static final String METADATA_STORE_NAME = "TopologyEntityStore";
    private RepNodeId repNodeId;
    private RepNodeService.Params params;
    private final RequestDispatcher requestDispatcher;
    private final TopologyManager topoManager;
    private final MigrationManager migrationManager;
    private MasterBalanceManagerInterface masterBalanceManager;
    private SecurityMetadataManager securityMDManager;
    private PartitionManager partitionManager;
    private TableManager tableManager;
    private RepEnvHandleManager envManager;
    private final RepNodeService repNodeService;
    private volatile boolean stopped = false;
    private Logger logger;

    public RepNode(RepNodeService.Params params, RequestDispatcher requestDispatcher, RepNodeService repNodeService) {
        this.requestDispatcher = requestDispatcher;
        this.topoManager = requestDispatcher.getTopologyManager();
        this.migrationManager = new MigrationManager(this, params);
        this.repNodeService = repNodeService;
    }

    public GlobalParams getGlobalParams() {
        return this.params.getGlobalParams();
    }

    public RepNodeParams getRepNodeParams() {
        return this.params.getRepNodeParams();
    }

    public StorageNodeParams getStorageNodeParams() {
        return this.params.getStorageNodeParams();
    }

    public LoadParameters getAllParams() {
        LoadParameters ret = new LoadParameters();
        ret.addMap(this.params.getGlobalParams().getMap());
        ret.addMap(this.params.getStorageNodeParams().getMap());
        ret.addMap(this.params.getRepNodeParams().getMap());
        return ret;
    }

    public Thread.UncaughtExceptionHandler getExceptionHandler() {
        return this.requestDispatcher.getExceptionHandler();
    }

    public MasterBalanceStateTracker getBalanceStateTracker() {
        return this.masterBalanceManager.getStateTracker();
    }

    public void initialize(RepNodeService.Params params1, RepEnvHandleManager.StateChangeListenerFactory listenerFactory) {
        this.params = params1;
        this.logger = LoggerUtils.getLogger(this.getClass(), this.params);
        RepNodeParams repNodeParams = this.params.getRepNodeParams();
        this.repNodeId = repNodeParams.getRepNodeId();
        if (this.masterBalanceManager == null) {
            this.masterBalanceManager = MasterBalanceManager.create(this, this.logger);
        }
        this.masterBalanceManager.initialize();
        this.envManager = new RepEnvHandleManager(this, listenerFactory, this.params, this.repNodeService);
        if (this.tableManager == null) {
            this.tableManager = new TableManager(this, this.params);
        }
        if (this.securityMDManager == null) {
            this.securityMDManager = new SecurityMetadataManager(this, this.params.getGlobalParams().getKVStoreName(), this.logger);
        }
        if (this.partitionManager == null) {
            this.partitionManager = new PartitionManager(this, this.tableManager, this.params);
        }
        this.topoManager.setLocalizer(this.migrationManager);
        this.topoManager.addPreUpdateListener(this);
        this.topoManager.addPostUpdateListener(this);
    }

    public DatabaseConfig getPartitionDbConfig() {
        assert (this.partitionManager != null);
        return this.partitionManager.getPartitionDbConfig();
    }

    void updateDbHandles(ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
        Topology topology = this.topoManager.getLocalTopology();
        if (topology == null) {
            return;
        }
        if (!reuseExistingHandles) {
            this.migrationManager.updateDbHandles(repEnv);
        }
        this.securityMDManager.updateDbHandles(repEnv, reuseExistingHandles);
        this.partitionManager.updateDbHandles(topology, repEnv, reuseExistingHandles);
        this.tableManager.updateDbHandles(repEnv, reuseExistingHandles);
    }

    @Override
    public void preUpdate(Topology newTopology) {
        ReplicatedEnvironment env = this.envManager.getEnv(0L);
        try {
            if (env == null || !env.getState().isMaster()) {
                return;
            }
        }
        catch (EnvironmentFailureException e) {
            return;
        }
        catch (IllegalStateException iae) {
            return;
        }
        try {
            this.requestDispatcher.getTopologyManager().checkPartitionChanges(new RepGroupId(this.repNodeId.getGroupId()), newTopology);
        }
        catch (IllegalStateException ise) {
            this.getExceptionHandler().uncaughtException(Thread.currentThread(), ise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean postUpdate(Topology newTopology) {
        ReplicatedEnvironment env = this.envManager.getEnv(1L);
        if (env == null) {
            throw new OperationFaultException("Could not obtain env handle");
        }
        int attempts = 100;
        StateChangeException lastException = null;
        while (!this.stopped) {
            block16: {
                boolean bl;
                block15: {
                    if (!env.isValid()) {
                        throw new OperationFaultException("Failed in persistence of " + (Object)((Object)newTopology.getType()) + " metadata, environment not valid");
                    }
                    this.updateDbHandles(env, true);
                    EntityStore estore = null;
                    try {
                        estore = this.getMetadataStore(env, true);
                        newTopology.persist(estore, null);
                        boolean flushSync = !TestStatus.isWriteNoSyncAllowed();
                        env.flushLog(flushSync);
                        this.logger.info("Topology stored seq#: " + newTopology.getSequenceNumber());
                        bl = false;
                        if (estore == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (estore != null) {
                                TxnUtil.close(this.logger, env, estore, "topology");
                            }
                            throw throwable;
                        }
                        catch (ReplicaWriteException rwe) {
                            lastException = rwe;
                            break block16;
                        }
                        catch (UnknownMasterException ume) {
                            lastException = ume;
                            break block16;
                        }
                        catch (RuntimeException rte) {
                            if (!env.isValid()) {
                                this.logger.info("Encountered failed env during topo update. " + rte.getMessage());
                                throw new OperationFaultException("Failed topology update", rte);
                            }
                            throw rte;
                        }
                    }
                    TxnUtil.close(this.logger, env, estore, "topology");
                }
                return bl;
            }
            if (--attempts == 0) {
                throw new OperationFaultException("Failed in persistence of " + (Object)((Object)newTopology.getType()) + " metadata, operation timed out", lastException);
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
        return false;
    }

    private int updateTopology(TopologyInfo topoInfo) {
        if (topoInfo.isEmpty()) {
            this.logger.warning("Empty change list sent for topology update");
            return this.getTopoSequenceNumber();
        }
        int topoSeqNum = this.getTopoSequenceNumber();
        if (topoInfo.getChanges().get(0).getSequenceNumber() > topoSeqNum + 1) {
            this.logger.info("Ignoring topo update request. Topo seq num: " + topoSeqNum + " first change: " + topoInfo.getChanges().get(0).getSequenceNumber());
            return topoSeqNum;
        }
        this.topoManager.update(topoInfo);
        return this.getTopoSequenceNumber();
    }

    private int getTopoSequenceNumber() {
        Topology topology = this.getTopology();
        return topology != null ? topology.getSequenceNumber() : 0;
    }

    public boolean updateLocalTopology() {
        if (this.topoManager.updateLocalTopology()) {
            return true;
        }
        this.logger.log(Level.FINE, "Sending NOP to update topology");
        return this.sendNOP(new RepGroupId(this.repNodeId.getGroupId()));
    }

    public SecurityMetadataManager getSecurityMDManager() {
        return this.securityMDManager;
    }

    public TableManager getTableManager() {
        return this.tableManager;
    }

    public boolean sendNOP(RepGroupId groupId) {
        RepGroupState rgs = this.requestDispatcher.getRepGroupStateTable().getGroupState(groupId);
        LoginManager lm = this.repNodeService.getRepNodeSecurity().getLoginManager();
        RepNodeState rns = rgs.getMaster();
        if (rns == null) {
            rns = rgs.getRandomRN(null, null);
        }
        this.logger.log(Level.FINE, "Sending NOP to {0}", rns.getRepNodeId());
        try {
            if (this.requestDispatcher.executeNOP(rns, 1000, lm) != null) {
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.WARNING, "Exception sending NOP to " + rns.getRepNodeId(), ex);
        }
        return false;
    }

    public RepNodeState getMaster(RepGroupId groupId) {
        return this.requestDispatcher.getRepGroupStateTable().getGroupState(groupId).getMaster();
    }

    public void asyncEnvRestart(ReplicatedEnvironment prevRepEnv, RestartRequiredException rbe) {
        this.envManager.asyncRenewRepEnv(prevRepEnv, rbe);
    }

    public void noteStateChange(ReplicatedEnvironment repEnv, StateChangeEvent stateChangeEvent) {
        if (this.stopped) {
            return;
        }
        this.envManager.noteStateChange(repEnv, stateChangeEvent);
        this.migrationManager.noteStateChange(stateChangeEvent);
        this.tableManager.noteStateChange(stateChangeEvent);
        this.masterBalanceManager.noteStateChange(stateChangeEvent);
    }

    public ReplicatedEnvironment getEnv(long timeoutMs) {
        return this.envManager.getEnv(timeoutMs);
    }

    public RepImpl getEnvImpl(long timeoutMs) {
        ReplicatedEnvironment env = this.getEnv(timeoutMs);
        return env != null ? RepInternal.getRepImpl(env) : null;
    }

    RepEnvHandleManager getRepEnvManager() {
        return this.envManager;
    }

    public void stop(boolean force) {
        if (this.stopped) {
            this.logger.info("RepNode already stopped.");
            return;
        }
        this.stopped = true;
        this.logger.info("Shutting down RepNode" + (force ? "(force)" : ""));
        this.migrationManager.shutdown(force);
        this.tableManager.shutdown();
        this.closeDbHandles(force);
        if (this.envManager != null) {
            if (force) {
                EnvironmentImpl envImpl;
                ReplicatedEnvironment env = this.envManager.getEnv(1L);
                if (env != null && (envImpl = DbInternal.getEnvironmentImpl(env)) != null) {
                    try {
                        envImpl.close(false);
                    }
                    catch (DatabaseException e) {
                        this.logger.log(Level.INFO, "Ignoring exception during forced close:", e);
                    }
                }
            } else {
                this.envManager.closeEnv();
            }
        }
        this.masterBalanceManager.shutdown();
    }

    void closeDbHandles(boolean force) {
        this.migrationManager.closeDbHandles(force);
        this.tableManager.closeDbHandles();
        this.partitionManager.closeDbHandles();
        this.securityMDManager.closeDbHandles();
    }

    public Set<PartitionId> getPartitions() {
        return this.partitionManager.getPartitions();
    }

    public PartitionId getPartitionId(byte[] keyBytes) {
        return this.partitionManager.getPartitionId(keyBytes);
    }

    public Database getPartitionDB(byte[] keyBytes) {
        return this.partitionManager.getPartitionDB(keyBytes);
    }

    public Database getPartitionDB(PartitionId partitionId) throws IncorrectRoutingException {
        String message;
        Database partitionDb = this.partitionManager.getPartitionDB(partitionId);
        if (partitionDb != null) {
            return partitionDb;
        }
        Topology topology = this.getLocalTopology();
        if (topology == null) {
            message = "Partition: " + partitionId + " not present at RepNode " + this.repNodeId;
        } else if (((Partition)topology.getPartitionMap().get(partitionId)).getRepGroupId().getGroupId() == this.repNodeId.getGroupId()) {
            message = "Partition: " + partitionId + " missing from RepNode " + this.repNodeId + ", topology seq#: " + topology.getSequenceNumber();
            this.logger.log(Level.FINE, message);
            this.partitionManager.updateDbHandles(topology);
        } else {
            message = "Partition: " + partitionId + " not present at RepNode " + this.repNodeId + ", topology seq#: " + topology.getSequenceNumber();
        }
        throw new IncorrectRoutingException(message, partitionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplicatedEnvironment startup() {
        boolean created = this.envManager.renewRepEnv(null, null);
        assert (created);
        ReplicatedEnvironment env = this.envManager.getEnv(1L);
        if (env == null) {
            throw new IllegalStateException("Could not obtain environment handle without waiting.");
        }
        try (EntityStore estore = null;){
            estore = this.getMetadataStore(env, false);
            Topology topo = Topology.fetch(estore, null);
            if (topo == null) {
                this.logger.info("Store did not contain a topology");
            } else if (this.topoManager.update(topo)) {
                this.logger.log(Level.INFO, "Topology fetched sequence#: {0}, updated topology seq# {1}", new Object[]{topo.getSequenceNumber(), this.topoManager.getTopology().getSequenceNumber()});
            }
        }
        this.masterBalanceManager.startTracker();
        this.migrationManager.startTracker();
        this.tableManager.startTracker();
        return env;
    }

    ReplicationNetworkConfig getRepNetConfig() {
        return this.envManager.getRepNetConfig();
    }

    private EntityStore getMetadataStore(Environment env, boolean allowCreate) {
        AnnotationModel model = new AnnotationModel();
        model.registerClass(TableMetadataProxy.class);
        model.registerClass(SecurityMetadataProxy.class);
        StoreConfig stConfig = new StoreConfig();
        stConfig.setAllowCreate(allowCreate);
        stConfig.setTransactional(false);
        stConfig.setModel(model);
        stConfig.setReplicated(false);
        return new EntityStore(env, METADATA_STORE_NAME, stConfig);
    }

    public RepNodeId getRepNodeId() {
        return this.repNodeId;
    }

    public Topology getTopology() {
        return this.topoManager.getTopology();
    }

    public boolean initiateMasterTransfer(RepNodeId replicaId, int timeout, TimeUnit timeUnit) {
        return this.masterBalanceManager.initiateMasterTransfer(replicaId, timeout, timeUnit);
    }

    public MigrationManager getMigrationManager() {
        return this.migrationManager;
    }

    public RepNodeAdmin.PartitionMigrationState migratePartition(PartitionId partitionId, RepGroupId sourceRGId) {
        if (this.repNodeId.getGroupId() == sourceRGId.getGroupId()) {
            return RepNodeAdmin.PartitionMigrationState.ERROR.setCause(new IllegalArgumentException("Invalid source " + sourceRGId));
        }
        if (this.partitionManager.isPresent(partitionId)) {
            return RepNodeAdmin.PartitionMigrationState.SUCCEEDED;
        }
        return this.migrationManager.migratePartition(partitionId, sourceRGId);
    }

    public RepNodeAdmin.PartitionMigrationState getMigrationState(PartitionId partitionId) {
        if (this.partitionManager.isPresent(partitionId)) {
            return RepNodeAdmin.PartitionMigrationState.SUCCEEDED;
        }
        RepNodeAdmin.PartitionMigrationState state = this.migrationManager.getMigrationState(partitionId);
        if (state.equals((Object)RepNodeAdmin.PartitionMigrationState.ERROR) && this.partitionManager.isPresent(partitionId)) {
            return RepNodeAdmin.PartitionMigrationState.SUCCEEDED;
        }
        return state;
    }

    public RepNodeAdmin.PartitionMigrationState canCancel(PartitionId partitionId) {
        return this.migrationManager.canCancel(partitionId);
    }

    public boolean canceled(PartitionId partitionId, RepGroupId targetRGId) {
        return this.migrationManager.canceled(partitionId, targetRGId);
    }

    public PartitionMigrationStatus[] getMigrationStatus() {
        return this.migrationManager.getStatus();
    }

    public boolean awaitConsistency(long targetTime, int timeout, TimeUnit timeoutUnit) {
        long timeoutMs = TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
        ReplicatedEnvironment env = this.envManager.getEnv(timeoutMs);
        if (env == null) {
            return false;
        }
        TransactionConfig txnConfig = new TransactionConfig();
        TimeConsistencyPolicy reachedTime = new TimeConsistencyPolicy(System.currentTimeMillis() - targetTime, TimeUnit.MILLISECONDS, timeout, timeoutUnit);
        txnConfig.setConsistencyPolicy(reachedTime);
        try {
            Transaction txn = env.beginTransaction(null, txnConfig);
            TxnUtil.abort(txn);
        }
        catch (ReplicaConsistencyException notReady) {
            this.logger.info(notReady.toString());
            return false;
        }
        return true;
    }

    public PartitionMigrationStatus getMigrationStatus(PartitionId partitionId) {
        return this.migrationManager.getStatus(partitionId);
    }

    Topology getLocalTopology() {
        return this.topoManager.getLocalTopology();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void versionChange(Environment env, KVVersion localVersion) {
        try (EntityStore estore = null;){
            estore = this.getMetadataStore(env, false);
            Topology topo = Topology.fetch(estore, null);
            if (topo == null) {
                return;
            }
            if (topo.upgrade()) {
                topo.persist(estore, null);
            } else {
                TopologyManager.checkVersion(this.logger, topo);
            }
        }
    }

    public Integer getMetadataSeqNum(Metadata.MetadataType type) {
        Metadata<?> md = this.getMetadata(type);
        return md == null ? 0 : md.getSequenceNumber();
    }

    public Metadata<?> getMetadata(Metadata.MetadataType type) {
        switch (type) {
            case TOPOLOGY: {
                return this.getTopology();
            }
            case TABLE: {
                return this.tableManager.getTableMetadata();
            }
            case SECURITY: {
                return this.securityMDManager.getSecurityMetadata();
            }
        }
        throw new IllegalArgumentException("Unknown metadata type: " + (Object)((Object)type));
    }

    public MetadataInfo getMetadata(Metadata.MetadataType type, int seqNum) {
        switch (type) {
            case TOPOLOGY: {
                Topology topo = this.getTopology();
                return topo == null ? TopologyInfo.EMPTY_TOPO_INFO : this.getTopology().getChangeInfo(seqNum);
            }
            case TABLE: {
                TableMetadata md = this.tableManager.getTableMetadata();
                return md == null ? TableChangeList.EMPTY_TABLE_INFO : md.getChangeInfo(seqNum);
            }
            case SECURITY: {
                SecurityMetadata securityMD = this.securityMDManager.getSecurityMetadata();
                return securityMD == null ? SecurityMetadataInfo.EMPTY_SECURITYMD_INFO : securityMD.getChangeInfo(seqNum);
            }
        }
        throw new IllegalArgumentException("Unknown metadata type: " + (Object)((Object)type));
    }

    public MetadataInfo getMetadata(Metadata.MetadataType type, MetadataKey key, int seqNum) {
        switch (type) {
            case TOPOLOGY: {
                throw new UnsupportedOperationException("Operation not supported for metadata type: " + (Object)((Object)type));
            }
            case SECURITY: {
                throw new UnsupportedOperationException("Operation not supported for metadata type: " + (Object)((Object)type));
            }
            case TABLE: {
                TableMetadata md = this.tableManager.getTableMetadata();
                if (md == null) {
                    return null;
                }
                return md.getTable((TableMetadata.TableMetadataKey)key);
            }
        }
        throw new IllegalArgumentException("Unknown metadata type: " + (Object)((Object)type));
    }

    public boolean updateMetadata(Metadata<?> newMetadata) {
        switch (newMetadata.getType()) {
            case TOPOLOGY: {
                return this.topoManager.update((Topology)newMetadata);
            }
            case TABLE: {
                return this.tableManager.updateMetadata(newMetadata);
            }
            case SECURITY: {
                return this.securityMDManager.update((SecurityMetadata)newMetadata);
            }
        }
        throw new IllegalArgumentException("Unknown metadata: " + newMetadata);
    }

    public int updateMetadata(MetadataInfo metadataInfo) {
        switch (metadataInfo.getType()) {
            case TOPOLOGY: {
                return this.updateTopology((TopologyInfo)metadataInfo);
            }
            case TABLE: {
                return this.tableManager.updateMetadata(metadataInfo);
            }
            case SECURITY: {
                return this.securityMDManager.update((SecurityMetadataInfo)metadataInfo);
            }
        }
        throw new IllegalArgumentException("Unknown metadata: " + metadataInfo);
    }

    public boolean addIndexComplete(String indexId, String tableName) {
        return this.tableManager.addIndexComplete(indexId, tableName);
    }

    public boolean removeTableDataComplete(String tableName) {
        return this.tableManager.removeTableDataComplete(tableName);
    }

    public SecondaryDatabase getIndexDB(String indexName, String tableName) {
        SecondaryDatabase db = this.tableManager.getIndexDB(indexName, tableName);
        if (db != null) {
            return db;
        }
        TableMetadata md = this.tableManager.getTableMetadata();
        String message = md == null ? "Table metadata not yet initialized" : (this.getIndex(indexName, tableName) == null ? "Index " + indexName + " not present on RepNode, table " + "metadata seq#: " + md.getSequenceNumber() : "Secondary database for " + indexName + " not yet " + "initialized");
        throw new RNUnavailableException(message);
    }

    public LoginManager getLoginManager() {
        return this.repNodeService == null ? null : this.repNodeService.getLoginManager();
    }

    public Table getTable(long tableId) {
        return this.tableManager.getTable(tableId);
    }

    public Index getIndex(String indexName, String tableName) {
        TableImpl table;
        TableMetadata md = this.tableManager.getTableMetadata();
        if (md != null && (table = md.getTable(tableName)) != null) {
            return table.getIndex(indexName);
        }
        return null;
    }
}

