/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.RecoveryProgress;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.rep.StateChangeListener;
import com.sleepycat.je.rep.UnknownMasterException;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.utilint.StoppableThread;
import java.io.File;
import java.util.Date;
import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.param.ParameterListener;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.param.ParameterUtils;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.rep.VersionManager;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.test.TestStatus;
import oracle.kv.impl.util.FileNames;
import oracle.kv.impl.util.server.JENotifyHooks;
import oracle.kv.impl.util.server.LoggerUtils;

public class RepEnvHandleManager
implements ParameterListener {
    public static volatile TestHook<RecoveryProgress> recoveryProgressTestHook;
    private final RepNode repNode;
    private final RepNodeService.Params repServiceParams;
    private final RepNodeService repNodeService;
    private final File envDir;
    private final File snapshotDir;
    private final EnvironmentConfig envConfig;
    private final ReplicationConfig renvConfig;
    private final VersionManager versionManager;
    private final StateChangeListenerFactory listenerFactory;
    private final Semaphore renewRepEnvSemaphore = new Semaphore(1);
    private final ReentrantReadWriteLock envLock;
    private ReplicatedEnvironment repEnv;
    private final Logger logger;

    public RepEnvHandleManager(RepNode repNode, StateChangeListenerFactory listenerFactory, RepNodeService.Params params, RepNodeService repNodeService) {
        assert (listenerFactory != null);
        this.repNode = repNode;
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.repServiceParams = params;
        ParameterUtils pu = new ParameterUtils(repNode.getRepNodeParams().getMap());
        this.envConfig = pu.getEnvConfig();
        this.envConfig.setCacheMode(CacheMode.EVICT_LN);
        this.renvConfig = pu.getRNRepEnvConfig();
        this.logger.info("JVM Runtime maxMemory (bytes): " + Runtime.getRuntime().maxMemory());
        this.logger.info("Non-default JE properties for environment: " + pu.createProperties(false, false));
        this.renvConfig.setGroupName(repNode.getRepNodeId().getGroupName());
        this.renvConfig.setNodeName(repNode.getRepNodeId().getFullName());
        this.renvConfig.setNodeType(repNode.getRepNodeParams().getNodeType());
        if (TestStatus.isActive()) {
            this.renvConfig.setConfigParam(RepParams.SO_REUSEADDR.getName(), "true");
            this.renvConfig.setConfigParam(RepParams.SO_BIND_WAIT_MS.getName(), "120000");
        }
        if (params.getSecurityParams() != null) {
            Properties haProps = params.getSecurityParams().getJEHAProperties();
            this.logger.info("DataChannelFactory: " + haProps.getProperty("je.rep.channelType"));
            this.renvConfig.setRepNetConfig(ReplicationNetworkConfig.create(haProps));
        }
        StorageNodeParams snParams = params.getStorageNodeParams();
        this.envDir = FileNames.getEnvDir(snParams.getRootDirPath(), params.getGlobalParams().getKVStoreName(), repNode.getRepNodeParams().getMountPoint(), snParams.getStorageNodeId(), repNode.getRepNodeId());
        this.snapshotDir = FileNames.getSnapshotDir(snParams.getRootDirPath(), params.getGlobalParams().getKVStoreName(), repNode.getRepNodeParams().getMountPoint(), snParams.getStorageNodeId(), repNode.getRepNodeId());
        this.listenerFactory = listenerFactory;
        this.envLock = new ReentrantReadWriteLock();
        if (FileNames.makeDir(this.envDir)) {
            this.logger.info("Created new environment dir: " + this.envDir);
        }
        this.versionManager = new VersionManager(this.logger, repNode);
        this.repNodeService = repNodeService;
    }

    public void updateRNPartitions(int rnPartitions) {
        int configHandles = Integer.parseInt(this.renvConfig.getConfigParam(RepParams.REPLAY_MAX_OPEN_DB_HANDLES.getName()));
        int maxOpenHandles = Math.max(configHandles, rnPartitions + 1);
        this.renvConfig.setConfigParam(RepParams.REPLAY_MAX_OPEN_DB_HANDLES.getName(), Integer.toString(maxOpenHandles));
        ReplicatedEnvironment configEnv = this.getEnv(1L);
        if (configEnv == null || !configEnv.isValid()) {
            return;
        }
        try {
            int actualHandles = Integer.parseInt(configEnv.getMutableConfig().getConfigParam(RepParams.REPLAY_MAX_OPEN_DB_HANDLES.getName()));
            if (actualHandles != maxOpenHandles) {
                configEnv.setRepMutableConfig(this.renvConfig);
                this.logger.info("Hosted partitions: " + rnPartitions + ". Dynamically changed replay handles from: " + actualHandles + " to: " + maxOpenHandles);
            }
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (EnvironmentFailureException ife) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplicatedEnvironment getEnv(long timeoutMs) {
        boolean lockAcquired;
        if (timeoutMs == 0L) {
            return this.repEnv;
        }
        try {
            lockAcquired = this.envLock.readLock().tryLock(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Unexpected interrupt", e);
        }
        if (!lockAcquired) {
            return null;
        }
        try {
            ReplicatedEnvironment replicatedEnvironment = this.repEnv;
            return replicatedEnvironment;
        }
        finally {
            this.envLock.readLock().unlock();
        }
    }

    public void noteStateChange(ReplicatedEnvironment env, StateChangeEvent stateChangeEvent) {
        if (!stateChangeEvent.getState().isDetached()) {
            return;
        }
        EnvironmentImpl envImpl = DbInternal.getEnvironmentImpl(env);
        if (envImpl == null) {
            this.logger.info("Node in detached state. No associated environment impl.");
            return;
        }
        try {
            envImpl.checkIfInvalid();
            this.logger.info("Node in detached state; handle is currently valid.");
        }
        catch (RollbackException rbe) {
            this.logger.info("Node in detached state. Handled being re-established.");
            this.asyncRenewRepEnv(env, rbe);
        }
        catch (InsufficientLogException ile) {
            this.asyncRenewRepEnv(env, ile);
        }
        catch (DatabaseException dbe) {
            this.logger.info("Exiting process.  Node in detached state, environment invalid. Exception class: " + dbe.getClass().getName() + " Exception message: " + dbe.getMessage());
            this.repNodeService.getFaultHandler().queueShutdown(dbe, ProcessExitCode.RESTART);
        }
    }

    void asyncRenewRepEnv(ReplicatedEnvironment prevRepEnv, DatabaseException restartException) {
        new AsyncRenewRepEnv(prevRepEnv, restartException).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean renewRepEnv(ReplicatedEnvironment prevRepEnv, DatabaseException restartException) {
        assert (prevRepEnv == null && restartException == null || prevRepEnv != null && restartException != null);
        assert (restartException == null || this.isRenewable(restartException));
        if (!this.renewRepEnvSemaphore.tryAcquire()) {
            return false;
        }
        try {
            this.envLock.writeLock().lockInterruptibly();
        }
        catch (InterruptedException ie) {
            this.renewRepEnvSemaphore.release();
            return false;
        }
        try {
            if (this.repEnv != null && this.repEnv != prevRepEnv) {
                boolean bl = true;
                return bl;
            }
            if (prevRepEnv != null) {
                this.cleanupPrevEnv(prevRepEnv, restartException);
            }
            this.repEnv = this.openEnv();
            if (prevRepEnv == null) {
                this.versionManager.checkCompatibility(this.repEnv);
            }
            this.repEnv.setStateChangeListener(this.listenerFactory.create(this.repEnv));
            this.repNode.updateDbHandles(this.repEnv, false);
            this.logger.info("Replicated environment handle " + (prevRepEnv == null ? "" : "re-") + "established." + " Cache size: " + this.repEnv.getConfig().getCacheSize() + ", State: " + (Object)((Object)this.repEnv.getState()));
            boolean bl = true;
            return bl;
        }
        finally {
            this.envLock.writeLock().unlock();
            this.renewRepEnvSemaphore.release();
        }
    }

    private boolean isRenewable(DatabaseException exception) {
        return exception instanceof InsufficientLogException || exception instanceof RollbackException;
    }

    private void cleanupPrevEnv(ReplicatedEnvironment prevRepEnv, DatabaseException restartException) {
        if (restartException instanceof InsufficientLogException) {
            this.networkRestore((InsufficientLogException)restartException);
        } else {
            this.logger.log(Level.INFO, "Closing environment handle in response to exception", restartException);
        }
        this.repNode.closeDbHandles(false);
        try {
            prevRepEnv.close();
        }
        catch (DatabaseException e) {
            this.logger.log(Level.INFO, "Exception closing environment", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeEnv() {
        this.envLock.writeLock().lock();
        try {
            if (this.repEnv != null) {
                try {
                    this.repEnv.close();
                }
                catch (IllegalStateException ise) {
                    this.logger.info("IllegalStateException during env close. " + ise.getMessage());
                }
                catch (EnvironmentFailureException efe) {
                    this.logger.info("Environment failure during close. " + efe.getMessage());
                }
            }
        }
        finally {
            this.envLock.writeLock().unlock();
        }
    }

    ReplicationNetworkConfig getRepNetConfig() {
        return this.renvConfig.getRepNetConfig();
    }

    private ReplicatedEnvironment openEnv() {
        boolean networkRestoreDone = false;
        this.envConfig.setLoggingHandler(new RepEnvRedirectHandler(this.repServiceParams));
        this.envConfig.setRecoveryProgressListener(new RepEnvRecoveryListener(this.repServiceParams));
        this.renvConfig.setSyncupProgressListener(new RepEnvSyncupListener(this.repServiceParams));
        this.renvConfig.setLogFileRewriteListener(new RepEnvLogRewriteListener(this.snapshotDir, this.repServiceParams));
        while (true) {
            try {
                ReplicatedEnvironment renv = new ReplicatedEnvironment(this.envDir, this.renvConfig, this.envConfig, NoConsistencyRequiredPolicy.NO_CONSISTENCY, QuorumPolicy.SIMPLE_MAJORITY);
                this.logger.info(String.format("Opened JE environment: " + JEVersion.CURRENT_VERSION.getVersionString() + " JVM max heap: %,d JE properties: %s", Runtime.getRuntime().maxMemory(), renv.getConfig()));
                return renv;
            }
            catch (UnknownMasterException unknownMaster) {
                throw unknownMaster;
            }
            catch (InsufficientLogException ile) {
                if (networkRestoreDone) {
                    throw ile;
                }
                this.networkRestore(ile);
                continue;
            }
            catch (RollbackException rbe) {
                Long time = rbe.getEarliestTransactionCommitTime();
                this.logger.info("Rollback exception retrying: " + rbe.getMessage() + (time == null ? "" : " Rolling back to: " + new Date(time)));
                continue;
            }
            break;
        }
    }

    private void networkRestore(InsufficientLogException ile) {
        NetworkRestore networkRestore = new NetworkRestore();
        NetworkRestoreConfig config = new NetworkRestoreConfig();
        config.setLogProviders(null);
        boolean nrConfigRetainLogFiles = this.repNode.getRepNodeParams().getNRConfigRetainLogFiles();
        config.setRetainLogFiles(nrConfigRetainLogFiles);
        networkRestore.execute(ile, config);
    }

    @Override
    public void newParameters(ParameterMap oldMap, ParameterMap newMap) {
        long newSize;
        ReplicatedEnvironment env = this.getEnv(1L);
        if (env == null || !env.isValid()) {
            return;
        }
        EnvironmentMutableConfig mutableConfig = env.getMutableConfig();
        long oldSize = mutableConfig.getCacheSize();
        if (oldSize != (newSize = newMap.getOrZeroLong("cacheSize"))) {
            mutableConfig.setCacheSize(newSize);
            env.setMutableConfig(mutableConfig);
        }
    }

    private class AsyncRenewRepEnv
    extends StoppableThread {
        final ReplicatedEnvironment environment;
        final DatabaseException exception;

        @Override
        public void run() {
            RepEnvHandleManager.this.renewRepEnv(this.environment, this.exception);
        }

        @Override
        protected Logger getLogger() {
            return RepEnvHandleManager.this.logger;
        }

        AsyncRenewRepEnv(ReplicatedEnvironment environment, DatabaseException exception) {
            super("AsncRenewRepEnvThread");
            if (!RepEnvHandleManager.this.isRenewable(exception)) {
                throw new IllegalArgumentException("Unexpected exception: " + exception);
            }
            this.environment = environment;
            this.exception = exception;
        }
    }

    public static interface StateChangeListenerFactory {
        public StateChangeListener create(ReplicatedEnvironment var1);
    }

    private static class RepEnvLogRewriteListener
    extends JENotifyHooks.LogRewriteListener {
        RepEnvLogRewriteListener(File snapshotDir, RepNodeService.Params repServiceParams) {
            super(snapshotDir, LoggerUtils.getLogger(RepEnvLogRewriteListener.class, repServiceParams));
        }
    }

    private static class RepEnvSyncupListener
    extends JENotifyHooks.SyncupListener {
        RepEnvSyncupListener(RepNodeService.Params repServiceParams) {
            super(LoggerUtils.getLogger(RepEnvSyncupListener.class, repServiceParams));
        }
    }

    private static class RepEnvRecoveryListener
    extends JENotifyHooks.RecoveryListener {
        RepEnvRecoveryListener(RepNodeService.Params repServiceParams) {
            super(LoggerUtils.getLogger(RepEnvRecoveryListener.class, repServiceParams));
        }

        @Override
        public boolean progress(RecoveryProgress phase, long n, long total) {
            assert (TestHookExecute.doHookIfSet(recoveryProgressTestHook, phase));
            return super.progress(phase, n, total);
        }
    }

    private static class RepEnvRedirectHandler
    extends JENotifyHooks.RedirectHandler {
        RepEnvRedirectHandler(RepNodeService.Params repServiceParams) {
            super(LoggerUtils.getLogger(RepEnvRedirectHandler.class, repServiceParams));
        }
    }
}

