/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.rep;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.SecondaryAssociation;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.ReplicaWriteException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.UnknownMasterException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.Key;
import oracle.kv.impl.map.HashKeyToPartitionMap;
import oracle.kv.impl.map.KeyToPartitionMap;
import oracle.kv.impl.rep.RepNode;
import oracle.kv.impl.rep.RepNodeService;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.PartitionId;
import oracle.kv.impl.topo.PartitionMap;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.TxnUtil;
import oracle.kv.impl.util.server.LoggerUtils;

public class PartitionManager {
    public static final int DB_OPEN_RETRY_MS = 1000;
    private final RepNode repNode;
    private final DatabaseConfig partitionDbConfig;
    private final Logger logger;
    private final Map<PartitionId, Database> partitionDbMap = new ConcurrentHashMap<PartitionId, Database>();
    private KeyToPartitionMap mapper = null;
    private UpdateThread updateThread = null;

    PartitionManager(RepNode repNode, SecondaryAssociation secondaryAssociation, RepNodeService.Params params) {
        this.repNode = repNode;
        this.partitionDbConfig = new DatabaseConfig().setTransactional(true).setAllowCreate(true).setBtreeComparator(Key.BytesComparator.class).setKeyPrefixing(true).setSecondaryAssociation(secondaryAssociation).setCacheMode(params.getRepNodeParams().getJECacheMode());
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.logger.log(Level.INFO, "Partition database cache mode: {0}", (Object)this.partitionDbConfig.getCacheMode());
    }

    DatabaseConfig getPartitionDbConfig() {
        return this.partitionDbConfig;
    }

    Set<PartitionId> getPartitions() {
        return this.partitionDbMap.keySet();
    }

    synchronized void updateDbHandles(Topology topology) {
        if (this.updateThread != null) {
            return;
        }
        ReplicatedEnvironment repEnv = this.repNode.getEnv(1L);
        if (repEnv != null) {
            this.updateDbHandles(topology, repEnv, true);
        }
    }

    synchronized void updateDbHandles(Topology topology, ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
        int nPartitions;
        assert (topology != null);
        assert (repEnv != null);
        this.stopUpdate();
        this.updateThread = new UpdateThread(topology, repEnv, reuseExistingHandles);
        this.updateThread.start();
        if (this.mapper == null && (nPartitions = topology.getPartitionMap().getNPartitions()) > 0) {
            this.mapper = new HashKeyToPartitionMap(nPartitions);
        }
    }

    private void stopUpdate() {
        assert (Thread.holdsLock(this));
        if (this.updateThread != null) {
            this.updateThread.waitForStop();
            this.updateThread = null;
        }
    }

    synchronized void closeDbHandles() {
        this.logger.log(Level.INFO, "Closing partition database handles");
        this.stopUpdate();
        for (Database pDb : this.partitionDbMap.values()) {
            if (this.closePartitionDB(pDb)) continue;
            return;
        }
    }

    private boolean closePartitionDB(Database pDb) {
        Environment env = pDb.getEnvironment();
        if (env == null || !env.isValid()) {
            return false;
        }
        TxnUtil.close(this.logger, pDb, "partition");
        return true;
    }

    PartitionId getPartitionId(byte[] keyBytes) {
        return this.mapper.getPartitionId(keyBytes);
    }

    Database getPartitionDB(byte[] keyBytes) {
        return this.partitionDbMap.get(this.mapper.getPartitionId(keyBytes));
    }

    Database getPartitionDB(PartitionId partitionId) {
        return this.partitionDbMap.get(partitionId);
    }

    boolean isPresent(PartitionId partitionId) {
        return this.partitionDbMap.containsKey(partitionId);
    }

    public static boolean handleException(RuntimeException re, Logger logger, String dbName) {
        try {
            throw re;
        }
        catch (ReplicaWriteException rwe) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, rwe.getMessage()});
            return true;
        }
        catch (UnknownMasterException ume) {
            logger.log(Level.FINE, "Failed to open database for {0}. {1}", new Object[]{dbName, ume.getMessage()});
            return true;
        }
        catch (InsufficientReplicasException ire) {
            logger.log(Level.FINE, "Insufficient replicas when creating database {0}. {1}", new Object[]{dbName, ire.getMessage()});
            return true;
        }
        catch (InsufficientAcksException iae) {
            logger.log(Level.FINE, "Insufficient acks when creating database {0}. {1}", new Object[]{dbName, iae.getMessage()});
            return false;
        }
        catch (IllegalStateException ise) {
            logger.log(Level.FINE, "Problem accessing database {0}. {1}", new Object[]{dbName, ise.getMessage()});
            return true;
        }
    }

    private class UpdateThread
    extends Thread {
        private final Topology topology;
        private final ReplicatedEnvironment repEnv;
        private final boolean reuseExistingHandles;
        private volatile boolean stop;

        UpdateThread(Topology topology, ReplicatedEnvironment repEnv, boolean reuseExistingHandles) {
            super("KV partition handle updater");
            this.stop = false;
            this.topology = topology;
            this.repEnv = repEnv;
            this.reuseExistingHandles = reuseExistingHandles;
            this.setDaemon(true);
            this.setUncaughtExceptionHandler(PartitionManager.this.repNode.getExceptionHandler());
        }

        @Override
        public void run() {
            while (this.update()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    throw new IllegalStateException(ie);
                }
            }
        }

        private boolean update() {
            PartitionMap partitionMap = this.topology.getPartitionMap();
            PartitionManager.this.logger.log(Level.FINE, "Establishing partition database handles, topology seq#: {0}", this.topology.getSequenceNumber());
            int groupId = PartitionManager.this.repNode.getRepNodeId().getGroupId();
            int errors = 0;
            int rnPartitions = 0;
            for (Partition p : partitionMap.getAll()) {
                if (this.stop || !this.repEnv.isValid()) {
                    PartitionManager.this.logger.log(Level.INFO, "Update terminated, established {0} partition database handles", PartitionManager.this.partitionDbMap.size());
                    return false;
                }
                PartitionId partitionId = (PartitionId)p.getResourceId();
                if (p.getRepGroupId().getGroupId() != groupId) {
                    PartitionManager.this.logger.log(Level.FINE, "Removing partition database handle for {0}", partitionId);
                    Database db = (Database)PartitionManager.this.partitionDbMap.remove(partitionId);
                    if (db == null) continue;
                    PartitionManager.this.logger.log(Level.INFO, "Closing database for moved {0}", partitionId);
                    PartitionManager.this.closePartitionDB(db);
                    continue;
                }
                ++rnPartitions;
                try {
                    Database currentDB = (Database)PartitionManager.this.partitionDbMap.get(partitionId);
                    if (currentDB != null && this.reuseExistingHandles) continue;
                    this.updatePartitionHandle(partitionId);
                }
                catch (RuntimeException re) {
                    if (!PartitionManager.handleException(re, PartitionManager.this.logger, partitionId.getPartitionName())) continue;
                    ++errors;
                }
            }
            PartitionManager.this.repNode.getRepEnvManager().updateRNPartitions(rnPartitions);
            if (errors > 0) {
                PartitionManager.this.logger.log(Level.INFO, "Established {0} partition database handles, will retry in {1}ms", new Object[]{PartitionManager.this.partitionDbMap.size(), 1000});
                return !this.stop;
            }
            PartitionManager.this.logger.log(Level.INFO, "Established {0} partition database handles, topology seq#: {1}", new Object[]{PartitionManager.this.partitionDbMap.size(), this.topology.getSequenceNumber()});
            return false;
        }

        private void updatePartitionHandle(PartitionId partitionId) throws ReplicaWriteException {
            TransactionConfig txnConfig = new TransactionConfig().setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
            Transaction txn = null;
            try {
                txn = this.repEnv.beginTransaction(null, txnConfig);
                Database db = this.repEnv.openDatabase(txn, partitionId.getPartitionName(), PartitionManager.this.partitionDbConfig);
                txn.commit();
                txn = null;
                PartitionManager.this.partitionDbMap.put(partitionId, db);
            }
            catch (IllegalStateException e) {
                try {
                    if (this.repEnv.isValid()) {
                        EnvironmentFailureException.unexpectedException(DbInternal.getEnvironmentImpl(this.repEnv), (Exception)e);
                    }
                    throw e;
                }
                catch (Throwable throwable) {
                    TxnUtil.abort(txn);
                    throw throwable;
                }
            }
            TxnUtil.abort(txn);
        }

        void waitForStop() {
            assert (Thread.currentThread() != this);
            this.stop = true;
            try {
                this.join();
            }
            catch (InterruptedException ie) {
                throw new IllegalStateException(ie);
            }
        }
    }
}

