/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.measurement.LoggerMessage;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.test.TestHook;
import oracle.kv.impl.test.TestHookExecute;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class StorewideLoggingView
implements View {
    private final Logger logger;
    private final Set<ViewListener<LogRecord>> listeners;
    private TestHook<LoggerMessage> testHook;
    private final String logfileName;

    public StorewideLoggingView(AdminServiceParams params) {
        this.logger = LoggerUtils.getStorewideViewLogger(this.getClass(), params);
        this.logger.setLevel(Level.ALL);
        this.listeners = new HashSet<ViewListener<LogRecord>>();
        this.logfileName = LoggerUtils.getStorewideLogName(params.getStorageNodeParams().getRootDirPath(), params.getGlobalParams().getKVStoreName());
    }

    @Override
    public String getName() {
        return "Internal_LoggingMessages";
    }

    @Override
    public Set<MeasurementType> getTargetMetricTypes() {
        return Collections.singleton(Metrics.LOG_MSG);
    }

    public synchronized void addListener(ViewListener<LogRecord> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void applyNewInfo(ResourceId resourceId, Measurement m) {
        LoggerMessage logMsg = (LoggerMessage)m;
        LogRecord record = logMsg.getLogRecord();
        if (!this.logger.isLoggable(record.getLevel())) {
            return;
        }
        record.setMessage("[" + resourceId + "] " + record.getMessage());
        this.logger.log(record);
        for (ViewListener<LogRecord> listener : this.listeners) {
            listener.newInfo(resourceId, record);
        }
        assert (TestHookExecute.doHookIfSet(this.testHook, logMsg));
    }

    public void setTestHook(TestHook<LoggerMessage> hook) {
        this.testHook = hook;
    }

    @Override
    public void close() {
        this.logger.fine("Closing StorewideLoggingView");
        for (Handler handler : this.logger.getHandlers()) {
            this.logger.removeHandler(handler);
        }
    }

    public String getStorewideLogName() {
        return this.logfileName;
    }
}

