/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.measurement.Measurement;
import oracle.kv.impl.measurement.MeasurementType;
import oracle.kv.impl.measurement.ServiceStatusChange;
import oracle.kv.impl.monitor.Metrics;
import oracle.kv.impl.monitor.View;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class ServiceStatusView
implements View {
    private final Logger logger;
    private final Set<ViewListener<ServiceStatusChange>> listeners;

    public ServiceStatusView(AdminServiceParams params) {
        this.logger = LoggerUtils.getLogger(this.getClass(), params);
        this.listeners = new HashSet<ViewListener<ServiceStatusChange>>();
    }

    @Override
    public String getName() {
        return "Internal_ServiceStateChanges";
    }

    @Override
    public Set<MeasurementType> getTargetMetricTypes() {
        return Collections.singleton(Metrics.SERVICE_STATUS);
    }

    @Override
    public synchronized void applyNewInfo(ResourceId resourceId, Measurement m) {
        ServiceStatusChange change = (ServiceStatusChange)m;
        for (ViewListener<ServiceStatusChange> listener : this.listeners) {
            listener.newInfo(resourceId, change);
        }
    }

    public synchronized void addListener(ViewListener<ServiceStatusChange> l) {
        this.logger.finest(this.getName() + " added listener " + l);
        this.listeners.add(l);
    }

    public synchronized void removeListener(ViewListener<ServiceStatusChange> l) {
        this.listeners.remove(l);
    }

    @Override
    public void close() {
    }
}

