/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import oracle.kv.impl.admin.AdminServiceParams;
import oracle.kv.impl.monitor.Tracker;
import oracle.kv.impl.monitor.ViewListener;
import oracle.kv.impl.monitor.views.PerfEvent;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.server.LoggerUtils;

public class PerfTracker
extends Tracker<PerfEvent>
implements ViewListener<PerfEvent> {
    private static final int CHUNK_SIZE = 15;
    private final Map<ResourceId, PerfEvent> resourcePerf = new ConcurrentHashMap<ResourceId, PerfEvent>();
    private final Logger perfFileLogger;
    private int headerCounter;
    private final List<Tracker.EventHolder<PerfEvent>> queue;

    public PerfTracker(AdminServiceParams params) {
        this.perfFileLogger = LoggerUtils.getPerfFileLogger(this.getClass(), params.getGlobalParams(), params.getStorageNodeParams());
        this.headerCounter = 1;
        this.queue = new ArrayList<Tracker.EventHolder<PerfEvent>>();
    }

    private void prune() {
        Tracker.EventHolder<PerfEvent> pe;
        long interesting = this.getEarliestInterestingTimeStamp();
        while (!this.queue.isEmpty() && (pe = this.queue.get(0)).getSyntheticTimestamp() <= interesting) {
            this.queue.remove(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInfo(ResourceId rId, PerfEvent p) {
        PerfTracker perfTracker = this;
        synchronized (perfTracker) {
            if (--this.headerCounter == 0) {
                this.headerCounter = 15;
                this.perfFileLogger.info(PerfEvent.HEADER);
                this.prune();
            }
            this.perfFileLogger.info(p.getColumnFormatted());
            this.resourcePerf.put(rId, p);
            long syntheticTimestamp = this.getSyntheticTimestamp(p.getChangeTime());
            this.queue.add(new Tracker.EventHolder<PerfEvent>(syntheticTimestamp, p, p.needsAlert()));
        }
        this.notifyListeners();
    }

    public Map<ResourceId, PerfEvent> getPerf() {
        return new HashMap<ResourceId, PerfEvent>(this.resourcePerf);
    }

    @Override
    public synchronized Tracker.RetrievedEvents<PerfEvent> retrieveNewEvents(long pointInTime) {
        ArrayList values = new ArrayList();
        long syntheticStampOfLastRecord = pointInTime;
        for (Tracker.EventHolder<PerfEvent> pe : this.queue) {
            if (pe.getSyntheticTimestamp() <= pointInTime) continue;
            values.add(pe);
            syntheticStampOfLastRecord = pe.getSyntheticTimestamp();
        }
        return new Tracker.RetrievedEvents<PerfEvent>(syntheticStampOfLastRecord, values);
    }
}

