/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor.views;

import com.sleepycat.je.rep.ReplicatedEnvironmentStats;
import com.sleepycat.utilint.Latency;
import java.io.Serializable;
import oracle.kv.impl.measurement.LatencyInfo;
import oracle.kv.impl.measurement.RepEnvStats;
import oracle.kv.impl.topo.ResourceId;
import oracle.kv.impl.util.FormatUtils;

public class PerfEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String eol = System.getProperty("line.separator");
    private final ResourceId resourceId;
    private final LatencyInfo singleInt;
    private final LatencyInfo singleCum;
    private final LatencyInfo multiInt;
    private final LatencyInfo multiCum;
    private final boolean needsAlert;
    private final boolean singleCeilingExceeded;
    private final boolean singleFloorExceeded;
    private final boolean multiCeilingExceeded;
    private final boolean multiFloorExceeded;
    private final long commitLag;
    private final long commitLagThreshold;
    private final boolean lagExceeded;
    public static final String HEADER = eol + "                                        --------------------------------- Interval ---------------------------------        --------------------------- Cumulative ---------------------------" + eol + "Resource   Time yy-mm-dd UTC Op Type    TotalOps PerSec    TotalReq    Min    Max    Avg   95th   99th  ReplicaLagMs        TotalOps PerSec        TotalReq    Min    Max    Avg   95th   99th";

    public PerfEvent(ResourceId resourceId, LatencyInfo singleInt, LatencyInfo singleCum, int latencyCeiling, int throughputFloor, long commitLagThreshold, LatencyInfo multiInt, LatencyInfo multiCum, RepEnvStats repEnvStats) {
        this.singleInt = singleInt;
        this.singleCum = singleCum;
        this.multiInt = multiInt;
        this.multiCum = multiCum;
        this.resourceId = resourceId;
        assert (singleInt != null);
        assert (singleCum != null);
        assert (multiInt != null);
        assert (multiCum != null);
        this.singleCeilingExceeded = PerfEvent.latencyCeilingExceeded(latencyCeiling, singleInt);
        this.singleFloorExceeded = PerfEvent.throughputFloorExceeded(throughputFloor, singleInt);
        this.multiCeilingExceeded = PerfEvent.latencyCeilingExceeded(latencyCeiling, multiInt);
        this.multiFloorExceeded = PerfEvent.throughputFloorExceeded(throughputFloor, multiInt);
        this.commitLagThreshold = commitLagThreshold;
        this.commitLag = PerfEvent.getCommitLagMs(repEnvStats);
        this.lagExceeded = PerfEvent.commitLagThresholdExceeded(this.commitLag, commitLagThreshold);
        this.needsAlert = this.singleCeilingExceeded ? true : (this.singleFloorExceeded ? true : (this.multiCeilingExceeded ? true : (this.multiFloorExceeded ? true : this.lagExceeded)));
    }

    public static boolean latencyCeilingExceeded(int ceiling, LatencyInfo stat) {
        return ceiling > 0 && stat.getLatency().getAvg() > (float)ceiling;
    }

    public static boolean throughputFloorExceeded(int floor, LatencyInfo stat) {
        return floor > 0 && stat.getThroughputPerSec() > 0L && stat.getThroughputPerSec() < (long)floor;
    }

    public static long getCommitLagMs(RepEnvStats repEnvStats) {
        ReplicatedEnvironmentStats jeRepStats;
        long avgLag = 0L;
        if (repEnvStats != null && (jeRepStats = repEnvStats.getStats()) != null) {
            long totalLag = jeRepStats.getReplayTotalCommitLagMs();
            long nCommits = jeRepStats.getNReplayCommits();
            if (totalLag > 0L && nCommits > 0L) {
                avgLag = totalLag / nCommits;
            }
        }
        return avgLag;
    }

    public static boolean commitLagThresholdExceeded(RepEnvStats repEnvStats, long threshold) {
        return PerfEvent.commitLagThresholdExceeded(PerfEvent.getCommitLagMs(repEnvStats), threshold);
    }

    public static boolean commitLagThresholdExceeded(long lag, long threshold) {
        return threshold > 0L && lag >= threshold;
    }

    public String getColumnFormatted() {
        StringBuilder sb = new StringBuilder();
        if (this.singleInt.getLatency().getTotalOps() > 0) {
            sb.append(this.getFormatted("single", this.singleInt, this.singleCum));
            if (this.singleCeilingExceeded) {
                sb.append(" - latency");
                if (this.singleFloorExceeded) {
                    sb.append(",throughput");
                }
            } else if (this.singleFloorExceeded) {
                sb.append(" - throughput");
            }
        }
        if (this.multiInt.getLatency().getTotalOps() > 0) {
            if (sb.length() > 0) {
                sb.append(eol);
            }
            sb.append(this.getFormatted("multi", this.multiInt, this.multiCum));
            if (this.multiCeilingExceeded) {
                sb.append(" - latency");
                if (this.multiFloorExceeded) {
                    sb.append(",throughput");
                }
            } else if (this.multiFloorExceeded) {
                sb.append(" - throughput");
            }
        }
        if (sb.length() > 0) {
            if (this.lagExceeded) {
                if (this.singleCeilingExceeded || this.singleFloorExceeded || this.multiCeilingExceeded || this.multiFloorExceeded) {
                    sb.append(",lag");
                } else {
                    sb.append(" - lag");
                }
            }
        } else {
            sb.append(this.getFormatted("single", this.singleInt, this.singleCum));
            if (this.lagExceeded) {
                sb.append(" - lag");
            }
        }
        return sb.toString();
    }

    private String getFormatted(String label, LatencyInfo intInfo, LatencyInfo cumInfo) {
        Latency intLat = intInfo.getLatency();
        Latency cumLat = cumInfo.getLatency();
        String formatted = String.format("%-10s %17s %7s %11d %6d %11d %6d %6d %6.1f %6d %6d %13d %15d %6d %15d %6d %6d %6.1f %6d %6d", this.resourceId, FormatUtils.formatPerfTime(intInfo.getEnd()), label, intLat.getTotalOps(), intInfo.getThroughputPerSec(), intLat.getTotalRequests(), intLat.getMin(), intLat.getMax(), Float.valueOf(intLat.getAvg()), intLat.get95thPercent(), intLat.get99thPercent(), this.commitLag, cumLat.getTotalOps(), cumInfo.getThroughputPerSec(), cumLat.getTotalRequests(), cumLat.getMin(), cumLat.getMax(), Float.valueOf(cumLat.getAvg()), cumLat.get95thPercent(), cumLat.get99thPercent());
        if (this.needsAlert) {
            formatted = formatted + " ALERT";
        }
        return formatted;
    }

    public String toString() {
        String value = this.resourceId + " interval=" + this.singleInt;
        if (this.singleCeilingExceeded || this.singleFloorExceeded) {
            value = value + " ALERT";
        }
        value = value + " replicaLagMs=" + this.commitLag;
        if (this.lagExceeded) {
            value = value + " ALERT";
        }
        value = value + " cumulative=" + this.singleCum;
        value = value + " multiOpsInterval=" + this.multiInt;
        if (this.multiCeilingExceeded || this.multiFloorExceeded) {
            value = value + " ALERT";
        }
        value = value + " multiOpsCumulative=" + this.multiCum;
        return value;
    }

    public ResourceId getResourceId() {
        return this.resourceId;
    }

    public LatencyInfo getSingleInt() {
        return this.singleInt;
    }

    public LatencyInfo getSingleCum() {
        return this.singleCum;
    }

    public LatencyInfo getMultiInt() {
        return this.multiInt;
    }

    public LatencyInfo getMultiCum() {
        return this.multiCum;
    }

    public boolean needsAlert() {
        return this.needsAlert;
    }

    public long getChangeTime() {
        if (this.singleInt.getLatency().getTotalOps() != 0) {
            return this.singleInt.getEnd();
        }
        if (this.multiInt.getLatency().getTotalOps() != 0) {
            return this.multiInt.getEnd();
        }
        if (this.lagExceeded) {
            return this.singleInt.getEnd();
        }
        return 0L;
    }

    public long getCommitLagMs() {
        return this.commitLag;
    }

    public long getCommitLagThreshold() {
        return this.commitLagThreshold;
    }
}

