/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.monitor.TrackerListener;

public abstract class Tracker<T> {
    protected long lastTimestampGiven = 0L;
    private final List<TrackerListener> listeners = new ArrayList<TrackerListener>();

    protected Tracker() {
    }

    protected List<TrackerListener> getListeners() {
        return this.listeners;
    }

    public synchronized void registerListener(TrackerListener tl) {
        this.listeners.add(tl);
    }

    public synchronized void removeListener(TrackerListener tl) {
        this.listeners.remove(tl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners() {
        ArrayList<TrackerListener> myListeners;
        Tracker tracker = this;
        synchronized (tracker) {
            myListeners = new ArrayList<TrackerListener>(this.listeners);
        }
        for (TrackerListener tl : myListeners) {
            try {
                tl.notifyOfNewEvents();
            }
            catch (RemoteException re) {
                this.listeners.remove(tl);
            }
        }
    }

    protected synchronized long getEarliestInterestingTimeStamp() {
        long interesting = this.lastTimestampGiven;
        for (TrackerListener tl : this.listeners) {
            long candidate;
            try {
                candidate = tl.getInterestingTime();
            }
            catch (RemoteException re) {
                this.listeners.remove(tl);
                continue;
            }
            if (candidate >= interesting) continue;
            interesting = candidate;
        }
        return interesting;
    }

    protected long getSyntheticTimestamp(long naturalTimestamp) {
        long syntheticTimestamp = naturalTimestamp;
        if (this.lastTimestampGiven < syntheticTimestamp) {
            this.lastTimestampGiven = syntheticTimestamp;
        } else {
            ++this.lastTimestampGiven;
            syntheticTimestamp = this.lastTimestampGiven;
        }
        return syntheticTimestamp;
    }

    public abstract RetrievedEvents<T> retrieveNewEvents(long var1);

    public static class RetrievedEvents<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long syntheticTimestampOfLastEvent;
        private List<EventHolder<T>> events;

        public RetrievedEvents(long syntheticStampOfLastEvent, List<EventHolder<T>> events) {
            this.syntheticTimestampOfLastEvent = syntheticStampOfLastEvent;
            this.events = events;
        }

        public long getLastSyntheticTimestamp() {
            return this.syntheticTimestampOfLastEvent;
        }

        public int size() {
            return this.events.size();
        }

        public List<T> getEvents() {
            ArrayList<T> values = new ArrayList<T>();
            for (EventHolder<T> se : this.events) {
                values.add(se.getEvent());
            }
            return values;
        }

        public List<EventHolder<T>> getRecordableEvents() {
            ArrayList<EventHolder<T>> values = new ArrayList<EventHolder<T>>();
            for (EventHolder<T> se : this.events) {
                if (!se.isRecordable()) continue;
                values.add(se);
            }
            return values;
        }
    }

    public static class EventHolder<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long syntheticTimestamp;
        private T event;
        boolean recordable;

        public EventHolder(long syntheticTimestamp, T event, boolean recordable) {
            this.syntheticTimestamp = syntheticTimestamp;
            this.event = event;
            this.recordable = recordable;
        }

        public long getSyntheticTimestamp() {
            return this.syntheticTimestamp;
        }

        public T getEvent() {
            return this.event;
        }

        public boolean isRecordable() {
            return this.recordable;
        }
    }
}

