/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.monitor;

import java.util.logging.Logger;
import oracle.kv.impl.fault.ClientAccessException;
import oracle.kv.impl.fault.InternalFaultException;
import oracle.kv.impl.fault.ProcessExitCode;
import oracle.kv.impl.fault.ProcessFaultHandler;

public class MonitorAgentFaultHandler
extends ProcessFaultHandler {
    public MonitorAgentFaultHandler(Logger logger) {
        super(logger, ProcessExitCode.RESTART);
    }

    @Override
    protected void queueShutdownInternal(Throwable fault, ProcessExitCode exitCode) {
    }

    @Override
    protected RuntimeException getThrowException(RuntimeException fault) {
        if (fault instanceof InternalFaultException) {
            return fault;
        }
        if (fault instanceof ClientAccessException) {
            return ((ClientAccessException)fault).getCause();
        }
        return new MonitorAgentFaultException(fault);
    }

    @Override
    public ProcessExitCode getExitCode(RuntimeException fault, ProcessExitCode exitCode) {
        if (fault instanceof InternalFaultException) {
            return null;
        }
        String msg = "Exception encountered. but process will remain active: " + fault;
        this.logger.severe(msg);
        System.err.println(msg);
        return null;
    }

    private static class MonitorAgentFaultException
    extends InternalFaultException {
        private static final long serialVersionUID = 1L;

        MonitorAgentFaultException(Throwable cause) {
            super(cause);
        }
    }
}

