/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.measurement;

import java.io.Serializable;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import oracle.kv.impl.measurement.ConciseStats;

public class JVMStats
implements ConciseStats,
Serializable {
    private static final long serialVersionUID = 1L;
    private final long start;
    private final long end;
    private final long freeMemory;
    private final long maxMemory;
    private final long totalMemory;
    private final List<CollectorInfo> collectors;

    public JVMStats(long start, long end) {
        this.start = start;
        this.end = end;
        Runtime rt = Runtime.getRuntime();
        this.freeMemory = rt.freeMemory();
        this.maxMemory = rt.maxMemory();
        this.totalMemory = rt.totalMemory();
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        this.collectors = new ArrayList<CollectorInfo>(gcBeans.size());
        for (GarbageCollectorMXBean gc : gcBeans) {
            this.collectors.add(new CollectorInfo(gc));
        }
    }

    @Override
    public long getStart() {
        return this.start;
    }

    @Override
    public long getEnd() {
        return this.end;
    }

    @Override
    public String getFormattedStats() {
        StringBuilder sb = new StringBuilder();
        sb.append("Memory");
        sb.append("\n\tfreeMemory=");
        sb.append(this.freeMemory);
        sb.append("\n\tmaxMemory=");
        sb.append(this.maxMemory);
        sb.append("\n\ttotalMemory=");
        sb.append(this.totalMemory);
        for (CollectorInfo gc : this.collectors) {
            sb.append("\n");
            sb.append(gc.name);
            sb.append("\n\tcount=");
            sb.append(gc.count);
            sb.append("\n\ttime=");
            sb.append(gc.time);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return "JVMStats[" + this.getFormattedStats() + "]";
    }

    private static class CollectorInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String name;
        private final long count;
        private final long time;

        private CollectorInfo(GarbageCollectorMXBean gc) {
            this.name = gc.getName();
            this.count = gc.getCollectionCount();
            this.time = gc.getCollectionTime();
        }
    }
}

