/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.ComplexValueImpl;
import oracle.kv.impl.api.table.FieldComparator;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.RecordValueImpl;
import oracle.kv.table.ArrayValue;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.MapDef;
import oracle.kv.table.MapValue;
import oracle.kv.table.RecordValue;
import org.apache.avro.Schema;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.node.JsonNodeFactory;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class MapValueImpl
extends ComplexValueImpl
implements MapValue {
    private static final long serialVersionUID = 1L;
    private final Map<String, FieldValue> fields;

    MapValueImpl(MapDef field) {
        super(field);
        this.fields = new TreeMap<String, FieldValue>(FieldComparator.instance);
    }

    private MapValueImpl() {
        super(null);
        this.fields = null;
    }

    @Override
    public int size() {
        return this.fields.size();
    }

    @Override
    public FieldValue remove(String fieldName) {
        return this.fields.remove(fieldName);
    }

    @Override
    public FieldValue get(String fieldName) {
        return this.fields.get(fieldName);
    }

    @Override
    public MapValue put(String name, int value) {
        this.validate(FieldDef.Type.INTEGER);
        this.fields.put(name, this.getElement().createInteger(value));
        return this;
    }

    @Override
    public MapValue put(String name, long value) {
        this.validate(FieldDef.Type.LONG);
        this.fields.put(name, this.getElement().createLong(value));
        return this;
    }

    @Override
    public MapValue put(String name, String value) {
        this.validate(FieldDef.Type.STRING);
        this.fields.put(name, this.getElement().createString(value));
        return this;
    }

    @Override
    public MapValue put(String name, double value) {
        this.validate(FieldDef.Type.DOUBLE);
        this.fields.put(name, this.getElement().createDouble(value));
        return this;
    }

    @Override
    public MapValue put(String name, float value) {
        this.validate(FieldDef.Type.FLOAT);
        this.fields.put(name, this.getElement().createFloat(value));
        return this;
    }

    @Override
    public MapValue put(String name, boolean value) {
        this.validate(FieldDef.Type.BOOLEAN);
        this.fields.put(name, this.getElement().createBoolean(value));
        return this;
    }

    @Override
    public MapValue put(String name, byte[] value) {
        this.validate(FieldDef.Type.BINARY);
        this.fields.put(name, this.getElement().createBinary(value));
        return this;
    }

    @Override
    public MapValue putFixed(String name, byte[] value) {
        this.validate(FieldDef.Type.FIXED_BINARY);
        this.fields.put(name, this.getElement().createFixedBinary(value));
        return this;
    }

    @Override
    public MapValue putEnum(String name, String value) {
        this.validate(FieldDef.Type.ENUM);
        this.fields.put(name, this.getElement().createEnum(value));
        return this;
    }

    @Override
    public MapValue put(String fieldName, FieldValue value) {
        if (!this.getElement().isType(value.getType())) {
            throw new IllegalArgumentException("Incorrect type for map");
        }
        this.fields.put(fieldName, value);
        return this;
    }

    @Override
    public RecordValueImpl putRecord(String fieldName) {
        RecordValue val = this.getElement().createRecord();
        this.fields.put(fieldName, val);
        return (RecordValueImpl)val;
    }

    @Override
    public MapValueImpl putMap(String fieldName) {
        MapValue val = this.getElement().createMap();
        this.fields.put(fieldName, val);
        return (MapValueImpl)val;
    }

    @Override
    public ArrayValueImpl putArray(String fieldName) {
        ArrayValue val = this.getElement().createArray();
        this.fields.put(fieldName, val);
        return (ArrayValueImpl)val;
    }

    @Override
    public MapDefImpl getDefinition() {
        return (MapDefImpl)super.getDefinition();
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.MAP;
    }

    @Override
    public MapValueImpl clone() {
        MapValueImpl map = new MapValueImpl((MapDef)this.field);
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            map.put(entry.getKey(), entry.getValue().clone());
        }
        return map;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public MapValue asMap() {
        return this;
    }

    public boolean equals(Object other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherValue = (MapValueImpl)other;
            if (this == otherValue) {
                return true;
            }
            if (this.size() == otherValue.size() && this.getElement().equals(otherValue.getElement()) && this.field.equals(otherValue.getDefinition())) {
                for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
                    if (entry.getValue().equals(otherValue.get(entry.getKey()))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int code = this.size();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            code += entry.getKey().hashCode() + entry.getValue().hashCode();
        }
        return code;
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof MapValueImpl) {
            MapValueImpl otherImpl = (MapValueImpl)other;
            if (!this.field.equals(otherImpl.field)) {
                throw new IllegalArgumentException("Cannot compare MapValues with different definitions");
            }
            for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
                FieldValueImpl val = (FieldValueImpl)entry.getValue();
                FieldValueImpl otherVal = (FieldValueImpl)otherImpl.get(entry.getKey());
                if (val != null) {
                    if (otherVal == null) {
                        return 1;
                    }
                    int comp = val.compareTo(otherVal);
                    if (comp == 0) continue;
                    return comp;
                }
                if (otherVal == null) continue;
                return -1;
            }
            return 0;
        }
        throw new ClassCastException("Object is not a MapValue");
    }

    @Override
    public JsonNode toJsonNode() {
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, FieldValue> entry : this.fields.entrySet()) {
            node.put(entry.getKey(), ((FieldValueImpl)entry.getValue()).toJsonNode());
        }
        return node;
    }

    @Override
    public Map<String, FieldValue> getFields() {
        return Collections.unmodifiableMap(this.fields);
    }

    Map<String, FieldValue> getFieldsInternal() {
        return this.fields;
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema valueSchema = MapValueImpl.getValueSchema(schema);
        TreeMap<String, Object> newMap = new TreeMap<String, Object>(FieldComparator.instance);
        for (Map.Entry<String, FieldValue> entry : this.getFieldsInternal().entrySet()) {
            newMap.put(entry.getKey(), ((FieldValueImpl)entry.getValue()).toAvroValue(valueSchema));
        }
        return newMap;
    }

    private static Schema getValueSchema(Schema schema) {
        return MapValueImpl.getUnionSchema(schema, Schema.Type.MAP).getValueType();
    }

    static MapValueImpl fromAvroValue(FieldDef def, Object o, Schema schema) {
        Map avroMap = (Map)o;
        MapValueImpl map = new MapValueImpl((MapDef)def);
        for (Map.Entry entry : avroMap.entrySet()) {
            String key = ((Utf8)entry.getKey()).toString();
            map.put(key, FieldValueImpl.fromAvroValue(((MapDef)def).getElement(), entry.getValue(), MapValueImpl.getValueSchema(schema)));
        }
        return map;
    }

    @Override
    void addJsonFields(JsonParser jp, boolean exact) {
        try {
            FieldDef element = this.getElement();
            while (jp.nextToken() != JsonToken.END_OBJECT) {
                String fieldname = jp.getCurrentName();
                JsonToken token = jp.nextToken();
                if (token == JsonToken.VALUE_NULL) {
                    throw new IllegalArgumentException("Invalid null value in JSON input for field " + fieldname);
                }
                switch (element.getType()) {
                    case INTEGER: {
                        this.put(fieldname, jp.getIntValue());
                        break;
                    }
                    case LONG: {
                        this.put(fieldname, jp.getLongValue());
                        break;
                    }
                    case DOUBLE: {
                        this.put(fieldname, jp.getDoubleValue());
                        break;
                    }
                    case FLOAT: {
                        this.put(fieldname, jp.getFloatValue());
                        break;
                    }
                    case STRING: {
                        this.put(fieldname, jp.getText());
                        break;
                    }
                    case BINARY: {
                        this.put(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case FIXED_BINARY: {
                        this.putFixed(fieldname, jp.getBinaryValue());
                        break;
                    }
                    case BOOLEAN: {
                        this.put(fieldname, jp.getBooleanValue());
                        break;
                    }
                    case ARRAY: {
                        ArrayValueImpl array = this.putArray(fieldname);
                        array.addJsonFields(jp, exact);
                        break;
                    }
                    case MAP: {
                        MapValueImpl map = this.putMap(fieldname);
                        map.addJsonFields(jp, exact);
                        break;
                    }
                    case RECORD: {
                        RecordValueImpl record = this.putRecord(fieldname);
                        record.addJsonFields(jp, exact);
                        break;
                    }
                    case ENUM: {
                        this.putEnum(fieldname, jp.getText());
                    }
                }
            }
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException("Failed to parse JSON input: " + ioe.getMessage(), ioe);
        }
    }

    private FieldDef getElement() {
        return this.getDefinition().getElement();
    }

    private void validate(FieldDef.Type type) {
        if (!this.getElement().isType(type)) {
            throw new IllegalArgumentException("Incorrect type for map");
        }
    }
}

