/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import java.io.IOException;
import oracle.kv.impl.api.table.CollectionBuilder;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.MapDefImpl;
import oracle.kv.impl.api.table.TableBuilderBase;
import oracle.kv.table.MapDef;
import org.apache.avro.Schema;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.node.ObjectNode;

public class MapBuilder
extends CollectionBuilder {
    MapBuilder(String description) {
        super(description);
    }

    MapBuilder() {
    }

    @Override
    public String getBuilderType() {
        return "Map";
    }

    @Override
    public MapDef build() {
        if (this.field == null) {
            throw new IllegalArgumentException("Map has no field and cannot be built");
        }
        return new MapDefImpl((FieldDefImpl)this.field, this.description);
    }

    @Override
    TableBuilderBase generateAvroSchemaFields(Schema schema, String name1, JsonNode defaultValue, String desc) {
        Schema elementSchema = schema.getValueType();
        super.generateAvroSchemaFields(elementSchema, elementSchema.getName(), null, elementSchema.getDoc());
        return this;
    }

    public String toJsonString(boolean pretty) {
        ObjectWriter writer = JsonUtils.createWriter(pretty);
        ObjectNode o = JsonUtils.createObjectNode();
        MapDefImpl tmp = new MapDefImpl((FieldDefImpl)this.field, this.description);
        tmp.toJson(o);
        try {
            return writer.writeValueAsString(o);
        }
        catch (IOException ioe) {
            return ioe.toString();
        }
    }
}

