/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.util.Arrays;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.FixedBinaryDefImpl;
import oracle.kv.table.FieldDef;
import oracle.kv.table.FieldValue;
import oracle.kv.table.FixedBinaryDef;
import oracle.kv.table.FixedBinaryValue;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.BinaryNode;

@Persistent(version=1)
class FixedBinaryValueImpl
extends FieldValueImpl
implements FixedBinaryValue {
    private static final long serialVersionUID = 1L;
    private byte[] value;
    private final FixedBinaryDefImpl def;

    FixedBinaryValueImpl(byte[] value, FixedBinaryDefImpl def) {
        this.value = value;
        this.def = def;
    }

    private FixedBinaryValueImpl() {
        this.def = null;
    }

    @Override
    public byte[] get() {
        return this.value;
    }

    @Override
    public FixedBinaryDef getDefinition() {
        return this.def;
    }

    @Override
    public FieldDef.Type getType() {
        return FieldDef.Type.FIXED_BINARY;
    }

    @Override
    public FixedBinaryValueImpl clone() {
        return new FixedBinaryValueImpl(this.value, this.def);
    }

    public boolean equals(Object other) {
        if (other instanceof FixedBinaryValueImpl) {
            FixedBinaryValueImpl otherImpl = (FixedBinaryValueImpl)other;
            return this.def.equals(otherImpl.def) && Arrays.equals(this.value, otherImpl.get());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public int compareTo(FieldValue other) {
        if (other instanceof FixedBinaryValueImpl) {
            return 0;
        }
        throw new ClassCastException("Object is not an FixedBinaryValue");
    }

    @Override
    public JsonNode toJsonNode() {
        return new BinaryNode(this.value);
    }

    @Override
    public FixedBinaryValue asFixedBinary() {
        return this;
    }

    @Override
    public boolean isFixedBinary() {
        return true;
    }

    @Override
    Object toAvroValue(Schema schema) {
        Schema toUse = FixedBinaryValueImpl.getUnionSchema(schema, Schema.Type.FIXED);
        return new GenericData.Fixed(toUse, this.get());
    }
}

