/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import java.io.Serializable;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class FieldMapEntry
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final FieldDefImpl field;
    private final boolean nullable;
    private final FieldValueImpl defaultValue;

    FieldMapEntry(FieldDefImpl field, boolean nullable, FieldValueImpl defaultValue) {
        this.field = field;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        if (!nullable && defaultValue == null) {
            throw new IllegalArgumentException("Not nullable fields require a default value");
        }
    }

    private FieldMapEntry(FieldMapEntry other) {
        this.field = other.field.clone();
        this.nullable = other.nullable;
        this.defaultValue = other.defaultValue != null ? other.defaultValue.clone() : null;
    }

    private FieldMapEntry() {
        this.field = null;
        this.defaultValue = null;
        this.nullable = false;
    }

    FieldDefImpl getField() {
        return this.field;
    }

    boolean isNullable() {
        return this.nullable;
    }

    FieldValueImpl getDefaultValue() {
        return this.defaultValue != null ? this.defaultValue : NullValueImpl.getInstance();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldMapEntry) {
            FieldMapEntry other = (FieldMapEntry)obj;
            return this.field.equals(other.field) && this.nullable == other.nullable && this.defaultsEqual(other);
        }
        return false;
    }

    public int hashCode() {
        return this.field.hashCode() + Boolean.valueOf(this.nullable).hashCode() + this.getDefaultValue().hashCode();
    }

    public FieldMapEntry clone() {
        return new FieldMapEntry(this);
    }

    final JsonNode createAvroTypeAndDefault(ObjectNode node) {
        if (this.isNullable()) {
            ArrayNode arrayNode = node.putArray("type");
            if (this.getDefaultValue().isNull()) {
                arrayNode.add("null");
                arrayNode.add(this.field.mapTypeToAvroJsonNode());
            } else {
                arrayNode.add(this.field.mapTypeToAvroJsonNode());
                arrayNode.add("null");
            }
        } else {
            node.put("type", this.field.mapTypeToAvroJsonNode());
        }
        node.put("default", this.getDefaultValue().toJsonNode());
        return node;
    }

    void toJson(ObjectNode node) {
        this.field.toJson(node);
        node.put("nullable", this.nullable);
        node.put("default", this.getDefaultValue().toJsonNode());
    }

    private boolean defaultsEqual(FieldMapEntry other) {
        return this.getDefaultValue().equals(other.getDefaultValue());
    }
}

