/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.BooleanValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.BooleanDef;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonNode;

@Persistent(version=1)
class BooleanDefImpl
extends FieldDefImpl
implements BooleanDef {
    private static final long serialVersionUID = 1L;

    public BooleanDefImpl(String description) {
        super(FieldDef.Type.BOOLEAN, description);
    }

    public BooleanDefImpl() {
        super(FieldDef.Type.BOOLEAN);
    }

    private BooleanDefImpl(BooleanDefImpl impl) {
        super(impl);
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public BooleanDef asBoolean() {
        return this;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof BooleanDefImpl;
    }

    @Override
    public BooleanDefImpl clone() {
        return new BooleanDefImpl(this);
    }

    @Override
    public BooleanValueImpl createBoolean(boolean value) {
        return new BooleanValueImpl(value);
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isBoolean()) {
            throw new IllegalArgumentException("Default value for type BOOLEAN is not boolean");
        }
        return this.createBoolean(node.getBooleanValue());
    }
}

