/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.table;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.api.table.ArrayValueImpl;
import oracle.kv.impl.api.table.FieldDefImpl;
import oracle.kv.impl.api.table.FieldValueImpl;
import oracle.kv.impl.api.table.JsonUtils;
import oracle.kv.impl.api.table.NullValueImpl;
import oracle.kv.table.ArrayDef;
import oracle.kv.table.FieldDef;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

@Persistent(version=1)
class ArrayDefImpl
extends FieldDefImpl
implements ArrayDef {
    private static final long serialVersionUID = 1L;
    private final FieldDefImpl element;

    ArrayDefImpl(FieldDefImpl element, String description) {
        super(FieldDef.Type.ARRAY, description);
        if (element == null) {
            throw new IllegalArgumentException("Array has no field and cannot be built");
        }
        this.element = element;
    }

    ArrayDefImpl(FieldDefImpl element) {
        this(element, null);
    }

    private ArrayDefImpl(ArrayDefImpl impl) {
        super(impl);
        this.element = impl.element.clone();
    }

    private ArrayDefImpl() {
        this.element = null;
    }

    @Override
    public FieldDef getElement() {
        return this.element;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ArrayDef asArray() {
        return this;
    }

    @Override
    public boolean isValidIndexField() {
        return this.element.isValidIndexField() && !this.element.isArray();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ArrayDefImpl) {
            return this.element.equals(((ArrayDefImpl)other).getElement());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.element.hashCode();
    }

    @Override
    public ArrayDefImpl clone() {
        return new ArrayDefImpl(this);
    }

    @Override
    public ArrayValueImpl createArray() {
        return new ArrayValueImpl(this);
    }

    @Override
    void toJson(ObjectNode node) {
        super.toJson(node);
        ObjectNode collNode = node.putObject("collection");
        if (this.element != null) {
            this.element.toJson(collNode);
        }
    }

    @Override
    public JsonNode mapTypeToAvro(ObjectNode node) {
        if (node == null) {
            node = JsonUtils.createObjectNode();
        }
        node.put("type", "array");
        node.put("items", this.element.mapTypeToAvroJsonNode());
        return node;
    }

    @Override
    FieldValueImpl createValue(JsonNode node) {
        if (node == null || node.isNull()) {
            return NullValueImpl.getInstance();
        }
        if (!node.isArray()) {
            throw new IllegalArgumentException("Default value for type ARRAY is not an array");
        }
        if (node.size() != 0) {
            throw new IllegalArgumentException("Default value for array must be null or an empty array");
        }
        return this.createArray();
    }
}

