/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.api.lob;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.concurrent.TimeUnit;
import oracle.kv.Consistency;
import oracle.kv.ConsistencyException;
import oracle.kv.FaultException;
import oracle.kv.Key;
import oracle.kv.ValueVersion;
import oracle.kv.Version;
import oracle.kv.impl.api.KVStoreImpl;
import oracle.kv.impl.api.lob.ChunkKeysIterator;
import oracle.kv.impl.api.lob.Operation;
import oracle.kv.impl.api.lob.ReadOperation;
import oracle.kv.impl.api.lob.WriteOperation;

public class ChunkEncapsulatingInputStream
extends InputStream {
    private final Version metadataVersion;
    private boolean closed = false;
    private ByteBuffer chunkBuffer = null;
    private final long lobSize;
    private final KVStoreImpl kvsImpl;
    private final Key internalLobKey;
    private final Consistency consistency;
    private final long timeoutMs;
    private final int chunkSize;
    private Key chunkKey = null;
    private final ChunkKeysIterator chunkKeys;
    private Mark mark;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChunkEncapsulatingInputStream(ReadOperation readOp, Version metadataVersion) {
        ChunkEncapsulatingInputStream chunkEncapsulatingInputStream = this;
        synchronized (chunkEncapsulatingInputStream) {
            this.kvsImpl = readOp.getKvsImpl();
            this.internalLobKey = readOp.getInternalLOBKey();
            this.consistency = readOp.getConsistency();
            this.timeoutMs = readOp.getChunkTimeoutMs();
            Operation.LOBProps lobProps = readOp.getLOBProps();
            long numChunks = lobProps.getNumChunks();
            this.chunkKeys = readOp.getChunkKeysNumChunksIterator(numChunks);
            this.chunkSize = readOp.getChunkSize();
            this.lobSize = lobProps.getLOBSize();
            this.chunkBuffer = ByteBuffer.allocate(0);
            this.metadataVersion = metadataVersion;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChunkEncapsulatingInputStream(WriteOperation writeOp, long partialLobSize, Version metadataVersion) {
        ChunkEncapsulatingInputStream chunkEncapsulatingInputStream = this;
        synchronized (chunkEncapsulatingInputStream) {
            this.kvsImpl = writeOp.getKvsImpl();
            this.internalLobKey = writeOp.getInternalLOBKey();
            this.consistency = Consistency.ABSOLUTE;
            this.timeoutMs = writeOp.getChunkTimeoutMs();
            this.chunkKeys = writeOp.getChunkKeysByteRangeIterator(0L, partialLobSize);
            this.chunkSize = writeOp.getChunkSize();
            this.lobSize = partialLobSize;
            this.chunkBuffer = ByteBuffer.allocate(0);
            this.metadataVersion = metadataVersion;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        this.checkForClosedStream();
        return this.ensureBuffer() == -1 ? -1 : 0xFF & this.chunkBuffer.get();
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        this.checkForClosedStream();
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("buffer length: " + b.length + " offset: " + off + " len: " + len);
        }
        if (len == 0) {
            return 0;
        }
        int remainingBytes = this.ensureBuffer();
        if (remainingBytes == -1) {
            return -1;
        }
        int getBytes = Math.min(len, remainingBytes);
        this.chunkBuffer.get(b, off, getBytes);
        return getBytes;
    }

    private int ensureBuffer() throws IOException {
        if (this.atEOS()) {
            return -1;
        }
        int remainingBytes = this.chunkBuffer.remaining();
        if (remainingBytes > 0) {
            return remainingBytes;
        }
        this.chunkBuffer = this.getNextChunk();
        if (this.chunkBuffer != null) {
            return this.ensureBuffer();
        }
        ValueVersion metadata = this.getWithFallback(this.internalLobKey);
        if (metadata == null) {
            throw this.wrapIOE(new ConcurrentModificationException("LOB metadata deleted."));
        }
        if (!metadata.getVersion().equals(this.metadataVersion)) {
            String msg = "LOB metadata changed. Version at start: " + this.metadataVersion + " Version at end: " + metadata.getVersion();
            throw this.wrapIOE(new ConcurrentModificationException(msg));
        }
        return -1;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkForClosedStream();
        if (n <= 0L) {
            return 0L;
        }
        if (this.atEOS()) {
            return 0L;
        }
        int leadBytes = this.chunkBuffer.remaining();
        if (n <= (long)leadBytes) {
            this.chunkBuffer.position(this.chunkBuffer.position() + (int)n);
            return n;
        }
        long startIndex = this.currentByteIndex();
        if (startIndex + n > this.lobSize) {
            n = this.lobSize - startIndex;
        }
        this.chunkBuffer.position(this.chunkBuffer.limit());
        long skipChunkBytes = n - (long)leadBytes;
        int interveningChunks = (int)(skipChunkBytes / (long)this.chunkSize);
        long skippedChunks = this.chunkKeys.skip(interveningChunks);
        if (skippedChunks != (long)interveningChunks) {
            throw new IllegalStateException("Requested skip chunks: " + interveningChunks + " actual bytes: " + skippedChunks);
        }
        this.ensureBuffer();
        int trailBytesRequest = (int)(skipChunkBytes % (long)this.chunkSize);
        long trailBytes = super.skip(trailBytesRequest);
        if ((long)trailBytesRequest != trailBytes) {
            throw new IllegalStateException("Requested skip bytes:" + trailBytesRequest + "actual bytes: " + trailBytes);
        }
        long endIndex = this.currentByteIndex();
        if (endIndex - startIndex != n) {
            throw new IllegalStateException("End index: " + endIndex + " <> startIndex: " + startIndex + " + n: " + n);
        }
        return (long)leadBytes + skippedChunks * (long)this.chunkSize + trailBytes;
    }

    private long currentByteIndex() {
        if (this.chunkKeys.currentChunkIndex() == 0L) {
            return 0L;
        }
        if (this.atEOS()) {
            return this.lobSize;
        }
        return (this.chunkKeys.currentChunkIndex() - 1L) * (long)this.chunkSize + (long)this.chunkBuffer.position();
    }

    private IOException wrapIOE(RuntimeException rte) {
        return new IOException("Exception in LOB input stream", rte);
    }

    private ValueVersion getWithFallback(Key key) throws IOException {
        try {
            ValueVersion valueVersion = null;
            try {
                valueVersion = this.kvsImpl.get(key, this.consistency, this.timeoutMs, TimeUnit.MILLISECONDS);
            }
            catch (ConsistencyException consistencyException) {
                // empty catch block
            }
            if (valueVersion != null) {
                return valueVersion;
            }
            if (!Consistency.ABSOLUTE.equals(this.consistency)) {
                return this.kvsImpl.get(this.chunkKey, Consistency.ABSOLUTE, this.timeoutMs, TimeUnit.MILLISECONDS);
            }
            return valueVersion;
        }
        catch (FaultException fe) {
            throw this.wrapIOE(fe);
        }
    }

    private ByteBuffer getNextChunk() throws IOException {
        if (!this.chunkKeys.hasNext()) {
            return null;
        }
        this.chunkKey = this.chunkKeys.next();
        ValueVersion valueVersion = this.getWithFallback(this.chunkKey);
        if (valueVersion == null) {
            throw this.wrapIOE(new ConcurrentModificationException("Missing LOB  chunk key: " + this.chunkKey + " key iterator: " + this.chunkKeys.toString() + " LOB size: " + this.lobSize));
        }
        return ByteBuffer.wrap(valueVersion.getValue().getValue());
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.isClosed()) {
            return;
        }
        this.mark = new Mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        this.checkForClosedStream();
        if (this.mark == null) {
            throw new IOException("No preceding call to mark");
        }
        if (this.mark.pos == -1) {
            this.chunkBuffer = null;
            return;
        }
        this.chunkKeys.reset(this.mark.savedIterator);
        this.chunkKeys.backup();
        this.chunkBuffer = ByteBuffer.allocate(0);
        if (this.ensureBuffer() != -1) {
            this.chunkBuffer.position(this.mark.pos);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        this.chunkBuffer = null;
    }

    private boolean atEOS() {
        return this.chunkBuffer == null;
    }

    private boolean isClosed() {
        return this.closed;
    }

    private void checkForClosedStream() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream has been closed");
        }
    }

    public synchronized String toString() {
        return "<Chunk Encapsulating stream. chunk key: " + this.chunkKey + (this.chunkBuffer == null ? " EOS " : " remaining bytes: " + this.chunkBuffer.remaining() + " chunk keys: " + this.chunkKeys.toString()) + ">";
    }

    private class Mark {
        private final ChunkKeysIterator savedIterator;
        private final int pos;

        Mark() {
            this((ChunkKeysIterator)chunkEncapsulatingInputStream.chunkKeys.clone(), chunkEncapsulatingInputStream.chunkBuffer != null ? chunkEncapsulatingInputStream.chunkBuffer.position() : -1);
        }

        Mark(ChunkKeysIterator savedIterator, int pos) {
            this.savedIterator = savedIterator;
            this.pos = pos;
        }
    }
}

