/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.kv.impl.admin.webapp.shared.FieldDesc;
import oracle.kv.impl.admin.webapp.shared.ParameterState;
import oracle.kv.impl.admin.webapp.shared.TopologyDTO;

public class TopologyDTO
implements IsSerializable {
    private long timeStamp = new Date().getTime();
    private Map<Integer, Datacenter> datacenterMap = new HashMap();
    private Map<Integer, StorageNode> storageNodeMap = new HashMap();
    private Map<Integer, Map<Integer, RepNode>> repGroupMap = new HashMap();
    private Map<Integer, Admin> adminMap = new HashMap();
    private Policy policy;
    private int nRepNodes = 0;

    public long getTimestamp() {
        return this.timeStamp;
    }

    public void maybeSetTimestamp(long t) {
        if (this.timeStamp < t) {
            this.timeStamp = t;
        }
    }

    public void addDatacenter(int id, String name, int repFactor) {
        this.datacenterMap.put(new Integer(id), new Datacenter(id, name, repFactor, "PRIMARY"));
    }

    public StorageNode addStorageNode(ParameterMap map) {
        StorageNode sn = new StorageNode(map);
        this.storageNodeMap.put(new Integer(sn.getId()), sn);
        return sn;
    }

    public void addRepGroup(int id) {
        this.repGroupMap.put(new Integer(id), new HashMap());
    }

    public RepNode addRepNode(int groupId, int nodeNum, ParameterMap map) {
        RepNode rn = new RepNode(groupId, nodeNum, map);
        ((Map)this.repGroupMap.get(new Integer(groupId))).put(new Integer(nodeNum), rn);
        ++this.nRepNodes;
        return rn;
    }

    public Admin addAdmin(ParameterMap map) {
        Admin a = new Admin(map);
        this.adminMap.put(new Integer(a.getId()), a);
        return a;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public void setPolicy(ParameterMap map) {
        this.policy = new Policy(map);
    }

    public Map<Integer, Datacenter> getDatacenterMap() {
        return this.datacenterMap;
    }

    public Map<Integer, StorageNode> getStorageNodeMap() {
        return this.storageNodeMap;
    }

    public Map<Integer, Map<Integer, RepNode>> getRepGroupMap() {
        return this.repGroupMap;
    }

    public Map<Integer, Admin> getAdminMap() {
        return this.adminMap;
    }

    public int getRepNodeCount() {
        return this.nRepNodes;
    }

    public int getDCIdFromName(String name) {
        for (Integer id : this.datacenterMap.keySet()) {
            if (!((Datacenter)this.datacenterMap.get(id)).getName().equals(name)) continue;
            return id;
        }
        throw new IllegalStateException("Zone missing from topology: " + name);
    }

    public RepNode getRepNode(int groupId, int nodeId) {
        Map rnmap = (Map)this.repGroupMap.get(groupId);
        if (rnmap == null) {
            return null;
        }
        return (RepNode)rnmap.get(nodeId);
    }

    public StorageNode getStorageNode(int snid) {
        return (StorageNode)this.storageNodeMap.get(new Integer(snid));
    }

    public static List<FieldDesc> getDescriptions(ParameterMap map, ParameterState.Info info, boolean showHidden) {
        ArrayList<FieldDesc> fields = new ArrayList<FieldDesc>();
        for (Map.Entry entry : ParameterState.getAllParameters()) {
            ParameterState pinfo = (ParameterState)entry.getValue();
            if (!pinfo.appliesTo(info) || !showHidden && (pinfo.getReadOnly() || pinfo.isHidden())) continue;
            String value = map.get((String)entry.getKey());
            FieldDesc fd = new FieldDesc((String)entry.getKey(), value, !pinfo.getReadOnly());
            fd.setPossibleValues(pinfo.getPossibleValues());
            fields.add(fd);
        }
        return fields;
    }

    public static void applyDescriptions(List<FieldDesc> fields, ParameterMap map, ParameterState.Info info) {
        for (FieldDesc f : fields) {
            ParameterState pinfo = ParameterState.lookup((String)f.getName());
            if (pinfo == null || !pinfo.appliesTo(info) || pinfo.getReadOnly()) continue;
            map.put(f.getName(), f.getValue());
        }
    }
}

