/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.shared;

import java.util.Date;

public class FieldDesc {
    private String name;
    private String value;
    private boolean mutable;
    private boolean sectionTitle = false;
    String[] possibleValues = null;

    FieldDesc(String name, String value, boolean mutable) {
        this.name = name;
        this.value = value;
        this.mutable = mutable;
    }

    public FieldDesc(String name, String value) {
        this(name, value, false);
    }

    FieldDesc(String name, int value, boolean mutable) {
        this(name, Integer.toString(value), mutable);
    }

    FieldDesc(String name, int value) {
        this(name, Integer.toString(value), false);
    }

    FieldDesc(String name, long value, boolean mutable) {
        this(name, Long.toString(value), mutable);
    }

    FieldDesc(String name, long value) {
        this(name, Long.toString(value), false);
    }

    FieldDesc(String name, Date value, boolean mutable) {
        this(name, value.toString(), mutable);
    }

    FieldDesc(String name, Date value) {
        this(name, value.toString(), false);
    }

    FieldDesc(String name, boolean value, boolean mutable) {
        this(name, Boolean.toString(value), mutable);
    }

    FieldDesc(String name, boolean value) {
        this(name, Boolean.toString(value), false);
    }

    FieldDesc(String name) {
        this(name, "", false);
    }

    public FieldDesc(String name, float avg) {
        this(name, Float.toString(avg));
    }

    public void setPossibleValues(String[] v) {
        this.possibleValues = v;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value == null ? "" : this.value;
    }

    public int getValueAsInt() {
        return Integer.parseInt(this.value);
    }

    public long getValueAsLong() {
        return Long.parseLong(this.value);
    }

    public boolean getValueAsBoolean() {
        return Boolean.parseBoolean(this.value);
    }

    public void designateAsSectionTitle() {
        this.sectionTitle = true;
    }

    public boolean isSectionTitle() {
        return this.sectionTitle;
    }

    public boolean isMutable() {
        return this.mutable;
    }
}

