/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import oracle.kv.impl.admin.CommandServiceAPI;
import oracle.kv.impl.util.FileNames;

public class LogDownloadService
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private CommandServiceAPI aservice;

    @Override
    public void init() {
        this.aservice = (CommandServiceAPI)this.getServletContext().getAttribute("AdminService");
    }

    private Logger getLogger() {
        return (Logger)this.getServletContext().getAttribute("AdminLogger");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        File logFile;
        File logDir;
        String rootDirPathname;
        String storeName;
        String logFileName = req.getParameter("log");
        if (logFileName == null) {
            this.reportError(res, "The log parameter is missing from the url", null);
            return;
        }
        if (!(logFileName.endsWith("log") || logFileName.endsWith("perf") || logFileName.endsWith("stat") || logFileName.endsWith("_detail.csv") || logFileName.endsWith("_summary.csv"))) {
            this.reportError(res, "The log parameter has an incorrect suffix.", null);
            return;
        }
        if (logFileName.contains(System.getProperty("file.separator")) || logFileName.contains("/")) {
            this.reportError(res, "The log parameter contains an illegal character.", null);
            return;
        }
        try {
            storeName = this.aservice.getStoreName();
            rootDirPathname = this.aservice.getRootDir();
        }
        catch (RemoteException re) {
            this.reportError(res, "Failure in CommandService", (Exception)re);
            return;
        }
        if (storeName == null || rootDirPathname == null) {
            this.reportError(res, "The Admin is not configured yet.", null);
        }
        if (!(logDir = FileNames.getLoggingDir(new File(rootDirPathname), storeName)).equals((logFile = new File(logDir, logFileName)).getParentFile())) {
            this.reportError(res, "The requested file is not in the log directory.", null);
            return;
        }
        ServletOutputStream out = null;
        InputStream in = null;
        try {
            int len;
            out = res.getOutputStream();
            in = new FileInputStream(logFile);
            res.setContentType("application/octet-stream");
            res.setContentLength((int)logFile.length());
            res.setHeader("Content-Disposition", "attachment; filename=\"" + logFileName + "\"");
            byte[] buf = new byte[4096];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
        catch (Exception e) {
            this.reportError(res, "There was an error delivering the log file: ", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException ioe) {
                this.reportError(res, "Error finalizing download", (Exception)ioe);
            }
        }
    }

    private void reportError(HttpServletResponse res, String message, Exception e) {
        try {
            this.getLogger().log(Level.WARNING, message, e);
            res.sendError(500, message + " " + (e != null ? e.getMessage() : ""));
        }
        catch (IOException ioe) {
            // empty catch block
        }
    }
}

