/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import java.util.List;
import oracle.kv.impl.admin.webapp.client.KVAdminUI;
import oracle.kv.impl.admin.webapp.client.Plans;
import oracle.kv.impl.admin.webapp.shared.PlanDTO;
import oracle.kv.impl.admin.webapp.shared.UpdateInfo;

public class Plans {
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private final KVAdminUI root;
    @UiField
    Panel container;
    @UiField
    Grid historyTable;
    int latestPlanId = 0;

    Plans(KVAdminUI root) {
        this.root = root;
        binder.createAndBindUi((Object)this);
    }

    void display(Panel place) {
        place.clear();
        place.add(this.container);
        this.redisplay();
    }

    public void redisplay() {
        this.root.getRpcService().getRecentPlans(20, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void applyUpdates(UpdateInfo updates) {
        List planHistory = updates.getPlanHistory();
        if (planHistory != null) {
            this.updatePlanHistory(planHistory);
        }
    }

    private synchronized void updatePlanHistory(List<PlanDTO> plans) {
        this.historyTable.clear(true);
        this.historyTable.resize(plans.size() + 1, 5);
        HTMLTable.RowFormatter rf = this.historyTable.getRowFormatter();
        this.historyTable.setWidget(0, 0, new Label("Plan #"));
        this.historyTable.setWidget(0, 1, new Label("Type"));
        this.historyTable.setWidget(0, 2, new Label("Name"));
        this.historyTable.setWidget(0, 3, new Label("State"));
        this.historyTable.setWidget(0, 4, new Label("Action"));
        rf.addStyleName(0, "header-row");
        int currentRow = 1;
        for (PlanDTO p : plans) {
            PlanDTO.State state = p.getState();
            String[] cncomponents = p.getClass().getName().split("\\.");
            cncomponents = cncomponents[cncomponents.length - 1].split("\\$");
            String simpleTypeName = cncomponents[cncomponents.length - 1];
            Anchor a = new Anchor(Integer.toString(p.getId()));
            a.addClickHandler((ClickHandler)new PlanDetailClickHandler(this, p));
            this.historyTable.setWidget(currentRow, 0, a);
            this.historyTable.setWidget(currentRow, 1, new Label(simpleTypeName));
            this.historyTable.setWidget(currentRow, 2, new Label(p.getName()));
            this.historyTable.setWidget(currentRow, 3, new Label(state.toString()));
            ListBox action = null;
            if (state == PlanDTO.State.PENDING || state == PlanDTO.State.APPROVED || state == PlanDTO.State.RUNNING || state == PlanDTO.State.INTERRUPTED || state == PlanDTO.State.ERROR) {
                action = new ListBox();
                action.setVisibleItemCount(1);
                action.addItem("Choose Action");
                switch (2.$SwitchMap$oracle$kv$impl$admin$webapp$shared$PlanDTO$State[state.ordinal()]) {
                    case 1: {
                        action.addItem("Approve Plan");
                        action.addItem("Cancel Plan");
                        break;
                    }
                    case 2: {
                        action.addItem("Execute Plan");
                        action.addItem("Cancel Plan");
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        action.addItem("Retry Plan");
                        action.addItem("Cancel Plan");
                        break;
                    }
                    case 5: {
                        action.addItem("Retry Plan");
                        action.addItem("Cancel Plan");
                        break;
                    }
                    case 6: {
                        action.addItem("Interrupt Plan");
                    }
                }
                action.addChangeHandler((ChangeHandler)new PlanActionChangeHandler(this, p.getId()));
            }
            if (action != null) {
                this.historyTable.setWidget(currentRow, 4, action);
            }
            if (currentRow % 2 == 0) {
                rf.addStyleName(currentRow, "even-row");
            } else {
                rf.addStyleName(currentRow, "odd-row");
            }
            this.latestPlanId = p.getId();
            ++currentRow;
        }
    }

    static /* synthetic */ KVAdminUI access$000(Plans x0) {
        return x0.root;
    }

    static /* synthetic */ void access$100(Plans x0, List x1) {
        x0.updatePlanHistory(x1);
    }
}

