/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.webapp.client;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.NamedFrame;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import com.google.gwt.user.client.ui.RootPanel;
import oracle.kv.impl.admin.webapp.client.ButtonController;
import oracle.kv.impl.admin.webapp.client.ConfigurationForm;
import oracle.kv.impl.admin.webapp.client.Error;
import oracle.kv.impl.admin.webapp.client.Header;
import oracle.kv.impl.admin.webapp.client.KVAdminUI;
import oracle.kv.impl.admin.webapp.client.Monitoring;
import oracle.kv.impl.admin.webapp.client.Navigation;
import oracle.kv.impl.admin.webapp.client.Plans;
import oracle.kv.impl.admin.webapp.client.TopoBrowser;
import oracle.kv.impl.admin.webapp.client.UEHandler;
import oracle.kv.impl.admin.webapp.shared.AdminUIException;
import oracle.kv.impl.admin.webapp.shared.AdminUIService;
import oracle.kv.impl.admin.webapp.shared.AdminUIServiceAsync;
import oracle.kv.impl.admin.webapp.shared.NotMasterException;

public class KVAdminUI
implements EntryPoint {
    private static final String SERVER_ERROR = "An error occurred while attempting to contact the server. Please check your network connection and try again.";
    private static final Binder binder = (Binder)GWT.create(Binder.class);
    private RootLayoutPanel rp;
    private Navigation buttons;
    private Header headerContent;
    private Plans plans;
    private TopoBrowser topoBrowser;
    private Monitoring monitor;
    public Frame dummyFrame;
    private String storeName = null;
    private boolean asyncUpdatesRunning = false;
    private boolean closing = false;
    DockLayoutPanel layout;
    @UiField
    Panel header;
    @UiField
    Panel sidebar;
    @UiField
    Panel display;
    private final AdminUIServiceAsync adminUIService = (AdminUIServiceAsync)GWT.create(AdminUIService.class);

    KVAdminUI() {
        this.buttons = new Navigation(this);
        this.headerContent = new Header(this);
        this.plans = new Plans(this);
        this.topoBrowser = new TopoBrowser(this);
        this.monitor = new Monitoring(this);
        this.dummyFrame = new NamedFrame("dummy");
        this.dummyFrame.setSize("0px", "0px");
        this.dummyFrame.setVisible(false);
    }

    @Override
    public void onModuleLoad() {
        if (GWT.isProdMode()) {
            GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new UEHandler(this));
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.layout = (DockLayoutPanel)binder.createAndBindUi((Object)this);
        this.rp = RootLayoutPanel.get();
        this.rp.add(this.layout);
        RootPanel.get().add(this.dummyFrame);
        this.getConfigurationState();
    }

    private void refreshView() {
        this.header.clear();
        this.sidebar.clear();
        this.display.clear();
        if (this.storeName != null) {
            this.buttons.display(this.sidebar);
            this.headerContent.setDeck("KVStore Name: " + this.storeName);
            this.headerContent.setSuperior("");
            this.headerContent.display(this.header);
            this.showTopology();
            this.topoBrowser.refreshTopologyFromServer();
            this.startAsyncUpdates();
        } else {
            this.headerContent.setDeck("Status: Unconfigured");
            this.headerContent.setSuperior("");
            this.headerContent.display(this.header);
            this.sidebar.add(new HTML("<br/><p>KVAdmin is in bootstrap mode.</p>"));
            this.showConfigurationForm();
        }
    }

    private void getConfigurationState() {
        this.adminUIService.isConfigured((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    void configure(String kvsName, String dcName, int repFactor, ButtonController bc) {
        bc.disableButtons();
        this.adminUIService.configure(kvsName, dcName, repFactor, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showConfigurationForm() {
        new ConfigurationForm(this).display(this.display);
    }

    public void showTopology() {
        this.topoBrowser.display(this.display);
    }

    public void showPlans() {
        this.plans.display(this.display);
    }

    public void showMonitors() {
        this.monitor.display(this.display);
    }

    void displayUncaughtError(Throwable t) {
        String stackReport = "";
        StackTraceElement[] stack = t.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            stackReport = stackReport + stack[i].toString() + "\n";
        }
        this.showError("Unexpected internal exception: " + t.getMessage() + "\n" + stackReport);
    }

    void setStoreName(String name) {
        this.storeName = name;
    }

    AdminUIServiceAsync getRpcService() {
        return this.adminUIService;
    }

    void reportRpcFailure(Throwable caught, String whence) {
        if (this.closing) {
            return;
        }
        if (caught instanceof NotMasterException) {
            NotMasterException nme = (NotMasterException)caught;
            String masterAddress = nme.getMasterHttpAddress();
            if (masterAddress != null) {
                Window.Location.assign(masterAddress.toString());
            } else {
                this.showError(nme.getMessage());
            }
        } else if (caught instanceof AdminUIException) {
            AdminUIException a = (AdminUIException)caught;
            this.showError(a.getMessage() + ": " + a.getCauseMessage(), "caused by: \n" + a.getCauseName() + "\n" + a.getCauseMessage() + "\n" + a.getCauseTrace() + " (from " + whence + ")");
        } else {
            this.showError("An error occurred while attempting to contact the server. Please check your network connection and try again.: " + caught.getMessage() + " (from " + whence + ")");
        }
    }

    void showError(String message) {
        new Error(message, null).display();
    }

    void showError(String message, String detail) {
        new Error(message, detail).display();
    }

    synchronized void startAsyncUpdates() {
        if (this.asyncUpdatesRunning) {
            return;
        }
        long since = this.topoBrowser.getTopologyTimestamp();
        if (since == 0L) {
            4 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(5000);
            return;
        }
        this.asyncUpdatesRunning = true;
        this.retrieveUpdates(since, 0L, 0L);
    }

    private void retrieveUpdates(long topologySince, long logSince, long planSince) {
        this.getRpcService().retrieveUpdates(topologySince, logSince, planSince, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    static /* synthetic */ boolean access$002(KVAdminUI x0, boolean x1) {
        x0.closing = x1;
        return x0.closing;
    }

    static /* synthetic */ void access$100(KVAdminUI x0) {
        x0.refreshView();
    }

    static /* synthetic */ boolean access$202(KVAdminUI x0, boolean x1) {
        x0.asyncUpdatesRunning = x1;
        return x0.asyncUpdatesRunning;
    }

    static /* synthetic */ TopoBrowser access$300(KVAdminUI x0) {
        return x0.topoBrowser;
    }

    static /* synthetic */ Monitoring access$400(KVAdminUI x0) {
        return x0.monitor;
    }

    static /* synthetic */ Plans access$500(KVAdminUI x0) {
        return x0.plans;
    }

    static /* synthetic */ void access$600(KVAdminUI x0, long x1, long x2, long x3) {
        x0.retrieveUpdates(x1, x2, x3);
    }
}

