/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.topo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.kv.impl.admin.IllegalCommandException;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.param.StorageNodePool;
import oracle.kv.impl.admin.topo.TopologyCandidate;
import oracle.kv.impl.admin.topo.Validations;
import oracle.kv.impl.topo.Datacenter;
import oracle.kv.impl.topo.DatacenterId;
import oracle.kv.impl.topo.Partition;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNode;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;

public class Rules {
    public static int MAX_REPLICATION_FACTOR = 20;

    public static Results validate(Topology topo, Parameters params, boolean topoIsDeployed) {
        Results results = new Results();
        HashMap shardsByDC = new HashMap();
        for (Datacenter dc : topo.getSortedDatacenters()) {
            shardsByDC.put(dc.getResourceId(), new HashMap());
        }
        HashMap<StorageNodeId, Set<RepNodeId>> rnsPerSN = new HashMap<StorageNodeId, Set<RepNodeId>>();
        for (RepNode rn : topo.getSortedRepNodes()) {
            StorageNodeId snId = rn.getStorageNodeId();
            StorageNode hostSN = topo.get(snId);
            DatacenterId dcId = hostSN.getDatacenterId();
            RepGroupId repGroupId = rn.getRepGroupId();
            Map shardCount = (Map)shardsByDC.get(dcId);
            Integer count = (Integer)shardCount.get(repGroupId);
            if (count == null) {
                shardCount.put(repGroupId, new Integer(1));
            } else {
                shardCount.put(repGroupId, new Integer(count + 1));
            }
            HashSet rnIds = (HashSet)rnsPerSN.get(snId);
            if (rnIds == null) {
                rnIds = new HashSet();
                rnsPerSN.put(snId, rnIds);
            }
            rnIds.add(rn.getResourceId());
        }
        Set<RepGroupId> allShardIds = topo.getRepGroupIds();
        for (Map.Entry dcInfo : shardsByDC.entrySet()) {
            Set<RepGroupId> shards = ((Map)dcInfo.getValue()).keySet();
            Set<RepGroupId> missing = Rules.relComplement(allShardIds, shards);
            DatacenterId datacenterId = (DatacenterId)dcInfo.getKey();
            int repFactor = topo.get(datacenterId).getRepFactor();
            for (RepGroupId rgId : missing) {
                results.add(new Validations.InsufficientRNs(datacenterId, repFactor, rgId, repFactor));
            }
        }
        for (Map.Entry dcInfo : shardsByDC.entrySet()) {
            DatacenterId dcId = (DatacenterId)dcInfo.getKey();
            int repFactor = topo.get(dcId).getRepFactor();
            for (Map.Entry shardInfo : ((Map)dcInfo.getValue()).entrySet()) {
                int numRNs = (Integer)shardInfo.getValue();
                if (numRNs < repFactor) {
                    results.add(new Validations.InsufficientRNs(dcId, repFactor, (RepGroupId)shardInfo.getKey(), repFactor - numRNs));
                    continue;
                }
                if (numRNs <= repFactor) continue;
                results.add(new Validations.ExcessRNs(dcId, repFactor, (RepGroupId)shardInfo.getKey(), numRNs - repFactor));
            }
        }
        for (RepGroupId rgId : topo.getRepGroupIds()) {
            StorageNodeId snId;
            HashMap rnIdBySNId = new HashMap();
            for (RepNode repNode : topo.get(rgId).getRepNodes()) {
                snId = repNode.getStorageNodeId();
                HashSet rnIds = (HashSet)rnIdBySNId.get(snId);
                if (rnIds == null) {
                    rnIds = new HashSet();
                    rnIdBySNId.put(repNode.getStorageNodeId(), rnIds);
                }
                rnIds.add(repNode.getResourceId());
            }
            for (Map.Entry entry : rnIdBySNId.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1) continue;
                snId = (StorageNodeId)entry.getKey();
                results.add(new Validations.RNProximity(snId, rgId, new ArrayList<RepNodeId>((Collection)entry.getValue())));
            }
        }
        Set<RepGroupId> shardsWithoutPrimaryDC = topo.getRepGroupIds();
        for (Map.Entry dcInfo : shardsByDC.entrySet()) {
            DatacenterId dcId = (DatacenterId)dcInfo.getKey();
            Datacenter datacenter = topo.get(dcId);
            if (!datacenter.getDatacenterType().isPrimary()) continue;
            Map repGroupInfo = (Map)dcInfo.getValue();
            shardsWithoutPrimaryDC.removeAll(repGroupInfo.keySet());
        }
        for (RepGroupId rgId : shardsWithoutPrimaryDC) {
            results.add(new Validations.NoPrimaryDC(rgId));
        }
        CapacityProfile profile = Rules.getCapacityProfile(topo, params);
        for (Validations.RulesProblem p : profile.getProblems()) {
            results.add(p);
        }
        for (Validations.RulesProblem w : profile.getWarnings()) {
            results.add(w);
        }
        int totalPartitions = topo.getPartitionMap().size();
        if (totalPartitions != 0) {
            Set<RepGroupId> allShards = topo.getRepGroupIds();
            int n = allShards.size();
            int minPartitions = Rules.calcMinPartitions(totalPartitions, n);
            int maxPartitions = Rules.calcMaxPartitions(totalPartitions, n);
            HashMap<RepGroupId, AtomicInteger> partCounter = new HashMap<RepGroupId, AtomicInteger>();
            for (RepGroupId rgId : allShards) {
                partCounter.put(rgId, new AtomicInteger(0));
            }
            for (Partition p : topo.getPartitionMap().getAll()) {
                AtomicInteger count = (AtomicInteger)partCounter.get(p.getRepGroupId());
                count.incrementAndGet();
            }
            for (RepGroupId rgId : allShards) {
                int actualCount = ((AtomicInteger)partCounter.get(rgId)).get();
                if (actualCount >= minPartitions && actualCount <= maxPartitions) continue;
                results.add(new Validations.NonOptimalNumPartitions(rgId, actualCount, minPartitions, maxPartitions));
            }
        }
        if (topoIsDeployed) {
            Rules.findMultipleRNsInRootDir(topo, params, results);
            Rules.checkMemoryUsageOnSN(rnsPerSN, params, results);
        }
        return results;
    }

    private static void findMultipleRNsInRootDir(Topology topo, Parameters params, Results results) {
        StorageNodeId snId;
        HashMap<StorageNodeId, ArrayList<RepNodeId>> rnsOnRoot = new HashMap<StorageNodeId, ArrayList<RepNodeId>>();
        for (RepNode repNode : topo.getSortedRepNodes()) {
            snId = repNode.getStorageNodeId();
            RepNodeId rnId = (RepNodeId)repNode.getResourceId();
            RepNodeParams rnp = params.get(rnId);
            if (rnp == null || rnp.getMountPointString() != null) continue;
            ArrayList<RepNodeId> onRoot = (ArrayList<RepNodeId>)rnsOnRoot.get(snId);
            if (onRoot == null) {
                onRoot = new ArrayList<RepNodeId>();
                rnsOnRoot.put(snId, onRoot);
            }
            onRoot.add(rnId);
        }
        for (Map.Entry entry : rnsOnRoot.entrySet()) {
            if (((List)entry.getValue()).size() == 1) continue;
            snId = (StorageNodeId)entry.getKey();
            results.add(new Validations.MultipleRNsInRoot(snId, (List)entry.getValue(), params.get(snId).getRootDirPath()));
        }
    }

    private static void checkMemoryUsageOnSN(Map<StorageNodeId, Set<RepNodeId>> rnsPerSN, Parameters params, Results results) {
        for (Map.Entry<StorageNodeId, Set<RepNodeId>> entry : rnsPerSN.entrySet()) {
            StorageNodeId snId = entry.getKey();
            StorageNodeParams snp = params.get(snId);
            if (snp.getMemoryMB() == 0) continue;
            long totalRNHeapMB = 0L;
            Set<RepNodeId> rnIds = entry.getValue();
            for (RepNodeId rnId : rnIds) {
                RepNodeParams rnp = params.get(rnId);
                if (rnp == null) continue;
                totalRNHeapMB += params.get(rnId).getMaxHeapMB();
            }
            if (totalRNHeapMB <= (long)snp.getMemoryMB()) continue;
            StringBuilder sb = new StringBuilder();
            for (RepNodeId rnId : rnIds) {
                sb.append(rnId).append(" ").append(params.get(rnId).getMaxHeapMB()).append("MB,");
            }
            results.add(new Validations.RNHeapExceedsSNMemory(snId, snp.getMemoryMB(), rnIds, totalRNHeapMB, sb.toString()));
        }
    }

    public static void validateTransition(Topology source, TopologyCandidate candidate, Parameters params) {
        Topology target = candidate.getTopology();
        for (StorageNodeId snId : target.getStorageNodeIds()) {
            if (params.get(snId) != null) continue;
            throw new IllegalCommandException("Topology candidate " + candidate.getName() + " uses " + snId + " but " + snId + " has been removed.");
        }
        Rules.checkAllMountPointsExist(candidate, params);
        if (source.getRepGroupMap().size() == 0) {
            return;
        }
        Collection sourcePartitionIds = source.getPartitionMap().getAllIds();
        Collection targetPartitionIds = target.getPartitionMap().getAllIds();
        if (sourcePartitionIds.size() != 0 && sourcePartitionIds.size() != targetPartitionIds.size()) {
            throw new IllegalCommandException("The current topology has been initialized and has " + sourcePartitionIds.size() + " partitions while the target (" + candidate.getName() + ")has " + targetPartitionIds.size() + " partitions. The number of partitions in a store cannot be" + " changed");
        }
        HashSet mustExistCopy = new HashSet(sourcePartitionIds);
        mustExistCopy.removeAll(targetPartitionIds);
        if (!mustExistCopy.isEmpty()) {
            throw new IllegalCommandException("These partitions are missing from " + candidate.getName() + ":" + mustExistCopy);
        }
        HashSet<RepNodeId> sourceRNsCopy = new HashSet<RepNodeId>(source.getRepNodeIds());
        Set<RepNodeId> targetRNs = target.getRepNodeIds();
        sourceRNsCopy.removeAll(targetRNs);
        if (!sourceRNsCopy.isEmpty()) {
            throw new IllegalCommandException("These RepNodes are missing from " + candidate.getName() + ":" + sourceRNsCopy);
        }
    }

    public static void checkAllMountPointsExist(TopologyCandidate candidate, Parameters params) {
        for (Map.Entry<RepNodeId, String> entry : candidate.getAllMountPoints().entrySet()) {
            RepNodeId rnId = entry.getKey();
            StorageNodeId snId = candidate.getTopology().get(rnId).getStorageNodeId();
            String mountPoint = entry.getValue();
            if (Rules.mountPointExists(mountPoint, params.get(snId).getMountPoints())) continue;
            throw new IllegalCommandException("Topology candidate " + candidate.getName() + " uses storage directory " + snId + ", " + mountPoint + " but it has been removed.");
        }
    }

    private static boolean mountPointExists(String mountPoint, List<String> mpList) {
        for (String mp : mpList) {
            if (!mp.equals(mountPoint)) continue;
            return true;
        }
        return false;
    }

    public static void validateReplicationFactor(int repFactor) {
        if (repFactor <= 0 || repFactor > MAX_REPLICATION_FACTOR) {
            throw new IllegalArgumentException("Illegal replication factor: " + repFactor + ", valid range is 1 to " + MAX_REPLICATION_FACTOR);
        }
    }

    static boolean checkRNPlacement(StorageNodeParams snp, Set<RepNodeId> assignedRNs, int proposedRG, boolean ignoreCapacity, Logger logger) {
        if (!ignoreCapacity && assignedRNs.size() >= snp.getCapacity()) {
            logger.log(Level.FINEST, "{0} capacity={1}, num hosted RNS={2}", new Object[]{snp.getStorageNodeId(), snp.getCapacity(), assignedRNs.size()});
            return false;
        }
        for (RepNodeId r : assignedRNs) {
            if (r.getGroupId() != proposedRG) continue;
            logger.log(Level.FINEST, "{0} already has RN {1} from same shard as {2}", new Object[]{snp.getStorageNodeId(), r, proposedRG});
            return false;
        }
        return true;
    }

    private static Set<RepGroupId> relComplement(Set<RepGroupId> a, Set<RepGroupId> b) {
        HashSet<RepGroupId> copyA = new HashSet<RepGroupId>(a);
        copyA.removeAll(b);
        return copyA;
    }

    static CapacityProfile getCapacityProfile(Topology topo, Parameters params) {
        HashMap<StorageNodeId, Integer> rnCount = new HashMap<StorageNodeId, Integer>();
        for (StorageNodeId snId : topo.getStorageNodeIds()) {
            rnCount.put(snId, new Integer(0));
        }
        for (RepNode rn : topo.getSortedRepNodes()) {
            StorageNodeId snId = rn.getStorageNodeId();
            int currentCount = (Integer)rnCount.get(snId);
            rnCount.put(snId, new Integer(++currentCount));
        }
        CapacityProfile profile = new CapacityProfile();
        for (StorageNodeId snId : topo.getStorageNodeIds()) {
            int count = (Integer)rnCount.get(snId);
            int capacity = params.get(snId).getCapacity();
            profile.noteUtilization(snId, capacity, count);
        }
        return profile;
    }

    static int calcMinPartitions(int totalPartitions, int totalShards) {
        return totalPartitions / totalShards;
    }

    static int calcMaxPartitions(int totalPartitions, int totalShards) {
        int max = totalPartitions / totalShards;
        if (totalPartitions % totalShards != 0) {
            return max + 1;
        }
        return max;
    }

    static int calculateMaximumCapacity(StorageNodePool snPool, Parameters params) {
        int capacityCount = 0;
        for (StorageNodeId snId : snPool.getList()) {
            capacityCount += params.get(snId).getCapacity();
        }
        return capacityCount;
    }

    public static class Results {
        private final List<Validations.RulesProblem> violations = new ArrayList<Validations.RulesProblem>();
        private final List<Validations.RulesProblem> warnings = new ArrayList<Validations.RulesProblem>();

        Results() {
        }

        void add(Validations.RulesProblem p) {
            if (p.isViolation()) {
                this.violations.add(p);
            } else {
                this.warnings.add(p);
            }
        }

        public List<Validations.RulesProblem> getViolations() {
            return this.violations;
        }

        public List<Validations.RulesProblem> getWarnings() {
            return this.warnings;
        }

        public List<Validations.RulesProblem> getProblems() {
            ArrayList<Validations.RulesProblem> all = new ArrayList<Validations.RulesProblem>(this.violations);
            all.addAll(this.warnings);
            return all;
        }

        public int numProblems() {
            return this.violations.size() + this.warnings.size();
        }

        public int numViolations() {
            return this.violations.size();
        }

        public <T extends Validations.RulesProblem> List<T> find(Class<T> problemClass) {
            ArrayList<T> p = new ArrayList<T>();
            for (Validations.RulesProblem rp : this.violations) {
                if (!rp.getClass().equals(problemClass)) continue;
                p.add(problemClass.cast(rp));
            }
            for (Validations.RulesProblem rp : this.warnings) {
                if (!rp.getClass().equals(problemClass)) continue;
                p.add(problemClass.cast(rp));
            }
            return p;
        }

        public <T extends Validations.RulesProblem> List<T> find(Class<T> problemClass, RulesProblemFilter<T> filter) {
            Validations.RulesProblem crp;
            ArrayList<Validations.RulesProblem> p = new ArrayList<Validations.RulesProblem>();
            for (Validations.RulesProblem rp : this.violations) {
                if (!rp.getClass().equals(problemClass) || !filter.match(crp = (Validations.RulesProblem)problemClass.cast(rp))) continue;
                p.add(crp);
            }
            for (Validations.RulesProblem rp : this.warnings) {
                if (!rp.getClass().equals(problemClass) || !filter.match(crp = (Validations.RulesProblem)problemClass.cast(rp))) continue;
                p.add((Validations.RulesProblem)problemClass.cast(rp));
            }
            return p;
        }

        public String toString() {
            int numWarnings;
            if (this.numProblems() == 0) {
                return "No problems";
            }
            StringBuilder sb = new StringBuilder();
            int numViolations = this.violations.size();
            if (numViolations > 0) {
                sb.append(numViolations);
                sb.append(numViolations == 1 ? " violation.\n" : " violations.\n");
                for (Validations.RulesProblem r : this.violations) {
                    sb.append(r).append("\n");
                }
            }
            if ((numWarnings = this.warnings.size()) > 0) {
                sb.append(numWarnings);
                sb.append(numWarnings == 1 ? " warning.\n" : " warnings.\n");
                for (Validations.RulesProblem r : this.warnings) {
                    sb.append(r).append("\n");
                }
            }
            return sb.toString();
        }

        public Results remove(Results other) {
            Results diff = new Results();
            ArrayList<Validations.RulesProblem> pruned = new ArrayList<Validations.RulesProblem>(this.violations);
            pruned.removeAll(other.violations);
            diff.violations.addAll(pruned);
            pruned = new ArrayList<Validations.RulesProblem>(this.warnings);
            pruned.removeAll(other.warnings);
            diff.warnings.addAll(pruned);
            return diff;
        }
    }

    public static interface RulesProblemFilter<T extends Validations.RulesProblem> {
        public boolean match(T var1);
    }

    static class CapacityProfile {
        private int excessCapacity;
        private final List<StorageNodeId> overUtilizedSNs = new ArrayList<StorageNodeId>();
        private final List<StorageNodeId> underUtilizedSNs = new ArrayList<StorageNodeId>();
        private final List<Validations.RulesProblem> problems = new ArrayList<Validations.RulesProblem>();
        private final List<Validations.RulesProblem> warnings = new ArrayList<Validations.RulesProblem>();

        CapacityProfile() {
        }

        public List<Validations.RulesProblem> getWarnings() {
            return this.warnings;
        }

        List<Validations.RulesProblem> getProblems() {
            return this.problems;
        }

        private void noteUtilization(StorageNodeId snId, int snCapacity, int rnCount) {
            int capacityDelta = snCapacity - rnCount;
            this.excessCapacity += capacityDelta;
            if (capacityDelta > 0) {
                Validations.UnderCapacity under = new Validations.UnderCapacity(snId, rnCount, snCapacity);
                this.underUtilizedSNs.add(snId);
                this.warnings.add(under);
            } else if (capacityDelta < 0) {
                Validations.OverCapacity over = new Validations.OverCapacity(snId, rnCount, snCapacity);
                this.overUtilizedSNs.add(snId);
                this.problems.add(over);
            }
        }

        int getExcessCapacity() {
            return this.excessCapacity;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("excess=").append(this.excessCapacity).append("\n");
            sb.append("problems:").append(this.problems).append("\n");
            sb.append("warnings:").append(this.warnings).append("\n");
            return sb.toString();
        }
    }
}

