/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.Set;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.ChangeAdminParamsPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.param.ParameterMap;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class WriteNewAdminParams
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private ChangeAdminParamsPlan plan;
    private ParameterMap newParams;
    private StorageNodeId targetSNId;
    private AdminId aid;

    WriteNewAdminParams() {
    }

    public WriteNewAdminParams(ChangeAdminParamsPlan plan, ParameterMap newParams, AdminId aid, StorageNodeId targetSNId) {
        this.plan = plan;
        this.newParams = newParams;
        this.aid = aid;
        this.targetSNId = targetSNId;
    }

    @Override
    public Task.State doWork() throws Exception {
        PlannerAdmin admin = this.plan.getAdmin();
        Parameters parameters = admin.getCurrentParameters();
        AdminParams current = parameters.get(this.aid);
        ParameterMap currentMap = current.getMap();
        Set<AdminId> needsAction = this.plan.getNeedsActionSet();
        new AdminParams(this.newParams.copy()).setAdminId(this.aid);
        ParameterMap diff = currentMap.diff(this.newParams, true);
        if (currentMap.merge(this.newParams, true) == 0) {
            this.plan.getLogger().info("No difference in Admin parameters");
            return Task.State.SUCCEEDED;
        }
        admin.updateParams(current);
        this.plan.getLogger().info("Changing params for " + this.aid + "y: " + diff);
        StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(parameters, this.targetSNId, admin.getLoginManager());
        sna.newAdminParameters(currentMap);
        needsAction.add(this.aid);
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " write new " + this.aid + " parameters into the Admin database: " + this.newParams.showContents();
    }
}

