/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.plan.MetadataPlan;
import oracle.kv.impl.admin.plan.PlanExecutor;
import oracle.kv.impl.admin.plan.TablePlanGenerator;
import oracle.kv.impl.admin.plan.task.AbstractTask;
import oracle.kv.impl.admin.plan.task.JobWrapper;
import oracle.kv.impl.admin.plan.task.NextJob;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.api.table.TableMetadata;
import oracle.kv.impl.param.DurationParameter;
import oracle.kv.impl.rep.admin.RepNodeAdminAPI;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNode;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.registry.RegistryUtils;
import oracle.kv.util.Ping;

@Persistent
public class WaitForRemoveTableData
extends AbstractTask {
    private static final long serialVersionUID = 1L;
    private MetadataPlan<TableMetadata> plan;
    private RepGroupId groupId;
    private String tableName;

    public WaitForRemoveTableData(MetadataPlan<TableMetadata> plan, RepGroupId groupId, String tableName) {
        this.plan = plan;
        this.groupId = groupId;
        this.tableName = tableName;
    }

    protected WaitForRemoveTableData() {
    }

    @Override
    public boolean continuePastError() {
        return true;
    }

    @Override
    public Callable<Task.State> getFirstJob(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        return this.makeWaitForRemoveTableDataJob(taskId, runner);
    }

    private JobWrapper makeWaitForRemoveTableDataJob(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        return new JobWrapper(taskId, runner, "remove table data"){

            @Override
            public NextJob doJob() {
                return WaitForRemoveTableData.this.waitForRemoveTableData(this.taskId, this.runner);
            }
        };
    }

    private NextJob waitForRemoveTableData(int taskId, PlanExecutor.ParallelTaskRunner runner) {
        AdminParams ap = this.plan.getAdmin().getParams().getAdminParams();
        RepNodeAdminAPI masterRN = null;
        try {
            masterRN = this.getMaster();
            if (masterRN == null) {
                return new NextJob(Task.State.RUNNING, this.makeWaitForRemoveTableDataJob(taskId, runner), ap.getRNFailoverPeriod());
            }
            this.plan.getLogger().log(Level.INFO, "Wait for remove table {0} data for {1}", new Object[]{this.tableName, this.groupId});
            return this.queryForDone(taskId, runner, ap);
        }
        catch (RemoteException e) {
            return new NextJob(Task.State.RUNNING, this.makeWaitForRemoveTableDataJob(taskId, runner), ap.getServiceUnreachablePeriod());
        }
        catch (NotBoundException e) {
            return new NextJob(Task.State.RUNNING, this.makeWaitForRemoveTableDataJob(taskId, runner), ap.getServiceUnreachablePeriod());
        }
    }

    private RepNodeAdminAPI getMaster() throws RemoteException, NotBoundException {
        PlannerAdmin admin = this.plan.getAdmin();
        Topology topology = admin.getCurrentTopology();
        RepNode masterRN = Ping.getMaster(topology, this.groupId);
        if (masterRN == null) {
            return null;
        }
        RegistryUtils registryUtils = new RegistryUtils(topology, admin.getLoginManager());
        return registryUtils.getRepNodeAdmin((RepNodeId)masterRN.getResourceId());
    }

    private NextJob queryForDone(int taskId, PlanExecutor.ParallelTaskRunner runner, AdminParams ap) {
        try {
            RepNodeAdminAPI masterRN = this.getMaster();
            if (masterRN == null) {
                return new NextJob(Task.State.RUNNING, this.makeDoneQueryJob(taskId, runner, ap), ap.getRNFailoverPeriod());
            }
            boolean done = masterRN.removeTableDataComplete(this.tableName);
            this.plan.getLogger().log(Level.INFO, "Remove table {0} on {1} done={2}", new Object[]{this.tableName, this.groupId, done});
            return done ? NextJob.END_WITH_SUCCESS : new NextJob(Task.State.RUNNING, this.makeDoneQueryJob(taskId, runner, ap), this.getCheckIndexTime(ap));
        }
        catch (RemoteException e) {
            return new NextJob(Task.State.RUNNING, this.makeDoneQueryJob(taskId, runner, ap), ap.getServiceUnreachablePeriod());
        }
        catch (NotBoundException e) {
            return new NextJob(Task.State.RUNNING, this.makeDoneQueryJob(taskId, runner, ap), ap.getServiceUnreachablePeriod());
        }
    }

    private JobWrapper makeDoneQueryJob(int taskId, PlanExecutor.ParallelTaskRunner runner, final AdminParams ap) {
        return new JobWrapper(taskId, runner, "query add index done"){

            @Override
            public NextJob doJob() {
                return WaitForRemoveTableData.this.queryForDone(this.taskId, this.runner, ap);
            }
        };
    }

    private DurationParameter getCheckIndexTime(AdminParams ap) {
        return ap.getCheckAddIndexPeriod();
    }

    @Override
    public String toString() {
        return TablePlanGenerator.makeName("WaitForRemoveTableData", this.tableName, null);
    }
}

