/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.StorageNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.ConfigurableService;
import oracle.kv.impl.util.ServiceUtils;

@Persistent(version=1)
public class WaitForAdminState
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AdminId targetAdminId;
    private ConfigurableService.ServiceStatus targetState;
    private AbstractPlan plan;
    private StorageNodeId snId;

    public WaitForAdminState() {
    }

    public WaitForAdminState(AbstractPlan plan, StorageNodeId snId, AdminId targetAdminId, ConfigurableService.ServiceStatus desiredState) {
        this.plan = plan;
        this.targetAdminId = targetAdminId;
        this.snId = snId;
        this.targetState = desiredState;
    }

    @Override
    public Task.State doWork() throws Exception {
        Parameters parameters = this.plan.getAdmin().getCurrentParameters();
        StorageNodeParams snp = parameters.get(this.snId);
        AdminParams ap = this.plan.getAdmin().getParams().getAdminParams();
        long waitSeconds = ap.getWaitTimeoutUnit().toSeconds(ap.getWaitTimeout());
        String msg = "Waiting " + waitSeconds + " seconds for Admin" + this.targetAdminId + " to reach " + (Object)((Object)this.targetState);
        this.plan.getLogger().fine(msg);
        try {
            ServiceUtils.waitForAdmin(snp.getHostname(), snp.getRegistryPort(), this.plan.getLoginManager(), waitSeconds, this.targetState);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                throw (InterruptedException)e;
            }
            this.plan.getLogger().info("Timed out while " + msg);
            return Task.State.ERROR;
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public String toString() {
        return super.toString() + " waits for Admin " + this.targetAdminId + " to reach " + (Object)((Object)this.targetState) + " state";
    }

    @Override
    public boolean continuePastError() {
        return true;
    }
}

