/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.HashSet;
import oracle.kv.KVVersion;
import oracle.kv.impl.admin.Admin;
import oracle.kv.impl.admin.TopologyCheck;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.param.RepNodeParams;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.fault.OperationFaultException;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.topo.Topology;
import oracle.kv.impl.util.VersionUtil;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class VerifyBeforeMigrate
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private StorageNodeId oldSN;
    private StorageNodeId newSN;

    VerifyBeforeMigrate() {
    }

    public VerifyBeforeMigrate(AbstractPlan plan, StorageNodeId oldSN, StorageNodeId newSN) {
        this.plan = plan;
        this.oldSN = oldSN;
        this.newSN = newSN;
    }

    @Override
    public String getName() {
        return "VerifyBeforeMigrate";
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public Task.State doWork() throws Exception {
        Admin admin = (Admin)this.plan.getAdmin();
        Parameters params = admin.getCurrentParameters();
        Topology topo = admin.getCurrentTopology();
        RegistryUtils regUtils = new RegistryUtils(topo, admin.getLoginManager());
        String errorMsg = this.newSN + " cannot be contacted. Please ensure " + "that it is deployed and running before attempting to migrate " + "to this storage node: ";
        KVVersion newVersion = null;
        try {
            StorageNodeAgentAPI newSNA = regUtils.getStorageNodeAgent(this.newSN);
            newVersion = newSNA.ping().getKVVersion();
        }
        catch (RemoteException e) {
            throw new OperationFaultException(errorMsg + e);
        }
        catch (NotBoundException e) {
            throw new OperationFaultException(errorMsg + e);
        }
        if (VersionUtil.compareMinorVersion(KVVersion.CURRENT_VERSION, newVersion) > 0) {
            throw new OperationFaultException("Cannot migrate " + this.oldSN + " to " + this.newSN + " because " + this.newSN + " is at older version " + newVersion + ". Please upgrade " + this.newSN + " to a version that is equal or greater than " + KVVersion.CURRENT_VERSION);
        }
        HashSet<RepNodeId> hostedRNs = new HashSet<RepNodeId>();
        for (RepNodeParams rnp : params.getRepNodeParams()) {
            if (!rnp.getStorageNodeId().equals(this.oldSN) && !rnp.getStorageNodeId().equals(this.newSN)) continue;
            hostedRNs.add(rnp.getRepNodeId());
        }
        for (RepNodeId rnId : hostedRNs) {
            Utils.verifyShardHealth(params, topo, rnId, this.oldSN, this.newSN, this.plan.getLogger());
        }
        TopologyCheck checker = new TopologyCheck(this.plan.getLogger(), topo, params);
        for (RepNodeId rnId : hostedRNs) {
            StorageNodeId currentHost;
            TopologyCheck.Remedy remedy = checker.checkRNLocation(admin, this.newSN, rnId, false, true);
            if (remedy.getType() != TopologyCheck.REMEDY_TYPE.OKAY) {
                throw new OperationFaultException(rnId + " has inconsistent location metadata. Please " + "run plan repair-topology : " + remedy);
            }
            if (remedy.getJEHAInfo() == null || (currentHost = remedy.getJEHAInfo().getSNId()).equals(this.oldSN) || currentHost.equals(this.newSN)) continue;
            throw new OperationFaultException(rnId + " has inconsistent location metadata. " + " and is living on " + currentHost + " rather than " + this.oldSN + " or " + this.newSN + "Please run plan repair-topology");
        }
        AdminId adminToCheck = null;
        for (AdminParams ap : params.getAdminParams()) {
            if (!ap.getStorageNodeId().equals(this.oldSN) && !ap.getStorageNodeId().equals(this.newSN)) continue;
            adminToCheck = ap.getAdminId();
        }
        if (adminToCheck != null) {
            StorageNodeId currentHost;
            TopologyCheck.Remedy remedy = checker.checkAdminMove(admin, adminToCheck, this.oldSN, this.newSN);
            if (remedy.getType() != TopologyCheck.REMEDY_TYPE.OKAY) {
                throw new OperationFaultException(adminToCheck + " has inconsistent location metadata. Please " + "run plan repair-topology : " + remedy);
            }
            if (remedy.getJEHAInfo() != null && !(currentHost = remedy.getJEHAInfo().getSNId()).equals(this.oldSN) && !currentHost.equals(this.newSN)) {
                throw new OperationFaultException(adminToCheck + " has inconsistent location metadata. " + " and is living on " + currentHost + " rather than " + this.oldSN + " or " + this.newSN + "Please run plan repair-topology");
            }
        }
        return Task.State.SUCCEEDED;
    }
}

