/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import java.util.List;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.plan.DeployTopoPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.topo.RepGroupId;
import oracle.kv.impl.topo.RepNodeId;
import oracle.kv.impl.topo.Topology;

@Persistent
public class UpdateNthRNHelperHost
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private DeployTopoPlan plan;
    private int planShardIdx;
    private int nthRN;

    public UpdateNthRNHelperHost(DeployTopoPlan plan, int planShardIdx, int nthRN) {
        this.plan = plan;
        this.planShardIdx = planShardIdx;
        this.nthRN = nthRN;
    }

    private UpdateNthRNHelperHost() {
    }

    @Override
    public Task.State doWork() throws Exception {
        PlannerAdmin admin = this.plan.getAdmin();
        Topology topo = admin.getCurrentTopology();
        RepGroupId rgId = this.plan.getShardId(this.planShardIdx);
        List<RepNodeId> rnList = topo.getSortedRepNodeIds(rgId);
        RepNodeId rnId = rnList.get(this.nthRN);
        Utils.updateHelperHost(admin, topo, rgId, rnId, this.plan.getLogger());
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }
}

