/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.persist.model.Persistent;
import oracle.kv.impl.admin.NonfatalAssertionException;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.admin.plan.task.Utils;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent
public class UpdateAdminHelperHost
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private AdminId aid;

    public UpdateAdminHelperHost(AbstractPlan plan, AdminId aid) {
        this.plan = plan;
        this.aid = aid;
    }

    private UpdateAdminHelperHost() {
    }

    @Override
    public Task.State doWork() throws Exception {
        PlannerAdmin admin = this.plan.getAdmin();
        Parameters p = admin.getCurrentParameters();
        AdminParams ap = p.get(this.aid);
        if (ap == null) {
            throw new NonfatalAssertionException("Can't find Admin " + this.aid + " in the Admin database.");
        }
        String helpers = Utils.findAdminHelpers(p, this.aid);
        if (helpers.length() == 0) {
            return Task.State.SUCCEEDED;
        }
        AdminParams newAp = new AdminParams(ap.getMap().copy());
        newAp.setHelperHost(helpers);
        admin.updateParams(newAp);
        this.plan.getLogger().info("Changed helperHost for " + this.aid + " to " + helpers);
        StorageNodeId snid = newAp.getStorageNodeId();
        StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(p, snid, this.plan.getLoginManager());
        sna.newAdminParameters(newAp.getMap());
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " update helper hosts for " + this.aid;
    }
}

