/*
 * Decompiled with CFR 0.152.
 */
package oracle.kv.impl.admin.plan.task;

import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.persist.model.Persistent;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import oracle.kv.impl.admin.PlannerAdmin;
import oracle.kv.impl.admin.param.AdminParams;
import oracle.kv.impl.admin.param.Parameters;
import oracle.kv.impl.admin.plan.AbstractPlan;
import oracle.kv.impl.admin.plan.ChangeAdminParamsPlan;
import oracle.kv.impl.admin.plan.task.SingleJobTask;
import oracle.kv.impl.admin.plan.task.Task;
import oracle.kv.impl.sna.StorageNodeAgentAPI;
import oracle.kv.impl.topo.AdminId;
import oracle.kv.impl.topo.StorageNodeId;
import oracle.kv.impl.util.registry.RegistryUtils;

@Persistent(version=1)
public class StopAdmin
extends SingleJobTask {
    private static final long serialVersionUID = 1L;
    private AbstractPlan plan;
    private StorageNodeId snId;
    private AdminId adminId;
    private boolean continuePastError;

    public StopAdmin(AbstractPlan plan, StorageNodeId snId, AdminId adminId, boolean continuePastError) {
        this.plan = plan;
        this.snId = snId;
        this.adminId = adminId;
        this.continuePastError = continuePastError;
    }

    StopAdmin() {
    }

    @Override
    public Task.State doWork() throws Exception {
        boolean needsAction = true;
        if (this.plan instanceof ChangeAdminParamsPlan) {
            needsAction = ((ChangeAdminParamsPlan)this.plan).getNeedsActionSet().contains(this.adminId);
        }
        if (needsAction) {
            final PlannerAdmin admin = this.plan.getAdmin();
            if (this.adminId.equals(admin.getParams().getAdminParams().getAdminId())) {
                new StoppableThread("StopAdminThread"){

                    @Override
                    public void run() {
                        admin.awaitPlan(StopAdmin.this.plan.getId(), 10000, TimeUnit.SECONDS);
                        admin.stopAdminService(false);
                    }

                    @Override
                    protected Logger getLogger() {
                        return StopAdmin.this.plan.getLogger();
                    }
                }.start();
                return Task.State.INTERRUPTED;
            }
            Parameters parameters = admin.getCurrentParameters();
            AdminParams ap = parameters.get(this.adminId);
            ap.setDisabled(true);
            admin.updateParams(ap);
            StorageNodeAgentAPI sna = RegistryUtils.getStorageNodeAgent(parameters, this.snId, this.plan.getLoginManager());
            sna.stopAdmin(false);
        }
        return Task.State.SUCCEEDED;
    }

    @Override
    public boolean continuePastError() {
        return this.continuePastError;
    }

    @Override
    public String toString() {
        return super.toString() + " shutdown " + this.adminId;
    }
}

